﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
//@Override this is suggested by Microsoft, overriding the initialize culture function (that is
//automatically called by the aspx.
//Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
//(English).
protected override void InitializeCulture()
{
    HttpCookie lang = Request.Cookies["siteLanguage"]; 
    
    String selectedLanguage = (lang != null) ? lang.Value : "en";
    UICulture = selectedLanguage ;
    Culture = selectedLanguage ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(selectedLanguage);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(selectedLanguage);
    base.InitializeCulture();
}
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
    
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<script id="main_template" type="text/x-handlebars-template">

    <link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css") %>" rel="stylesheet" />
    <link href="<%= ResolveUrl("~/assets/libs/js/jquery.timepicker/jquery.timepicker.css") %>" rel="stylesheet" />

    <style>

        .clickeable-row{
            cursor:pointer; 
        }

        .backgrid th{
            font-size:12px !important;
        }

        .backgrid tr{
            font-size:12px !important;
        }

        .backgrid tr td{
            overflow:visible !important; 
        }

        .backgrid tr td button{
            font-size:12px !important;
        }

        .backgrid td {
            width:150px !important; 
        }

        .backgrid td.actions-cell {
            width:30px !important;
        }
        .backgrid td.order-cell {
            width:30px !important;
        }
        .backgrid td.weight-cell {
            width:50px !important;
        }

        .table tbody tr.disabled>td{background-color:#bebebe;opacity:0.5;}
        .table-hover tbody tr.disabled:hover > td{background-color:#bebebe;color:#000;}

        .toolbar-filter {
            display:inline-block;
        }

    </style>
    <div id="recipes_screen_container">
    </div>
</script>

<script id="recipe_list_template" type="text/x-handlebars-template">
    <div class="container-fluid">
        <div class="span12">
            <div class="row-fluid">
                <div class="recipes-grid-container">
                </div>
            </div>
        </div>
    </div>
</script>

<script id="recipe_create_edit_template" type="text/x-handlebars-template">
    <div class="container-fluid">
        <div class="row-fluid">
            <div class="row-fluid">
                <div style="display:inline-block;float:left;">
                    <button class="btn btn-medium btn-back-to-list"><i class="icon-arrow-left"></i>
                        <asp:Localize runat="server" meta:resourcekey="back_to_list_label" />
                    </button>
                </div>
                <div style="display:inline-block;float:right;">
                    {{#if permissions.download_recipe}}
                    <button style="margin-left:10px;position:relative;" class="btn btn-info btn-download-recipe">
                        <i class="fa fa-download" aria-hidden="true"></i>
                        <asp:Localize runat="server" meta:resourcekey="download_btn_label" />
                    </button>
                    {{/if}}
                </div>
            </div>
            <div style="width:100%;height:1px;background-color:#ccc;margin-bottom:8px;margin-top:8px;"></div>
        </div>
        <div class="row-fluid">
            <div class="span12">
                <form class="form-inline text-left" style="display:inline-block;top:7px;position:relative;">
                    <label style="margin-bottom:0 !important;">
                        <asp:Localize runat="server" meta:resourcekey="name_label" /> 
                        <input data-bind="value: name, disabled: used" type="text" class="name-input input-medium"  />
                    </label>
                    <label style="margin-left:10px;margin-bottom:0 !important;">
                        <asp:Localize runat="server" meta:resourcekey="grade_label" /> 
                            <select data-bind="disabled: used, value: grade, options: gradesList, optionsDefault: { label: '<asp:Localize runat=server meta:resourcekey=select_grade_label />', value: -1 }" class="grade-select" style="width:220px;">
                            </select>
                    </label>
                    <label style="margin-left:10px;margin-bottom:0 !important;">
                        <asp:Localize runat="server" meta:resourcekey="charges_label" /> 
                            <select data-bind="disabled: used, value: integer(chargesQty), options: chargesQtyList, optionsDefault: { label: '<asp:Localize runat=server meta:resourcekey=select_chargesQty_label />', value: -1 }" class="charges-select"  style="width:50px;">
                            </select>
                    </label>
                    <label style="margin-left:10px;margin-bottom:0 !important;">
                        <asp:Localize runat="server" meta:resourcekey="active_label" />
                        <input data-bind="checked: active" type="checkbox" class="input-medium" />
                    </label>
                </form>
                <div class="pull-right" style="top:5px;position:relative;">
                    <button class="btn btn-medium btn-primary btn-save-recipe">
                        <asp:Localize runat="server" meta:resourcekey="save_recipe_label" />
                    </button>
                    <button data-bind="toggle: equals(mode, 'EDIT'), disabled: used, attr: { title: deleteTitle }" class="btn btn-medium btn-danger btn-delete-recipe">
                        <asp:Localize runat="server" meta:resourcekey="delete_recipe_label" />
                    </button>
                </div>
            </div>
        </div>
        <hr style="margin-top:8px;margin-bottom:15px;" />
        <div class="row-fluid">
            <div class="container-fluid">
                <div class="row-fluid" data-bind="collection: $charges, itemView: 'recipeCreateEditTableView'">
                </div>
            </div>
        </div>
    </div>
</script>

<script id="recipe_create_edit_table_view" type="text/x-handlebars-template">
    <style>
    </style>
    
    <div class="row-fluid">
        <div class="row-fluid">
            <h4 class="pull-left">
                <asp:Localize runat="server" meta:resourcekey="charge_label" /> <span data-bind="text: number"></span>
                |
                <asp:Localize runat="server" meta:resourcekey="total_label" />: <span data-bind="text: total"></span> kg
            </h4>
            {{#if permissions.edit}}
            <button class="pull-right btn btn-medium btn-add-layer" >
                <i class="icon-plus"></i>
                <asp:Localize runat="server" meta:resourcekey="add_layer_label" />
            </button>
            {{/if}}
        </div>
        <div class="charge-grid-container"></div>
    </div>
    <div style="width:100%;height:4px;background-color:#ccc;margin-bottom:20px;margin-top:5px;"></div>

    <script id="actions_cell_template" type="text/x-handlebars-template">
        <div>
            {{#if permissions.edit}}
            <div class="pull-left">
                <button data-toggle="tooltip" data-placement="bottom" title="<asp:Localize runat=server meta:resourcekey=remove_layer_title />" class="btn btn-cell-action btn-small btn-remove-layer"><i class="icon-trash"></i></button>
            </div>
            <div class="pull-right">
                <button data-toggle="tooltip" data-placement="bottom" title="<asp:Localize runat=server meta:resourcekey=move_up_layer_title />" class="btn btn-cell-action btn-small btn-move-up-layer"><i class="icon-arrow-up"></i></button>
                <button data-toggle="tooltip" data-placement="bottom" title="<asp:Localize runat=server meta:resourcekey=move_down_layer_title />" class="btn btn-cell-action btn-small btn-move-down-layer"><i class="icon-arrow-down"></i></button>
            </div>
            {{/if}}
            
        </div>
    </script>
</script>


<script id="subnavbar_controls" type="text/x-handlebars-template">
    

    <div class="span12">
        <div class="subnavbar-toolbar">
            <div class="row-fluid">
                <div style="display: inline-block; height: 40px;" class="pull-left">
                    <%--<div class="toolbar-filter">
                        <label style="display: inline-block; margin-left: 10px; line-height: 40px;"><asp:Localize runat="server" meta:resourcekey="grade_group_label" /></label>
                        <select style="margin-left: 10px; top: 3px; position: relative;" data-bind="value: integer(gradeGroupId), options: gradeGroups, optionsDefault: { label: '<asp:Localize runat=server meta:resourcekey=all_grade_groups_label />', value: -1 }" id="selectbasic" name="selectbasic" class="input-medium">
                        </select>
                    </div>--%>
                    <div class="toolbar-filter">
                        <label style="display: inline-block; margin-left: 10px; line-height: 40px;"><asp:Localize runat="server" meta:resourcekey="grade_combo_label" /></label>
                        <select style="margin-left: 10px; top: 3px; position: relative;" data-bind="value: integer(gradeId), options: gradesList, optionsDefault: { label: '<asp:Localize runat=server meta:resourcekey=all_grades_label />', value: -1 }" id="select1" name="selectbasic" class="input-medium">
                        </select>
                    </div>
                    <div class="toolbar-filter">
                        <label style="display: inline-block; margin-left: 10px; line-height: 40px;"><asp:Localize runat="server" meta:resourcekey="chargesQty_combo_label" /></label>
                        <select style="margin-left: 10px; top: 3px; position: relative;" data-bind="value: integer(chargesQty)" id="select2" name="selectbasic" class="input-medium">
                            <option value="-1"><asp:Localize runat="server" meta:resourcekey="chargesQty_combo_all_option" /></option>
                            <option value="1">1</option>
                            <option value="2">2</option>
                            <option value="3">3</option>
                            <option value="4">4</option>
                        </select>
                    </div>
                    <div class="toolbar-filter">
                        {{#if permissions.download_all}}
                        <button style="margin-left:10px;top:-5px;position:relative;" class="btn btn-info btn-download-all-recipes">
                            <i class="fa fa-download" aria-hidden="true"></i>
                            <asp:Localize runat="server" meta:resourcekey="download_all_btn_label" />
                        </button>
                        {{/if}}
                    </div>
                    <%--<div class="toolbar-filter">
                        <label style="display: inline-block; margin-left: 10px; line-height: 40px;"><asp:Localize runat="server" meta:resourcekey="active_combo_label" /></label>
                        <select style="margin-left: 10px; top: 3px; position: relative;" data-bind="value: integer(activeFilter)" id="select2" name="selectbasic" class="input-medium">
                            <option value="-1">Todas</option>
                            <option value="1">Activas</option>
                            <option value="0">No Activas</option>
                        </select>
                    </div>--%>
                </div>
                <div style="display:inline-block;float:right;" class="subnavbar-button">
                    {{#if permissions.edit}}
                    <button class="btn add-item">
                        <asp:Localize runat="server" meta:resourcekey="new_recipe_label" />
                    </button>
                    {{/if}}
                </div>
            </div>
        </div>
    </div>
</script>

<script id="create_recipe_loading_modal_template" type="text/x-handlebars-template">
    <style>
        .modal-wider {
            width:780px;
            margin-left:-390px;
            margin-top:-30px;
        }
    </style>
    <div class="modal-header noselect">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3><asp:Localize runat="server" meta:resourcekey="new_recipe_label" /></h3>
    </div>
    <div style="max-height:450px;min-height:350px;" class="modal-body noselect">
        <div class="row-fluid">
            <div class="span12">
                <div style="text-align:center;margin-top:10px;">
                    <i class="fa fa-5x fa-cog fa-spin"></i><br />
                    <span style="font-size: 20px;top:3px;position:relative;">Loading...</span>
                </div>
            </div>
        </div>
    </div>
</script>

<%--<script id="create_recipe_modal_template" type="text/x-handlebars-template">
    <style>
        .modal-wider {
            width:780px;
            margin-left:-390px;
            margin-top:-30px;
        }

        .clickeable-row{
            cursor:pointer; 
        }
    </style>
    <div class="modal-header noselect">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3>Nueva Receta</h3>
    </div>
    <div class="modal-body noselect">
        <div class="container-fluid">
            <form class="form-inline text-center">
                <label style="margin-bottom:0 !important;">
                    Nombre: <input autofocus="autofocus" type="text" class="name-input input-medium" />
                </label>
                <label style="margin-left:10px;margin-bottom:0 !important;">
                    Grado: 
                    <select class="grade-select input-medium">
                        {{#each grades}}
                        <option value="{{id}}">{{name}}</option>
                        {{/each}}
                    </select>
                </label>
                <label style="margin-left:10px;margin-bottom:0 !important;">
                    Cestas: 
                    <select class="charges-select input-small">
                        <option value="1">1</option>
                        <option value="2">2</option>
                        <option value="3">3</option>
                        <option value="4">4</option>
                    </select>
                </label>
            </form>
        </div>
    </div>
    <div class="modal-footer noselect">        
        <div class="row-fluid">
            <div class="row-fluid">
                <div class="float-right">
                    <button class="btn-create btn btn-medium btn-success">
                        Crear
                    </button>
                    <button class="btn-close btn btn-medium btn-danger">
                        Cancelar
                    </button>
                </div>                
            </div>
        </div>
    </div>
</script>--%>