﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
//@Override this is suggested by Microsoft, overriding the initialize culture function (that is
//automatically called by the aspx.
//Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
//(English).
protected override void InitializeCulture()
{
    HttpCookie lang = Request.Cookies["siteLanguage"]; 
    
    String selectedLanguage = (lang != null) ? lang.Value : "en";
    UICulture = selectedLanguage ;
    Culture = selectedLanguage ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(selectedLanguage);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(selectedLanguage);
    base.InitializeCulture();
}
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
    
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>
<script id="main_template" type="text/x-handlebars-template">

<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/extensions/valid-min-max-cell/backgrid-valid-min-max-cell.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/app/custom-screens/scrapyard/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + ".css")%>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/bootstrap-timepicker/css/bootstrap-timepicker.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/autocomplete/backbone.autocomplete.css") %>" rel="stylesheet" />

<style>

    .clickeable-row{
        cursor:pointer; 
    }

    .backgrid th{
        font-size:12px !important;
    }

    .backgrid tr{
        font-size:12px !important;
    }

    .backgrid tr td{
        overflow:visible !important; 
    }

    .backgrid tr td button{
        font-size:12px !important;
    }

    .affix-theader{
        position:fixed;
    }

    .affix-theader th{
        width:50px;
    }

</style>

<div class="container-fluid">
    <div class="row-fluid" data-bind="classes: { hide: not(isNull(itemId)), }," style="margin-bottom:20px;">
        <div class="row-fluid">
           <div style="margin-top:7%; z-index:1000; position:absolute;" class="row-fluid loading-poster text-center">
                <div style="width:40%; margin: 0 auto; " class="progress progress-striped active">
                    <div class="bar" style="width: 100%;"></div>
                </div>
            </div>
            <div class="items-grid-container infinite-container">
            </div>
        </div>
    </div>
    <div class="row-fluid" data-bind="classes: { hide: not(isNotNull(itemId)), },">
        <div class="row-fluid">
            <div class="offset1 span10 item-grid-container"></div>
        </div>
        <div class="row-fluid">
            <div class="offset3 span6 item-details-grid-container" style="margin-top:20px;"></div>
        </div>
    </div>
</div>

</script>


<script type="text/x-handlebars-template" id="subnavbar_controls">
    
    <div class="row-fluid">
        <div class="span8">
            <div class="row-fluid" data-bind="classes: { hide: not(isNull(screen_itemId)), },">
                <div class="span1">
                    <button id="shiftViewBtn" class="btn btn-primary btn-left" style="margin-bottom:5px;margin-left:5px;" data-bind="classes: { hide: shiftNavigation , }">
                        <asp:Localize runat="server" meta:resourcekey="shift_view_btn_label" />
                    </button> 
                    <button id="searchViewBtn" class="btn btn-primary btn-left" style="margin-bottom:5px;margin-left:5px;" data-bind="classes: { hide: not(shiftNavigation) , }">
                            <asp:Localize runat="server" meta:resourcekey="search_view_btn_label" />
                    </button> 
                </div>
                <div class="span1" style="margin-right:-60px;">
                <div style="margin-top:12px;" data-bind="classes: { hide: shiftNavigation , }">
                     <span>
                        <asp:Localize runat="server" meta:resourcekey="from_label" />
                     </span>
                </div>
                    <button id="backNavBtn" class="btn btn-primary " style="margin-bottom:5px;" data-bind="classes: { hide: not(shiftNavigation), }">
                        <asp:Localize runat="server" meta:resourcekey="back_item_btn_label" />
                    </button> 

                </div>
                <div class="span2">
                    <div style="width:150px;margin-top:5px;" class="from-date-control-container"></div>
                </div>


                <div class="span2" style="margin-top:5px;margin-right:-40px;" data-bind="classes: { hide: shiftNavigation , }">
                     <div class="input-group bootstrap-timepicker timepicker"  >
                        <label class="input-prepend"> 
                            <span class="add-on"><i class="icon-time"></i></span>
                            <input id="fromTimePicker" type="text" style="width:65px;" class="form-control input-small" data-bind="value: fromTime">
                        </label>    
                    </div>
                </div>
                <div class="span2" style="margin-right:-120px;" data-bind="classes: { hide: not(shiftNavigation), }">
                    <input type="text" style="width:20px; text-align:center; margin-top: 5px;" data-bind="value: shiftId"  readonly />
                </div>


                <div class="span1" style="margin-top:12px;margin-right:-70px;" data-bind="classes: { hide: shiftNavigation , }">
                    <span>
                        <asp:Localize runat="server" meta:resourcekey="to_label" />
                    </span>
                </div>
                <div class="span2" style="margin-right:-120px;" data-bind="classes: { hide: not(shiftNavigation), }">
                    <button id="forwardNavBtn" class="btn btn-primary" style="margin-bottom:5px;" >
                        <asp:Localize runat="server" meta:resourcekey="forward_item_btn_label" />
                    </button>
                </div>


                <div class="span2" data-bind="classes: { hide: shiftNavigation , }"> 
                     <div style="width:150px;margin-top:5px;" class="to-date-control-container"></div>
                </div>
                <div class="span2" style="margin-right:-30px;" data-bind="classes: { hide: shiftNavigation , }">
                    <div style="margin-top:5px;" class="input-group bootstrap-timepicker timepicker">
                        <label class="input-prepend"> 
                            <span class="add-on"><i class="icon-time"></i></span>
                            <input id="toTimePicker" type="text" style="width:65px;" class="form-control input-small" data-bind="value: toTime">
                        </label>                        
                    </div>
                </div>
                <div class="span1">
                    <button id="refreshBtn" class="btn btn-primary btn-refresh" title="<asp:localize runat=server meta:resourcekey=refresh_btn_title />">
                        <i class="fa fa-refresh"></i>
                    </button>
                </div>
            </div>
        </div>
        <div class="span4 row-fluid">
            <div class="span6">
                <div data-bind="classes: { hide: not(isNotNull(screen_itemId)), },">
                    <button style="margin-top:0;" class="btn btn-back pull-right" type="button">
                        <asp:localize runat=server meta:resourcekey=back_btn_label />
                    </button>
                </div>
            </div>
            <div class="span6">
                <button style="margin-top:0;" class="btn btn-export-to-excel pull-right" type="button">
                    <span class="excel-export-state fa fa-file-excel-o"></span>
                    <img class="loading-state hide" style="width:20px;height:20px;" src="<%= ResolveUrl("~/assets/img/spinner20.gif") %>" />
                </button>
            </div>
        </div>
    </div>
</script>




<%--<script type="text/x-handlebars-template" id="subnavbar_controls">

    <div class="span6">
        <div>
            <div style="float:left;width:300px;top:4px;position:relative;" data-bind="classes: { hide: not(isNull(screen_itemId)), },">
                <div class="row-fluid">
                    <div class="span2">
                        <button id="shiftViewBtn" class="btn btn-primary btn-left" style="margin-bottom:5px;margin-left:5px;" data-bind="classes: { hide: shiftNavigation , }">
                            <asp:Localize runat="server" meta:resourcekey="shift_view_btn_label" />
                        </button> 
                        <button id="searchViewBtn" class="btn btn-primary btn-left" style="margin-bottom:5px;margin-left:5px;" data-bind="classes: { hide: not(shiftNavigation) , }">
                                <asp:Localize runat="server" meta:resourcekey="search_view_btn_label" />
                        </button> 
                    </div>
                    <div class="span2">
                        <div style="width:50px;float:left;text-align:right;">
                            <span style="top:5px;position:relative;">
                                <asp:Localize runat="server" meta:resourcekey="from_label" />
                            </span>
                        </div>
                    </div>
                    <div class="span6">
                        <div style="width:150px;float:left;margin-left:-10px;" class="from-date-control-container"></div>
                    </div>
                    <div class="span2">
                        <div style="float:left" class="input-group bootstrap-timepicker timepicker">
                            <label class="input-prepend"> 
                                <span class="add-on"><i class="icon-time"></i></span>
                            <input id="fromTimePicker" type="text" style="width:65px;" class="form-control input-small" data-bind="value: fromTime">
                            </label>                        
                        </div>
                    </div>
                </div>




            </div>
            <div style="float:left;width:300px;top:4px;position:relative;" data-bind="classes: { hide: not(isNull(screen_itemId)), },">
                <div class="row-fluid">
                    <div class="span2">
                        <div style="width:50px;float:left;text-align:right;">
                            <span style="top:5px;position:relative;"><asp:Localize runat="server" meta:resourcekey="to_label" /></span>
                        </div>
                    </div>
                    <div class="span6">
                        <div style="width:150px;float:left;margin-left:-10px;" class="to-date-control-container"></div>
                    </div>
                    <div class="span2">
                        <div class="span2">
                            <div style="float:left" class="input-group bootstrap-timepicker timepicker">
                                <label class="input-prepend"> 
                                    <span class="add-on"><i class="icon-time"></i></span>
                                <input id="toTimePicker" type="text" style="width:65px;" class="form-control input-small" data-bind="value: toTime">
                                </label>                        
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
    <div class="span6">
        <div class="subnavbar-right-toolbar">
            <div style="display: inline-block; height: 40px;" class="pull-right">
                <div style="float:left;position:relative;margin-left:8px;top:5px;" data-bind="classes: { hide: not(isNull(screen_itemId)), },">
                    <button style="margin-top:0;" class="btn btn-refresh" type="button">
                        <span class="fa fa-refresh"></span>
                        <asp:Localize runat="server" meta:resourcekey="refresh_label" />
                    </button>
                </div>
                <div style="float:left;position:relative;margin-left:8px;top:5px;" data-bind="classes: { hide: not(isNotNull(screen_itemId)), },">
                    <button style="margin-top:0;" class="btn btn-back" type="button">
                        <asp:localize runat=server meta:resourcekey=back_btn_label />
                    </button>
                </div>
                <div style="float:left;position:relative; top:5px;margin-left:8px;">
                    <button style="margin-top:0;" class="btn btn-export-to-excel" type="button">
                        <span class="excel-export-state fa fa-file-excel-o"></span>
                        <img class="loading-state hide" style="width:20px;height:20px;" src="<%= ResolveUrl("~/assets/img/spinner20.gif") %>" />
                    </button>
                </div>                
            </div>

        </div>
    </div>
</script>--%>
