﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>

<script runat="server">
    String version = WebAppVersion.GetWebAppVersion();

    //@Override this is suggested by Microsoft, overriding the initialize culture function (that is
    //automatically called by the aspx.
    //Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
    //(English).
    protected override void InitializeCulture()
    {
        HttpCookie lang = Request.Cookies["siteLanguage"];

        String selectedLanguage = (lang != null) ? lang.Value : "en";
        UICulture = selectedLanguage;
        Culture = selectedLanguage;

        Thread.CurrentThread.CurrentCulture = CultureInfo.CreateSpecificCulture(selectedLanguage);
        Thread.CurrentThread.CurrentUICulture = new CultureInfo(selectedLanguage);
        base.InitializeCulture();
    }
</script>

<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).

    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css")%>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/extensions/valid-limit-cell/backgrid-valid-limit-cell.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/autocomplete/backbone.autocomplete.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/app/custom-screens/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + ".css")%>" rel="stylesheet" />

<div class="row-fluid subnavbar fixed-subnavbar not-print" style="margin-bottom: 0px;">
    <div class="row-fluid form-inline">
        <div class="span12 row-fluid">
            <div class="span3">
                <button id="backNavBtn" style="margin-left:5px;margin-right:-5px;" class="btn btn-primary ">
                    <asp:Localize runat="server" meta:resourcekey="back_item_btn_label" />
                </button> 
                <label style="margin-left:5px;margin-bottom:0 !important; ">
                    <asp:Localize runat="server" meta:resourcekey="tank_label" /> 
                        <select data-bind=" value: tankCode, options: tanks, optionsDefault: { label: '<asp:localize runat=server meta:resourcekey=furnaces_combo_all_opt />', value: '-'}" style="width:75px;margin-top:0px;">
                        </select>
                </label>
                <label style="margin-bottom:0 !important; ">
                    <asp:Localize runat="server" meta:resourcekey="heat_name_label" /> 
                    <input type="text" id="search" style="width:100px; text-align:center" data-bind="value: heatName," />
                </label>
                <button id="forwardNavBtn" class="btn btn-primary">
                            <asp:Localize runat="server" meta:resourcekey="forward_item_btn_label" />
                </button>
            </div>
           <div class="span7">
                <div class="navigation-buttons"  data-bind="classes: { hide: any(not(hasData), isLoading), }" style="margin-left:-30px;"></div>
            </div>
           
            <div class="span2">
                <button id="refreshBtn" class="btn btn-primary pull-right" style="margin-right:10px;" title="<asp:localize runat=server meta:resourcekey=refresh_btn_title />">
                    <i class="fa fa-refresh"></i>
                </button>
                <button id="printBtn" class="btn btn-primary"  style="margin-bottom:5px;margin-left:100px;" title="<asp:localize runat=server meta:resourcekey=print_btn_title />"  data-bind="disabled:  any(not(hasData), isLoading)" >
                    <i class="fa fa-print"></i>
                </button>

            </div>
       </div>
    </div>
</div>

<div class="row-fluid screen-content">
    <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: any(hasData, isLoading), }" style="height:500px;">
        <div class="row-fluid" style="position:relative;top:100px;">
            <i class="fw-icon-circle-blank fw-icon-4x" style="font-size:115px;"></i>
        </div>
        <div class="row-fluid" style="position:relative;top:115px;">
            <h3 style="font-size:50px;">
                <asp:localize runat="server" meta:resourcekey="no_data_available" />
            </h3>
        </div>
    </div>
    <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: not(isLoading), }" style="height:500px;">
        <div class="row-fluid" style="position:relative;top:100px;">
            <i class="fa fa-cog fw-icon-4x fa-spin" style="font-size:115px;"></i>
        </div>
        <div class="row-fluid" style="position:relative;top:115px;">
            <h3 style="font-size:50px;">
                <asp:localize runat="server" meta:resourcekey="loading_data" />
            </h3>
        </div>
    </div>


    <!---Header--->
    <div class="row-fluid not-print" data-bind="classes: { hide: any(not(hasData), isLoading), }">
        <div class="span3">
            <div class="row-fluid">
                <div class="span1">
                    <h4><asp:Localize runat=server meta:resourcekey=process_heat_label /></h4>
                </div>
                <div class="span2">
                    <h4 data-bind="text:  coalesce(process_heatName, '-'),"></h4>
                </div>
                <div class="span3">
                    <h4><asp:Localize runat=server meta:resourcekey=process_treatment_label /></h4>
                </div>
                <div class="span1">
                    <h4 data-bind="text:  coalesce(process_treatment, '-'),"></h4>
                </div>
                <div class="span3">
                    <h4><asp:Localize runat=server meta:resourcekey=process_melt_order_label /></h4>
                </div>
                <div class="span2">
                    <h4 data-bind="text:  coalesce(process_meltOrder, '-'),"></h4>
                </div>
            </div>
        </div>
        <div class="span3">
            <div class="row-fluid">
                <div class="span2">
                    <h4><asp:Localize runat=server meta:resourcekey=process_vtd_tank_label /></h4>
                </div>
                <div class="span3">
                    <h4 data-bind="text:  coalesce(process_tankLabel, '-'),"></h4>
                </div>
                <div class="span2">
                    <h4><asp:Localize runat=server meta:resourcekey=process_date_label /></h4>
                </div>
                <div class="span2">
                    <h4 data-bind="text:  coalesce(process_productionDate, '-'),"></h4>
                </div>
            </div>
        </div>
        <div class="span3">
            <div class="row-fluid">
                 <div class="span2">
                    <h4><asp:Localize runat=server meta:resourcekey=process_shift_label /></h4>
                </div>
                <div class="span3">
                    <h4 data-bind="text:  coalesce(process_shiftName, '-'),"></h4>
                </div>
                <div class="span3">
                    <h4><asp:Localize runat=server meta:resourcekey=process_crew_label /></h4>
                </div>
                <div class="span1">
                    <h4 data-bind="text:  coalesce(process_crewId, '-'),"></h4>
                </div>
            </div>
        </div>
        <div class="span2">
            <div class="span4">
                <h4><asp:Localize runat=server meta:resourcekey=process_start_label /></h4>
            </div>
            <div class="span3">
                 <h4 data-bind="text:  coalesce(process_start, '-'),"></h4>
            </div>
            <div class="span3">
                <h6 class="info-unit-label"><asp:Localize runat=server meta:resourcekey=process_info_hh_mm_unit_legend /></h6>
            </div>
        </div>
    </div>

      <div style="margin-top:-100px; text-align:center" class="print" data-bind="classes: { hide: any(not(hasData), isLoading), }">
        <h2>
            <asp:localize runat="server" meta:resourcekey="title_tbx_label" />
        </h2>
    </div>

    <table class="print" style="width:100%" data-bind="classes: { hide: any(not(hasData), isLoading), }">
        <tr>
            <td><h3><asp:Localize runat=server meta:resourcekey=process_heat_label /></h3></td>   
            <td><h3 data-bind="text:  coalesce(process_heatName, '-'),"></h3></td>
            
            <td class="header-col-space"></td>
            <td class="header-col-space"></td>
            <td class="header-col-space"></td> 
            <td class="header-col-space"></td>
            <td class="header-col-space"></td> 
            <td class="header-col-space"></td>

            <td><h3><asp:Localize runat=server meta:resourcekey=process_treatment_label /></h3></td>
            <td><h3 class="header-text" data-bind="text:  coalesce(process_treatment, '-'),"></h3></td>

            <td class="header-col-space"></td>
            <td class="header-col-space"></td>
            <td class="header-col-space"></td> 
            <td class="header-col-space"></td>
            <td class="header-col-space"></td> 
            <td class="header-col-space"></td>

            <td><h3><asp:Localize runat=server meta:resourcekey=process_production_date_label /></h3></td>
            <td><h3 class="header-text" data-bind="text:  coalesce(process_productionDateAndShift, '-'),"></h3></td>

            <td class="header-col-space"></td>
            <td class="header-col-space"></td>
            <td class="header-col-space"></td> 
            <td class="header-col-space"></td>
            <td class="header-col-space"></td> 
            <td class="header-col-space"></td>

            <td><h3><asp:Localize runat=server meta:resourcekey=process_crew_label /></h3></td>     
            <td><h3 data-bind="text:  coalesce(process_crewId, '-'),"></h3></td>  

            
            <td class="header-col-space"></td>
            <td class="header-col-space"></td>
            <td class="header-col-space"></td> 
            <td class="header-col-space"></td>
            <td class="header-col-space"></td> 
            <td class="header-col-space"></td>

            <td><h3><asp:Localize runat=server meta:resourcekey=process_start_label /></h3></td>
            <td><h3 data-bind="text:  coalesce(process_start, '-'),"></h3></td>
            <td><h6 class="info-unit-label"><asp:Localize runat=server meta:resourcekey=process_info_hh_mm_unit_legend /></h6></td>

        </tr>
    </table>

      <table class="print main-table" style="width:110%;" data-bind="classes: { hide: any(not(hasData), isLoading), }">
        <tr>
            <td><span class="info-field-label"><asp:Localize runat=server meta:resourcekey=process_info_init_grade_label /></span></td>
            <td><span class="info-field-value" data-bind="text:  coalesce(process_initGradeName, '-'),"></span></td>

            <td><span class="info-field-label"><asp:Localize runat=server meta:resourcekey=process_info_argon_bypass_time1_label /></span></td>
            <td><span class="info-field-value" data-bind="text:   coalesce(duration(process_argonBypassTime1, 's', 'm:s'), '-'),"></span></td>
            <td><span class="info-unit-label"><asp:Localize runat=server meta:resourcekey=process_info_mm_ss_unit_legend /></span></td>

               

            <td><span class="info-field-label"><asp:Localize runat=server meta:resourcekey=process_info_min_torr_label /></span></td>
            <td><span class="info-field-value" data-bind="text:  coalesce(process_minimumTorr, '-'),"></span></td>
            <td><span class="info-unit-label"><asp:Localize runat=server meta:resourcekey=process_info_torr_unit_legend /></span></td>


            

            <td><span class="info-field-label"><asp:Localize runat=server meta:resourcekey=process_info_end_label /></span></td>
            <td><span class="info-field-value" data-bind="text:  coalesce(process_end, '-'),"></span></td>
            <td><span class="info-unit-label"><asp:Localize runat=server meta:resourcekey=process_info_hh_mm_unit_legend /></span></td>


        </tr>
        <tr>
            <td><span class="info-field-label"><asp:Localize runat=server meta:resourcekey=process_info_current_grade_label /></span></td>
            <td><span class="info-field-value" data-bind="text: coalesce(process_gradeName, '-'),"></span></td>

            <td><span class="info-field-label"><asp:Localize runat=server meta:resourcekey=process_info_argon_bypass_time2_label /></span></td>
            <td><span class="info-field-value" data-bind="text:  coalesce(duration(process_argonBypassTime2, 's', 'm:s'), '-'),"></span> </td>
            <td><span class="info-unit-label"><asp:Localize runat=server meta:resourcekey=process_info_mm_ss_unit_legend /></span></td>

               

            <td><span class="info-field-label"><asp:Localize runat=server meta:resourcekey=process_info_argon_volume_1_label /></span></td>
            <td><span class="info-field-value" data-bind="text:  coalesce(process_argonVolume1, '-'),"></span></td>
            <td><span class="info-unit-label"><asp:Localize runat=server meta:resourcekey=process_info_scf_unit_legend /></span></td>


            

            <td><span class="info-field-label"><asp:Localize runat=server meta:resourcekey=process_info_arrive_time_label /></span></td>
            <td><span class="info-field-value" data-bind="text:  coalesce(process_arriveDatetime, '-'),"></span></td>
            <td><span class="info-unit-label"><asp:Localize runat=server meta:resourcekey=process_info_hh_mm_unit_legend /></span></td>
          </tr>
        <tr>
            <td><span class="info-field-label"><asp:Localize runat=server meta:resourcekey=process_info_ladle_label /></span></td>
            <td><span class="info-field-value" data-bind="text: coalesce(process_ladleName, '-'),"></span></td>

            <td><span class="info-field-label"><asp:Localize runat=server meta:resourcekey=process_info_vacuum_time_label /></span></td>
            <td><span class="info-field-value" data-bind="text: coalesce(duration(process_vacuumTime, 's', 'm:s'), '-'),"></span></td>
            <td><span class="info-unit-label"><asp:Localize runat=server meta:resourcekey=process_info_mm_ss_unit_legend /></span></td>

               
            <td><span class="info-field-label"><asp:Localize runat=server meta:resourcekey=process_info_argon_volume_2_label /></span></td>
            <td><span class="info-field-value" data-bind="text:  coalesce(process_argonVolume2, '-'),"></span></td>
            <td><span class="info-unit-label"><asp:Localize runat=server meta:resourcekey=process_info_scf_unit_legend /></span></td>

                        

            <td><span class="info-field-label"><asp:Localize runat=server meta:resourcekey=process_info_ship_time_label /></span></td>
            <td><span class="info-field-value" data-bind="text:  coalesce(process_end, '-'),"></span></td>
            <td><span class="info-unit-label"><asp:Localize runat=server meta:resourcekey=process_info_hh_mm_unit_legend /></span></td>

        </tr>
        <tr>
            <td><span class="info-field-label"><asp:Localize runat=server meta:resourcekey=process_info_operator_label /></span></td>
            <td><span class="info-field-value" data-bind="text: coalesce(process_operatorName, '-'),"></span></td>

            <td><span class="info-field-label"><asp:Localize runat=server meta:resourcekey=process_info_argon_time_1_label /></span></td>
            <td><span class="info-field-value" data-bind="text:  coalesce(duration(process_argonTime1, 's', 'm:s'), '-'),"></span></td>
            <td><span class="info-unit-label"><asp:Localize runat=server meta:resourcekey=process_info_mm_ss_unit_legend /></span></td>

            
            <td class="info-field-label"></td>
            <td class="info-field-value"></td>
            <td class="info-unit-label"> </td>

            <td><span class="info-field-label"><asp:Localize runat=server meta:resourcekey=process_info_total_treatment_time_label /></span></td>
            <td><span class="info-field-value" data-bind="text:  coalesce(process_argonVolume1, '-'),"></span></td>
            <td><span class="info-unit-label"><asp:Localize runat=server meta:resourcekey=process_info_scf_unit_legend /></span></td>

        </tr>
        <tr>
            <td class="info-field-label"></td>
            <td class="info-field-value"></td>

            <td><span class="info-field-label"><asp:Localize runat=server meta:resourcekey=process_info_argon_time_2_label /></span></td>
            <td><span class="info-field-value" data-bind="text:  coalesce(duration(process_argonTime2, 's', 'm:s'), '-'),"></span></td>
            <td><span class="info-unit-label"><asp:Localize runat=server meta:resourcekey=process_info_mm_ss_unit_legend /></span></td>

            <td class="info-field-label"></td>
            <td class="info-field-value"></td>
            <td class="info-unit-label"> </td>

            <td><span class="info-field-label"><asp:Localize runat=server meta:resourcekey=process_info_sequence_time_label /></span></td>
            <td><span class="info-field-value" data-bind="text: coalesce(duration(process_totalSequenceTime, 's', 'm:s'), '-'),"></span></td>
            <td><span class="info-unit-label"><asp:Localize runat=server meta:resourcekey=process_info_mm_ss_unit_legend /></span></td>



        </tr>
    </table>


    <!---Main Process Info--->
    <div class="process-container not-print" data-bind="classes: { hide: any(not(hasData), isLoading), }">
        <div class="process-row-1 row-fluid line-height">
            <div class="process-col-1 span3">
                <div class="span4">
                        <span class="info-field-label"><asp:Localize runat=server meta:resourcekey=process_info_init_grade_label /></span>
                </div>
                <div class="span4">
                    <span class="info-field-value" data-bind="text:  coalesce(process_initGradeName, '-'),"></span>
                </div>
            </div>

                 <div class="process-col-2 span3">
                    <div class="row-fluid">
                        <div class="span6">
                            <span class="info-field-label"><asp:Localize runat=server meta:resourcekey=process_info_argon_bypass_time1_label /></span>
                        </div>
                        <div class="span2">
                            <span class="info-field-value" data-bind="text:   coalesce(duration(process_argonBypassTime1, 's', 'm:s'), '-'),"></span> 
                        </div>
                        <div class="span1">
                            <span class="info-unit-label"><asp:Localize runat=server meta:resourcekey=process_info_mm_ss_unit_legend /></span>
                        </div>
                    </div>
                </div>
            <div class="process-col-3 span3">
                <div class="row-fluid">
                    <div class="span6">
                        <span class="info-field-label"><asp:Localize runat=server meta:resourcekey=process_info_min_torr_label /></span>
                    </div>
                    <div class="span2">
                        <span class="info-field-value" data-bind="text:  coalesce(process_minimumTorr, '-'),"></span>
                    </div>
                    <div class="span1">
                        <span class="info-unit-label"><asp:Localize runat=server meta:resourcekey=process_info_torr_unit_legend /></span>
                    </div>
                </div>
            </div>
            <div class="process-col-4 span3">
                <div class="row-fluid" >
                    <div class="span4">
                        <span class="info-field-label"><asp:Localize runat=server meta:resourcekey=process_info_end_label /></span>
                    </div>
                    <div class="span2">
                        <span class="info-field-value" data-bind="text:  coalesce(process_end, '-'),"></span>
                    </div>
                    <div class="span1">
                        <span class="info-unit-label"><asp:Localize runat=server meta:resourcekey=process_info_hh_mm_unit_legend /></span>
                    </div>
                </div>
            </div>


        </div>
        <div class="process-row-2 row-fluid line-height">
            <div class="process-container row-fluid" data-bind="classes: { hide: any(not(hasData), isLoading), }">
                <div class="process-col-1 span3">
                    <div class="span4">
                         <span class="info-field-label"><asp:Localize runat=server meta:resourcekey=process_info_current_grade_label /></span>
                    </div>
                    <div class="span4">
                        <span class="info-field-value" data-bind="text: coalesce(process_gradeName, '-'),"></span>
                    </div>
                </div>
                <div class="process-col-2 span3">
                    <div class="row-fluid">
                        <div class="span6">
                            <span class="info-field-label"><asp:Localize runat=server meta:resourcekey=process_info_argon_bypass_time2_label /></span>
                        </div>
                        <div class="span2">
                            <span class="info-field-value" data-bind="text:  coalesce(duration(process_argonBypassTime2, 's', 'm:s'), '-'),"></span>  
                        </div>
                        <div class="span1">
                            <span class="info-unit-label"><asp:Localize runat=server meta:resourcekey=process_info_mm_ss_unit_legend /></span>
                        </div>
                    </div>
                </div>
                <div class="process-col-3 span3">
                    <div class="row-fluid">
                        <div class="span6">
                            <span class="info-field-label"><asp:Localize runat=server meta:resourcekey=process_info_argon_volume_1_label /></span>
                        </div>
                        <div class="span2">
                           <span class="info-field-value" data-bind="text:  coalesce(process_argonVolume1, '-'),"></span>
                        </div>
                        <div class="span1">
                            <span class="info-unit-label"><asp:Localize runat=server meta:resourcekey=process_info_scf_unit_legend /></span>
                        </div>
                    </div>
                </div>
                <div class="process-col-4 span3">
                    <div class="row-fluid" >
                        <div class="span4">
                            <span class="info-field-label"><asp:Localize runat=server meta:resourcekey=process_info_arrive_time_label /></span>
                        </div>
                        <div class="span2">
                           <span class="info-field-value" data-bind="text:  coalesce(process_arriveDatetime, '-'),"></span>
                        </div>
                        <div class="span1">
                            <span class="info-unit-label"><asp:Localize runat=server meta:resourcekey=process_info_hh_mm_unit_legend /></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="process-row-3 row-fluid line-height">
            <div class="process-container row-fluid" data-bind="classes: { hide: any(not(hasData), isLoading), }">
                <div class="process-col-1 span3">
                    <div class="span4">
                            <span class="info-field-label"><asp:Localize runat=server meta:resourcekey=process_info_ladle_label /></span>
                    </div>
                    <div class="span4">
                        <span class="info-field-value" data-bind="text: coalesce(process_ladleName, '-'),"></span>
                    </div>
                </div>
                <div class="process-col-2 span3">
                    <div class="row-fluid">
                        <div class="span6">
                            <span class="info-field-label"><asp:Localize runat=server meta:resourcekey=process_info_vacuum_time_label /></span>
                        </div>
                        <div class="span2">
                            <span class="info-field-value" data-bind="text: coalesce(duration(process_vacuumTime, 's', 'm:s'), '-'),"></span> 
                        </div>
                        <div class="span1">
                            <span class="info-unit-label"><asp:Localize runat=server meta:resourcekey=process_info_mm_ss_unit_legend /></span>
                        </div>
                    </div>
                </div>
                 <div class="process-col-3 span3">
                    <div class="row-fluid" >
                        <div class="span6">
                            <span class="info-field-label"><asp:Localize runat=server meta:resourcekey=process_info_argon_volume_2_label /></span>
                        </div>
                        <div class="span2">
                           <span class="info-field-value" data-bind="text:  coalesce(process_argonVolume2, '-'),"></span>
                        </div>
                        <div class="span1">
                            <span class="info-unit-label"><asp:Localize runat=server meta:resourcekey=process_info_scf_unit_legend /></span>
                        </div>
                    </div>
                </div>
                 <div class="process-col-4 span3">
                    <div class="row-fluid" >
                        <div class="span4">
                            <span class="info-field-label"><asp:Localize runat=server meta:resourcekey=process_info_ship_time_label /></span>
                        </div>
                        <div class="span2">
                           <span class="info-field-value" data-bind="text:  coalesce(process_end, '-'),"></span>
                        </div>
                        <div class="span1">
                            <span class="info-unit-label"><asp:Localize runat=server meta:resourcekey=process_info_hh_mm_unit_legend /></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="process-row-4 row-fluid line-height">
            <div class="process-container row-fluid" data-bind="classes: { hide: any(not(hasData), isLoading), }">
               <div class="process-col-1 span3">
                    <div class="span4">
                         <span class="info-field-label"><asp:Localize runat=server meta:resourcekey=process_info_operator_label /></span>
                    </div>
                    <div class="span4">
                        <span class="info-field-value" data-bind="text: coalesce(process_operatorName, '-'),"></span>
                    </div>
                </div>
             <div class="process-col-2 span3">
                    <div class="row-fluid">
                        <div class="span6">
                            <span class="info-field-label"><asp:Localize runat=server meta:resourcekey=process_info_argon_time_1_label /></span>
                        </div>
                        <div class="span2">
                            <span class="info-field-value" data-bind="text:  coalesce(duration(process_argonTime1, 's', 'm:s'), '-'),"></span> 
                        </div>
                        <div class="span1">
                            <span class="info-unit-label"><asp:Localize runat=server meta:resourcekey=process_info_mm_ss_unit_legend /></span>
                        </div>
                    </div>
                </div>

                 <div class="process-col-3 span3">
                </div>
                <div class="process-col-4 span3">
                    <div class="row-fluid">
                        <div class="span4">
                            <span class="info-field-label"><asp:Localize runat=server meta:resourcekey=process_info_total_treatment_time_label /></span>
                        </div>
                        <div class="span2">
                            <span class="info-field-value" data-bind="text:  coalesce(duration(process_totalTreatmentTime, 's', 'm:s'), '-'),"></span>  
                        </div>
                        <div class="span1">
                            <span class="info-unit-label"><asp:Localize runat=server meta:resourcekey=process_info_mm_ss_unit_legend /></span>
                        </div>  
                    </div>
                </div>

            </div>
        </div>
        <div class="process-row-5 row-fluid line-height">
            <div class="process-container row-fluid" data-bind="classes: { hide: any(not(hasData), isLoading), }">
                <div class="process-col-1 span3">
                </div>
                 <div class="process-col-2 span3">
                    <div class="row-fluid">
                        <div class="span6">
                            <span class="info-field-label"><asp:Localize runat=server meta:resourcekey=process_info_argon_time_2_label /></span>
                        </div>
                        <div class="span2">
                            <span class="info-field-value" data-bind="text:  coalesce(duration(process_argonTime2, 's', 'm:s'), '-'),"></span> 
                        </div>
                        <div class="span1">
                            <span class="info-unit-label"><asp:Localize runat=server meta:resourcekey=process_info_mm_ss_unit_legend /></span>
                        </div>
                    </div>
                </div>
                
                 <div class="process-col-3 span3">
                </div>
                
                
                 <div class="process-col-4 span3">
                    <div class="row-fluid" >
                        <div class="span4">
                            <span class="info-field-label"><asp:Localize runat=server meta:resourcekey=process_info_sequence_time_label /></span>
                        </div>
                        <div class="span2">
                           <span class="info-field-value" data-bind="text: coalesce(duration(process_totalSequenceTime, 's', 'm:s'), '-'),"></span>
                        </div>
                        <div class="span1">
                            <span class="info-unit-label"><asp:Localize runat=server meta:resourcekey=process_info_mm_ss_unit_legend /></span>
                        </div>
                    </div>
                </div>


            </div>
        </div>
    </div>

    <div class="row-fluid" data-bind="classes: { hide: any(not(hasData), isLoading), }">
        <div class="span4">
            <h4><asp:Localize runat=server meta:resourcekey=title_probes_label /></h4>
            <div class="probes-items-grid-container items-grid-container row-fluid infinite-container" ></div>
        </div>        
        <div class="span6">
            <h4><asp:Localize runat=server meta:resourcekey=title_alloys_label /></h4>
            <table class="grid-styles table">
                <thead>
                    <tr>
                        <th class="sortable renderable">
                            <a>Batch Start</a>
                            <b class="sort-caret"></b>
                            
                        </th>
                        <th class="sortable renderable">
                            <a>Batch End</a>
                            <b class="sort-caret"></b>
                        </th>
                        <th class="sortable renderable">
                            <a>Dump Start</a>
                            <b class="sort-caret"></b>
                        </th>
                        <th class="sortable renderable">
                            <a>Dump End</a>
                            <b class="sort-caret"></b>
                        </th>
                        <th class="sortable renderable">
                            <a>Material</a>
                            <b class="sort-caret"></b>
                        </th>
                        <th class="sortable renderable">
                            <a>Weight SP</a>
                            <b class="sort-caret"></b>
                        </th>
                        <th class="sortable renderable">
                            <a>Weight PV</a>
                            <b class="sort-caret"></b>
                        </th>
                         <th class="sortable renderable">
                            <a>Param 1</a>
                            <b class="sort-caret"></b>
                        </th>
                    </tr>
                </thead>
                <tbody data-bind="collection: $alloysTableColl, itemView: 'alloysTableView'">
                
                </tbody>
            </table>
         </div>
    </div>
   
    
    <div class="pagebreak"> </div>
    
    <div id="vtdChartContainerPrint" class="id-chart-container print-trending print" data-bind="classes: { hide: any(not(hasData), isLoading), }" style="margin-left:1%;margin-top:15px;height:400px;width:98%;"></div>
  
    <div id="vtdChartContainer" class="id-chart-container trending not-print" data-bind="classes: { hide: any(not(hasData), isLoading), }" style="margin-left:1%;margin-top:15px;height:400px;width:98%;"></div>
  
    
    
</div>

    
<script id="alloysTableViewTemplate" type="text/x-handlebars-template">
    <td class="spanrow1" data-bind="text:batchStart"></td>
    <td class="spanrow2" data-bind="text:batchEnd"></td>
    <td class="spanrow3" data-bind="text:dumpStart"></td>
    <td class="spanrow4" data-bind="text:dumpEnd"></td>
    <td data-bind="text:materialName"></td>
    <td data-bind="text:weightSP"></td>
    <td data-bind="text:weightPV"></td>
    <td data-bind="text:parameter1"></td>
</script>
    