﻿define([
  'app',
  'modules/catalog-code/catalog-code',
],
function (app, CatalogCode) {

    var Main = {
        Models: {},
        Collections: {},
    };

    (function () {
        var superRef, superProto, classRef;

        superRef = CatalogCode.Models.CatalogCode;
        superProto = superRef.prototype;

        Main.Models.ChemistrySampleType = classRef = superRef.extend({
            defaults: _.extend(
                {},
                superProto.defaults,
                {
                    areaCode: null,
                }
            ),
            procedures: {
                get: app.DatabaseNames.MES + '.CAT.GetChemistrySampleTypes',
            },

            parse: function (obj) {
                return _.extend(superProto.parse.apply(this, arguments), {
                    areaCode: obj.AreaCode,
                });
            },
        });
    })();

    (function () {
        var superRef, superProto, classRef;

        superRef = CatalogCode.Collections.CatalogCodes;
        superProto = superRef.prototype;

        Main.Collections.ChemistrySampleTypes = classRef = superRef.extend({
            model: Main.Models.ChemistrySampleType,
        });
        _.extend(classRef, {
            fetch: function (options) {
                var opt = _.extend(
                        { error: function () { }, success: function () { }, },
                        options
                    );

                classRef.prototype.getData.apply(classRef.prototype, [_.extend(
                    {},
                    opt,
                    {
                        success: function (resp) {
                            if (resp.Table) {
                                opt.success(_.map(resp.Table, classRef.prototype.model.prototype.parse));
                            }
                            else {
                                var msg = (resp.Message) ? resp.Message : 'Can not fetch chemistry sample type.';

                                console.error(new Error(msg).stack);
                                opt.error(msg);
                            }
                        },
                    }
                )]);
            },
        });
    })();

    // Required, return the module for AMD compliance.
    return Main;

});