﻿define([
  'app',
  'modules/base/base',
],
function (app, Base) {

    var Main = {
        Models: {},
        Collections: {},
    };

    (function () {
        var superRef, superProto, classRef;

        superRef = Base.Models.Base;
        superProto = superRef.prototype;

        Main.Models.EafProcessBucket = classRef = superRef.extend({
            defaults: _.extend(
                {},
                superProto.defaults,
                {
                    id: null,

                    processId: null,

                    bucketId: null,
                    bucketName: null,
                    othersWeight: null,
                    scrapWeight: null,
                    timestamp: null,
                }
            ),
            procedures: {
                create: app.DatabaseNames.MES + '.EAF.CreateBucketManual',
                get: app.DatabaseNames.MES + '.EAF.GetBuckets',
                update: app.DatabaseNames.MES + '.EAF.UpdateBucket',
                remove: app.DatabaseNames.MES + '.EAF.RemoveBucket',
            },

            parse: function (obj) {
                return {
                    id: obj.Id,

                    processId: obj.ProcessId,
                    fluxWeight1: obj.FluxWeight1,
                    fluxWeight2: obj.FluxWeight2,
                    fluxWeight3: obj.FluxWeight3,
                    fluxWeight4: obj.FluxWeight4,
                    bucketId: obj.BucketId,
                    bucketName: obj.BucketName,
                    othersWeight: obj.OthersWeight,
                    scrapWeight: obj.ScrapWeight,
                    timestamp: obj.TimestampString,
                };
            },
        });
    })();

    (function () {
        var superRef, superProto, classRef;

        superRef = Base.Collections.Base;
        superProto = superRef.prototype;

        Main.Collections.EafProcessBuckets = classRef = superRef.extend({
            model: Main.Models.EafProcessBucket,
            comparator: 'timestamp',
        });
    })();

    // Required, return the module for AMD compliance.
    return Main;

});