-------------
-- ROLES
-------------
	USE [IHBoxSystem]
	GO
	CREATE ROLE ctr_read AUTHORIZATION dbo 
	GO  

	USE [IHBoxSystem]
	GO
	EXEC sp_addrolemember 'ctr_read', 'admin'
	GO

	USE [IHBoxSystem]
	GO
	EXEC sp_addrolemember 'ctr_read', 'SDI/australtek'
	GO



-------------------
-- Menu and Route
-------------------
	declare @parent int, @result_routeId INT
	select @parent=id from [FrontEnd].[Menu] where [Name] = 'Caster' and Parent is null

	INSERT INTO [FrontEnd].[Routes]
			   ([Route]
			   ,[ModuleName]
			   ,[ModulePath]
			   ,[RequiredRole]
		   )
		 VALUES 
			   (
			   '!/caster-tag-report(/:start)(/:end)(/:printerCode)(/)'
			   , 'caster-tag-report'
			   , 'custom-screens/caster-tag-report/'
			   , 'ctr_read'           
			   )
			   SET @result_routeId = @@IDENTITY
	INSERT INTO [FrontEnd].[Menu]
			   ([Parent]
			   ,[Name]
			   ,[RouteID]
			   ,[SortOrder]
			   ,[Enabled]
			   ,[Visible]
			   ,[RequiredRole]
			   ,[Group]
			  )
		 VALUES
			   (
			   @parent
			   ,'Tag Report'
			   ,@result_routeId 
			   ,1
			   ,1
			   ,1
			   ,'ctr_read'
			   ,NULL
			 )
	GO


-------------------
-- SP Permissions
-------------------
EXECUTE sys.sp_addextendedproperty 
@level0type = N'USER' -- The object type
,@level0name = [ctr_read] -- The role
,@name = N'securedsp-CAS.GetTagReport' -- the procedure
,@value = N'' 
GO


-------------------
--	Profiles
-------------------
	USE [IHBoxSystem]
	GO

	DECLARE @ModuleId INT

	INSERT INTO [SECURITY].[Modules]([Code],[Name])
	VALUES('ctr_read','Caster Tag Report')

	SET @ModuleId = @@IDENTITY


	INSERT INTO [SECURITY].ModuleActions(ModuleId,Code,[Name],[Role])
	VALUES (@ModuleId,'read','Read','ctr_read')




---- Change route:
update top(1) FrontEnd.Routes
	set ModulePath = 'pages/caster/caster-tag-report/'
	where ModulePath = 'custom-screens/caster-tag-report/'