// Set the require.js configuration for your application.
require.config({

    // Initialize the application with the main application file
    deps: ["../assets/libs/jam/require.config", "main"],

    paths: {

        // Defining route for the external libraries.
        "js": "../assets/libs/js",
        "custom-modules": "custom-modules",
        "assets": "../assets/",
        "custom-assets": "../custom-assets",
        "backgrid": "../assets/libs/js/backgrid-0.3.5/lib/backgrid", //add .min at the end to get minified version
        "backgrid/calendar-cell": "../assets/libs/js/backgrid-0.3.5/extensions/calendar-cell/backgrid-calendar-cell", //add .min at the end to get minified version
        "backgrid/computed-cell": "../assets/libs/js/backgrid-0.3.5/extensions/computed-cell/backgrid-computed-cell", //add .min at the end to get minified version
        "backgrid/duration-cell": "../assets/libs/js/backgrid-0.3.5/extensions/duration-cell/backgrid-duration-cell", //add .min at the end to get minified version
        "backgrid/moment-cell": "../assets/libs/js/backgrid-0.3.5/extensions/moment-cell/backgrid-moment-cell", //add .min at the end to get minified version
        "backgrid/select-all": "../assets/libs/js/backgrid-0.3.5/extensions/select-all/backgrid-select-all", //add .min at the end to get minified version
        "backgrid/select-integer-cell": "../assets/libs/js/backgrid-0.3.5/extensions/select-integer-cell/backgrid-select-integer-cell", //add .min at the end to get minified version
        "backgrid/time-cell": "../assets/libs/js/backgrid-0.3.5/extensions/time-cell/backgrid-time-cell", //add .min at the end to get minified version
        "backgrid/grouped-columns": "../assets/libs/js/backgrid-0.3.5/extensions/grouped-columns/backgrid-grouped-columns", //add .min at the end to get minified version
        "backgrid/infinator": "../assets/libs/js/backgrid-0.3.5/extensions/infinator/backgrid-infinator", 
        "backbone.paginator": "../assets/libs/js/backbone-paginator/backbone.paginator", //add .min at the end to get minified version
        "bootstrap/colorpicker": "../assets/libs/js/bootstrap-colorpicker/js/bootstrap-colorpicker", //add .min at the end to get minified version
        "moment": "../assets/libs/js/moment/moment", //add .min at the end to get minified version
        "highcharts": "../assets/libs/js/dashboard-assets/highcharts/highcharts",
        "highstock": "../assets/libs/js/dashboard-assets/highstock/highstock.src", 
        "chartjs-moment-adapter":'../assets/libs/js/chartjs/chartjs-adapter-moment',
        "chart": "../assets/libs/js/chartjs/chart",
        //"chart/helpers": "../assets/libs/js/chartjs/chart",
        "chartjs-date-fns-adapter": "../assets/libs/js/chartjs/chartjs-adapter-date-fns.bundle.min",
        "chartjs-plugin-annotation": "../assets/libs/js/chartjs/chartjs-plugin-annotation",
        "date-fns": "../assets/libs/js/chartjs/date-fns.2.29.min",
        // Put additional paths here.
        "xlsx": "../assets/libs/js/xlsx/xlsx.full.min",
        "select2": "../assets/libs/js/select2/select2.min",
        "select2totree": "../assets/libs/js/select2/select2totree",
        "agGrid": "../assets/ag-grid/ag-grid-enterprise.min.noStyles"

    },

    waitSeconds: 30, //timeout for loading scripts, using 30 seconds for slow networks.

    packages: [
        {
            "name": "d3",
            "location": "../assets/libs/js/d3js",
            "main": "d3.js"
        },
        {
            "name": "dc",
            "location": "../assets/libs/js/dcjs",
            "main": "dc.js"
        },
        {
            "name": "crossfilter",
            "location": "../assets/libs/js/crossfilter",
            "main": "crossfilter.js"
        },
        {
            "name": "Chart",
            "location": "../assets/libs/js/dashboard-assets/chartjs",
            "main": "Chart.Core.js"
        },
        {
            "name": "chart.js",
            "location": "../assets/libs/js/dashboard-assets/chartjs",
            "main": "Chart.Core.js"
        },
        {
            "name": "Chart2",
            "location": "../assets/libs/js/dashboard-assets/chartjs2",
            "main": "Chart.js"
        },
        {
            "name": "Chart3",
            "location": "../assets/libs/js/chartjs",
            "main": "Chart.js"
        },
    ], 

    map: {
        // Put additional maps here.
    },

    shim: {
        // Put shims here.
        "js/backbone.routefilter": ["backbone", "underscore"]
        , "js/backbone.epoxy": ["backbone", "underscore"]
        , "js/jquery-ui-1.10.3": ["jquery"]
        , "js/jquery.vticker": ["jquery"]
        , "js/jquery.mask": ["jquery"]
        , "js/bootstrap-timepicker/js/bootstrap-timepicker": ["jquery"]
        , "js/bootstrap-select/bootstrap-select": ["jquery"]
        , "backgrid": {
            "deps": ["jquery", "underscore", "backbone"],
            "exports": "Backgrid", 
        }
        , "backgrid/infinator": ["jquery", "underscore", "backbone", "backgrid"]
        , "backgrid/grouped-columns": ["jquery", "underscore", "backbone", "backgrid"]
        , "bootstrap/colorpicker": ["jquery"]
        //, "backgrid/select-all": ["jquery", "underscore", "backbone", "backgrid"]
        , "dc": {
            "deps": [
                "crossfilter",
                "d3"
            ],
            "exports": "dc"
        }
        , "app-config": ["underscore"]
        , "Chart2": ["../assets/libs/js/dashboard-assets/chartjs2/moment-fix"]
        , "highcharts": {
            exports: "Highcharts",
            deps: ["jquery"]
        }
        , "highstock": {
            exports: "Highstock",
            deps: ["jquery"]
        }
        , "js/dashboard-assets/highstock/highcharts-more": ["highstock"]
        , "js/dashboard-assets/highcharts/highcharts-more": ["highcharts"]
   
        // Twitter Bootstrap depends on jQuery.
        //"assets/bootstrap/js/bootstrap": ["jquery"]
    }

});