﻿define([
  // Application.
  "app",

  //templates-loader
  "js/templates-loader"

],

function (app, T) {

    var Multilingual_Stress_Test_2 = { Model: {}, Views: {} }

    Multilingual_Stress_Test_2.Model = Backbone.Model.extend({
        defaults: {}
    });

    Multilingual_Stress_Test_2.Views.Main = Backbone.View.extend({
        template: "multilingual_stress_test2"
        , id: "multilingual-stress-test-2"
        , title: ""
        //default not cacheable, change this if you want the view to be cacheable
        // if the view is set as cacheable should also have a refresh method to reset the view without erasing the DOM.
        //refreshing only the data, maybe?
        , isCacheable: true
        , initialize: function () {
        }

        ,events: {
            "click #button1": "buttonClick"
            , "click #button2": "buttonClick"
            , "click #button3": "buttonClick"
            , "click #button4": "buttonClick"
            , "click #button5": "buttonClick"
            , "click #button6": "buttonClick"
            , "click #button7": "buttonClick"
            , "click #button8": "buttonClick"
        }, 
        // global view variable (seen in this scope, public to the view, and SHARED BETWEEN OTHER INSTANCES OF THE SAME VIEW)
        // containing all the variables for this view

        //properties that you wanna scope as private variables for each instance of a view should not be placed here
        //the only way i found to maintain the variables between instances of the same view, is either using models,
        // (each view will have its own model so data is not shared between them), or in case you don't want to use a model
        // you can use the Backbone.View.options object, and doing something like
        // this.options.attributes = {}
        // and storing every single variable inside attributes.

        render: function (container) {
            var that = this;
            var thatContainer = container;

            //the screens have a custompath, so it has to be specified in the customPath variable that is
            //then sent to the template loader.
            var customPath = "/app/screens/multilingual-stress-tests/";

            T.render.call(this, this.template, function (tmp) {
                //getInternationalizationData
                if (!that.options.i18n) that.options.i18n = {};
                app.getI18NJed(that, that.template, function (i18nJED) {
                    //storing internationalization data
                    that.options.i18n[that.template] = i18nJED;

                    //start: before the view is visible, but the template was already loaded (not instanced nor appended)

                    //end:

                    //loading the view and appeding it to the views's $el.
                    that.$el.html(tmp());

                    //start: the view was already loaded an is on a div element, but not appended to the main container
                    //here you can perform anything you want DOM related, by getting the dom element via that.$el.find("#id")

                    //:end

                    //appending view to the main container
                    thatContainer.append(that.$el);

                }, true, customPath);
            }, customPath);
        }

        , buttonClick: function (source) {
            alert(this.options.i18n[this.template].translate(source.currentTarget.id + "_click").fetch());
        }

        , close: function () {
            this.remove();
            this.unbind();
        }
        , show: function () {
            this.$el.show();
        }
        , hide: function () {
            this.$el.hide();
        }
    });

    // Required, return the module for AMD compliance.
    return Multilingual_Stress_Test_2;

});
