/*
  backgrid-select-integer-cell 1.0.0
*/
(function (root, factory) {

  if (typeof define === 'function' && define.amd) {
    // AMD
    define(['underscore', 'backgrid'], factory);
  } else if (typeof exports === 'object') {
    // CommonJS
    module.exports = factory(require('underscore'), require('backgrid'));
  } else {
    // Browser globals
    factory(root._, root.Backgrid);
  }

}(this, function (_, Backgrid) {

    //Fix require config issue with Underscore.
    if (!_)
        _ = this._;


    Backgrid.Extension.SelectIntegerFormatter = SelectIntegerFormatter = function (options) {};
    SelectIntegerFormatter.prototype = new Backgrid.SelectFormatter;
    _.extend(SelectIntegerFormatter.prototype, {
        toRaw: function (formattedValue, model) {
            return formattedValue != null ? parseInt(formattedValue, 10) : null;
        },
    });
    SelectIntegerFormatter.extend = Backbone.Model.extend;


    Backgrid.Extension.SelectIntegerCell = Backgrid.SelectCell.extend({
        formatter: SelectIntegerFormatter,
    });
}));
