﻿//wrapper to prettify the IndustrialDashboard DropDownSelect introduced with MES 2.0

(function () {
    try {

        function _DropDownSelectBootstrap(object, options) {
            try {

                var MYREFERENCES = {
                    wrappedObject: null
                    , object: null
                    , Events: {
                        onComplete: []
                        , onChange: []
                    }
                }

                function _Initialize(object, options) {
                    try {
                        MYREFERENCES.object = object;

                        var selectPickerOptions = {
                        };

                        if (Core.Object.Exist(options, "SelectPickerOptions")) {
                            Core.Object.Extend(options.SelectPickerOptions, selectPickerOptions); 
                        }

                        _InitializeSelectBootstrap(object, selectPickerOptions); 

                        if (Core.Object.Exist(options, "Events.onComplete")) {
                            MYREFERENCES.Events.onComplete = options.Events.onComplete; 
                        }
                        if (Core.Object.Exist(options, "Events.onChange")) {
                            MYREFERENCES.Events.onChange = options.Events.onChange; 
                        }
                        options.Events.onComplete = _onWidgetComplete; 
                        options.Events.onChange = []; 

                        MYREFERENCES.wrappedObject = new DropDownSelect(object, options); 

                    } catch (Error) { }
                }

                function _InitializeSelectBootstrap(object, spOptions) {
                    try {
                        for (w in object) {
                            var widg = object[w];
                            var widgElem = $(widg.Elem); 
                            widgElem.selectpicker(spOptions);

                            if (Core.Object.Exist(widg, "Events.onChange")) {
                                for (var ev in widg.Events.onChange) {
                                    widgElem.bind("change", ev);
                                }
                            }
                            widgElem.bind("change", { obj: widg, name: w }, _onWidgetChange);
                        }
                    } catch (Error) { }
                }

                function _onWidgetComplete(arg1, arg2, arg3, arg4) {
                    try {
                        _RefreshWidgets();
                        _FireEvents("onComplete", [arg1, arg2, arg3, arg4]);
                    } catch (Error) { }
                }

                function _onWidgetChange(ev) {
                    try {
                        var data = ev.data;
                        MYREFERENCES.wrappedObject.SetValue(data.name, $(data.obj.Elem).selectpicker("val"));
                        _RefreshWidgets();
                        _FireEvents("onChange", {}); 
                    } catch (Error) { }
                }

                function _RefreshWidgets() {
                    try {
                        for (var w in MYREFERENCES.object) {
                            var widg = $(MYREFERENCES.object[w].Elem);
                            widg.selectpicker("refresh"); 
                        }
                    } catch (Error) { }
                }

                function _FireEvents(event, args) {
                    try {
                        var events = null;
                        if (typeof event == "string" && Core.Object.Exist(MYREFERENCES, 'Events.' + event)) {
                            events = MYREFERENCES.Events[event];
                        } else if (event instanceof Function || event instanceof Array) {
                            events = event;
                        }

                        if (events) {
                            var ev, i, l, a1, a2, a3;
                            i = -1;

                            l = (events instanceof Array) ? events.length : 1;
                            if (args.length && args.length > 0) { a1 = args[0]; a2 = args[1]; a3 = args[2]; }
                            else args = [];

                            switch (args.length) {
                                case 0: while (++i < l) (ev = ((events instanceof Array) ? events[i] : events)).call(ev.ctx); return;
                                case 1: while (++i < l) (ev = ((events instanceof Array) ? events[i] : events)).call(ev.ctx, a1); return;
                                case 2: while (++i < l) (ev = ((events instanceof Array) ? events[i] : events)).call(ev.ctx, a1, a2); return;
                                case 3: while (++i < l) (ev = ((events instanceof Array) ? events[i] : events)).call(ev.ctx, a1, a2, a3); return;
                                default: while (++i < l) (ev = ((events instanceof Array) ? events[i] : events)).apply(ev.ctx, args);
                            }
                        }

                    } catch (Error) { }
                }

                _Initialize(object, options); 

                //mirroring methods
                for (var m in MYREFERENCES.wrappedObject){
                    if (typeof MYREFERENCES.wrappedObject[m] == "function" && MYREFERENCES.wrappedObject.hasOwnProperty(m)) {
                        this[m.toString()] = MYREFERENCES.wrappedObject[m]; 
                    }
                }

            } catch (Error) {
            }
        }

        window.DropDownSelectBootstrap = _DropDownSelectBootstrap; 

    } catch (Error) {
    }
})(); 