﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
protected override void InitializeCulture()
{

    HttpCookie lang = Request.Cookies["siteLanguage"]; 
    
    String selectedLanguage = (lang != null) ? lang.Value : "en";
    UICulture = selectedLanguage ;
    Culture = selectedLanguage ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(selectedLanguage);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(selectedLanguage);
    base.InitializeCulture();
}
</script>
<%  Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<div id="trending-dropdown">
    {{#if views}}
        <a class="btn dropdown-toggle" style="font-size: 18px; font-weight: normal;" data-toggle="dropdown">
            <i class="fa fa-line-chart" style="margin-right: 5px;"></i>
            <asp:Localize ID="Localize7" runat="server" meta:resourcekey="menu_item_trending" />
            <span class="caret"></span>
        </a>
        <ul style="min-width:180px;color: rgb(0, 0, 0);" class="dropdown-menu">
            {{#each most_used_views}}
                <li><a href="!/trending/custom/view={{Name}}">{{Name}}</a></li>
            {{/each}}
            {{#if dot_views}}
                <li class="dropdown-submenu">
                    <a class="stop-propag" tabindex="-1"><asp:Localize runat="server" meta:resourcekey="dot_views" /></a>
                    <ul style="max-height:300px;overflow:auto;" class="dropdown-menu">
                        {{#each dot_views}}
                            <li><a href="!/trending/custom/view={{Name}}">{{Name}}</a></li>
                        {{/each}}
                    </ul>
                </li>
            {{/if}}
            {{#if other_views}}
            <li class="text-center dropdown-submenu">
                <a class="stop-propag" tabindex="-1"><asp:Localize ID="Localize2" runat="server" meta:resourcekey="more_views" /></a>
                <ul style="max-height:300px;overflow:auto;" class="dropdown-menu">
                    {{#each other_views}}
                        <li><a href="!/trending/custom/view={{Name}}">{{Name}}</a></li>
                    {{/each}}
                </ul>
            </li>
            {{/if}}
            <li><a href="#!/trending/custom/view=NEWVIEW"><asp:Localize ID="Localize1" runat="server" meta:resourcekey="menu_item_trending_add_view" /></a></li>
        </ul>
    {{else}}
        <ul class="nav navbar-nav level0">
            <li class="current" data-id="101" data-level="1">
                <a href="!/trending" style="padding: 25px 31px;">
                    <i style="line-height:0px;" class="fa fa-line-chart"></i>
                    <asp:Localize ID="Localize3" runat="server" meta:resourcekey="menu_item_trending" />
                <b class="caret"></b></a>
            </li>
        </ul>
    {{/if}}
</div>


            

