﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
bool withModules = true; 

//@Override this is suggested by Microsoft, overriding the initialize culture function (that is
//automatically called by the aspx.
//Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
//(English).
protected override void InitializeCulture()
{
    HttpCookie lang = Request.Cookies["siteLanguage"]; 
    
    String selectedLanguage = (lang != null) ? lang.Value : "en";
    UICulture = selectedLanguage ;
    Culture = selectedLanguage ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(selectedLanguage);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(selectedLanguage);
    base.InitializeCulture();
}
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); 
%>

<% 
    if (Session["MenuData"] == null){
        Session["MenuData"] = WebApp.GetMenu(); 
    }
    WebApp.MenuData menuData = (WebApp.MenuData)Session["MenuData"]; 
%>

<style>
    .menu-error-icon {
        float: left;
        margin-left: 10px;
        margin-top: 4px;
        height: 12px;
        width: 12px;
        background-color: #FF0000;
        -moz-border-radius: 43px;
        -webkit-border-radius: 43px;
        border-radius: 43px;
        color: #FFFFFF;
        font-size: 10px;
        line-height: 12px;
        text-align: center;
        display:none;
    }    

    .configuration-sidemenu div:first-of-type  {
        margin-top:20px;
    }
</style>

<div style="margin-top:-60px;margin-left:-5px;position:fixed;z-index:1005;" class="hamburguer-menu span1 hide">
    <button class="btn btn-medium"><span class="fa fa-bars"></span></button>
</div>
<div style="margin-top:-60px;margin-left:-5px;position:fixed;z-index:1005;overflow:auto;" class="span3 configuration-sidemenu">
    <%--<button style="float:right;position:relative;" class="btn btn-link btn-hide-sidemenu"><span class="fa fa-minus"></span></button>--%>

    <% foreach (WebApp.MenuItem mi in menuData.GetGroupItems("ih_configuration")){ %>
    <div class="well sidebar-nav">
        <h4>
            <% if (mi.Properties.HasProperty("localize-key")){ %>
                <% =Helpers.Common.Helper.NullableObjectToTrimedString(GetLocalResourceObject(mi.Properties.GetLocalizePropertyValue("localize-key")), "") %>
            <% }else{ %>
                <% =mi.Name %>
            <% } %>
        </h4>
        <ul class="nav nav-list">
            <% foreach(WebApp.MenuItem cmi in mi.Children){ %>
            <li
                <%
                   cmi.Properties.GetDataProperties().ForEach(t =>
                   {
                       Response.Write(t.Name + "='" + t.Value + "'");
                   }); 
                %>
                >
                <a href="<% = cmi.URL %>">
                    <% if (cmi.Properties.HasProperty("localize-key"))
                       { %>
                        <% =Helpers.Common.Helper.NullableObjectToTrimedString(GetLocalResourceObject(cmi.Properties.GetLocalizePropertyValue("localize-key")), "") %>
                    <% }else{ %>
                        <% = cmi.Name %>
                    <% } %>
                </a>
            </li>
            <% } %>
        </ul>
    </div>
    <% } %>

    <%--<div class="well sidebar-nav">    
        <h4><asp:Localize runat="server" meta:resourcekey="configuration_label" /></h4>
        <ul class="nav nav-list">    
            <li data-screenid="account-information">
                <a href="!/ih/configuration/accountinformation"><asp:Localize runat="server" meta:resourcekey="accountinformation_nav_label" /></a>
            </li>
            {{#if showUsers}}
            <li data-screenid="users">
                <a href="!/ih/configuration/users"><asp:Localize runat="server" meta:resourcekey="users_nav_label" /></a>
            </li>
            {{/if}}
            <li data-screenid="data-sources-configuration">
                <a href="!/ih/configuration/datasources" style="width:100%;display:inline-block;">
                    <span style="float:left;width:auto;"><asp:Localize runat="server" meta:resourcekey="datasources_nav_label" /></span>
                    <div id="menu_datasources_error_icon" class="menu-error-icon">
                        <i  class="fa fa-remove"></i>
                    </div>
                </a>
            </li>
            <li data-screenid="dot-programs">
                <a href="!/ih/configuration/dotprograms"><asp:Localize runat="server" meta:resourcekey="dot_programs_nav_label" /></a>
            </li>
            <li data-screenid="tags-configuration">
                <a href="!/ih/configuration/tags"><asp:Localize runat="server" meta:resourcekey="tags_nav_label" /></a>
            </li>
            <% if (withModules){ %>
            <li data-screenid="network-overview">
                <a href="!/ih/configuration/networkoverview"><asp:Localize runat="server" meta:resourcekey="networkoverview_nav_label" /></a>
            </li>
            <% } %>
            {{#if showTagsExporationConfiguration}}
            <li data-screenid="tags-export-configuration">
                <a href="!/ih/configuration/tagsexportconfiguration"><asp:Localize runat="server" meta:resourcekey="tagsExportConfiguration_nav_label" /></a>
            </li>
            {{/if}}
            {{#if showSystemNetworkConfiguration}}
            <li data-screenid="system-network-configuration">
                <a href="!/ih/configuration/systemnetworkconfiguration"><asp:Localize runat="server" meta:resourcekey="systemNetworkConfiguration_nav_label" /></a>
            </li>
            {{/if}}
            {{#if showResetToFactoryDefaults}}
            <li data-screenid="reset-to-factory-defaults">
                <a href="!/ih/configuration/resettofactorydefaults"><asp:Localize runat="server" meta:resourcekey="resetToFactoryDefaults_nav_label" /></a>
            </li>
            {{/if}}
            {{#if showSystemAdminDashboard}}
            <li>
                <a data-bypass="" href="<% =ResolveUrl("/admin") %>"><asp:Localize runat="server" meta:resourcekey="systemAdminDashboard_nav_label" /></a>
            </li>
            {{/if}}
        </ul>
    </div>
    
    <div class="well sidebar-nav">
        <h4>Security</h4>
        <ul class="nav nav-list">
            <li data-screenid="profiles">
                <a href="!/ih/configuration/securityprofiles">Profiles</a>
            </li>
        </ul>
    </div>

    <div class="well sidebar-nav">
        <ul class="nav nav-list">
            <li data-screenid="about">
                <a href="!/ih/configuration/about"><asp:Localize runat="server" meta:resourcekey="about_label" /></a>
            </li>
        </ul>
    </div>--%>
</div>
<div class="container-fluid">
    <div class="configuration-content offset3 span9">
        <div class="row-fluid">
            <%--container for subview--%>
            <div id="configuration_dashboard_screen_container"></div>
        </div>
    </div>
</div>