﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
//@Override this is suggested by Microsoft, overriding the initialize culture function (that is
//automatically called by the aspx.
//Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
//(English).
protected override void InitializeCulture()
{
    HttpCookie lang = Request.Cookies["siteLanguage"]; 
    
    String selectedLanguage = (lang != null) ? lang.Value : "en";
    UICulture = selectedLanguage ;
    Culture = selectedLanguage ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(selectedLanguage);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(selectedLanguage);
    base.InitializeCulture();
}
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
    
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<div class="container-fluid">
    <div class="container-fluid">
        <div class="row-fluid text-center">
            <div class="span12">
                <div class="fadeIn animated">
                    <h2>
                        <strong><asp:Localize runat="server" meta:resourcekey="about_us_label" /></strong>
                    </h2>
                </div>
            </div>
        </div>
    </div>
    <div style="margin-top:0px;" class="row-fluid fadeIn animated">
    <div class="row-fluid text-center">
       
        <div class="span12">
             <p style="margin-bottom:0px !important;" class="lead">USA</p>
        </div>
    </div>
    <hr style="margin-top: 5px;margin-bottom: 20px;border: 0;border-top: 1px solid #eee;" />
    <div class="row-fluid text-center" style="font-size:15px;">
	     <div class="span12">
          <div>
            <p>
              <b>AustralTek LLC</b>
            </p>
            <p>800 Old Pond Road - Suite 706K</p>
            <p>Bridgeville, PA 15017</p>
            <p>United States of America</p>
            <p>+1 412 257 2377</p>
            <p>info@australtek.com</p>
          </div>
        </div>
      </div>
    </div>
</div>