﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>

<script runat="server">
    //@Override this is suggested by Microsoft, overriding the initialize culture function (that is
    //automatically called by the aspx.
    //Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
    //(English).
    protected override void InitializeCulture()
    {
   
        HttpCookie lang = Request.Cookies["siteLanguage"];

        String selectedLanguage = (lang != null) ? lang.Value : "en";
        UICulture = selectedLanguage;
        Culture = selectedLanguage;

        Thread.CurrentThread.CurrentCulture =
            CultureInfo.CreateSpecificCulture(selectedLanguage);
        Thread.CurrentThread.CurrentUICulture = new
            CultureInfo(selectedLanguage);
        base.InitializeCulture();
    }
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
 
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/app/custom-screens/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + ".css")%>" rel="stylesheet" />



<div class="row-fluid subnavbar fixed-subnavbar" style="min-width:1305px;"> 
    <div class="form-inline pull-left span12" style="min-width:1500px;"> 
        <div class="span8">
        <label class="control-label" for="dateStartTbx"> 
            <asp:localize runat="server" meta:resourcekey="date_start_tbx_label" />
        </label>
        <label class="input-prepend"> 
            <span class="add-on"><i class="icon-calendar"></i></span>
            <input type="text" id="dateStartTbx" class="input-date" style="width:75px;z-index:1000;" data-bind="value: from">
        </label>
        <label class="control-label" for="dateEndTbx"> 
            <asp:localize runat="server" meta:resourcekey="date_end_tbx_label" />
        </label>
        <label class="input-prepend" > 
            <span class="add-on"><i class="icon-calendar"></i></span>
            <input type="text" id="dateEndTbx" class="input-date" style="width:75px;z-index:1000;" data-bind="value: to">
        </label>

        <label class="control-label"> 
            <asp:localize runat="server" meta:resourcekey="shift_combo_label" />
            <select style="width:55px;" data-bind="value: shiftId, options: shifts, optionsDefault: { label: '<asp:localize runat=server meta:resourcekey=shift_combo_all_opt />', value: -1} ">
            </select>
        </label>
           
        
        <label class="control-label">
            <asp:localize runat="server" meta:resourcekey="crew_combo_label" />
            <select style="width:55px;" data-bind="value: crewId, options: crews, optionsDefault: { label: '<asp:localize runat=server meta:resourcekey=crew_combo_all_opt />', value: -1 } "></select> 
        </label>

        <%--<label class="control-label">
            <asp:localize runat="server" meta:resourcekey="line_combo_label" />
            <select style="width:150px;" data-bind="value: integer(lineProductionItemId), options: lines, optionsDefault: { label: '<asp:Localize runat=server meta:resourcekey=all_lines_label />', value: -1 }" >
            </select>
        </label>--%>

        <label class="control-label">
            <asp:localize runat="server" meta:resourcekey="machine_combo_label" />
            <select style="width:150px;" data-bind="value: integer(machineProductionItemId), options: machines, optionsDefault: { label: '<asp:Localize runat=server meta:resourcekey=all_machines_label />', value: -1 }" >
            </select>
        </label>
        <label class="control-label">
            <asp:localize runat="server" meta:resourcekey="delay_categories_combo_label" />
            <select style="width:150px;" data-bind="value: delayCategoryId, options: delayCategories, optionsDefault: { label: '<asp:Localize runat=server meta:resourcekey=all_delays_label />', value: -1 }">
            </select>
        </label>

        <button id="refreshBtn" class="btn btn-primary" style="margin-bottom:5px;margin-left:10px;" title="<asp:localize runat=server meta:resourcekey=refresh_btn_title />">
            <i class="fa fa-refresh"></i>
        </button>
        </div>
        <%--<button style="margin-top:-5px; margin-left:10px; margin-right:10px;" class="btn btn-export-to-excel" type="button">
            <span class="excel-export-state fa fa-file-excel-o"></span>
            <img class="loading-state hide" style="width:20px;height:20px;" src="<%= ResolveUrl("~/assets/img/spinner20.gif") %>" />
        </button>--%>
        <div class="span4">
            <div class="row-fluid">
                <div id="refs-screen-categories-c1" style="float:right;margin-top:0px"></div> 
            </div>
            <div class="row-fluid">
                <div id="refs-screen-categories-c2" style="float:right;margin-top:0px"></div> 
            </div>
        </div>
    </div>
</div>
<div class="row-fluid screen-content">
    <div class="pull-left" style="width:100%;margin-left:0; margin-top:1%;">    
        <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: any(hasData, isLoading), }" style="height:500px;">
            <div class="row-fluid" style="position:relative;top:100px;">
                <i class="fw-icon-circle-blank fw-icon-4x" style="font-size:115px;"></i>
            </div>
            <div class="row-fluid" style="position:relative;top:115px;">
                <h3 style="font-size:50px;">
                    <asp:localize runat="server" meta:resourcekey="no_data_available" />
                </h3>
            </div>
        </div>
        <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: not(isLoading), }" style="height:500px;">
            <div class="row-fluid" style="position:relative;top:100px;">
                <i class="fa fa-cog fw-icon-4x fa-spin" style="font-size:115px;"></i>
            </div>
            <div class="row-fluid" style="position:relative;top:115px;">
                <h3 style="font-size:50px;">
                    <asp:localize runat="server" meta:resourcekey="loading_data" />
                </h3>
            </div>
        </div>
        <div class="items-grid-container row-fluid infinite-container" data-bind="classes: { hide: any(not(hasData), isLoading), }"></div>
        <div class="row-fluid" data-bind="classes: { hide: any(not(hasData), isLoading), }">
            <div style="height:300px; margin-left:-60px;" class="delays-chart-container span12"></div>
        </div>
        <div class="row-fluid">
            <span style="font-size:14px;font-weight:bold;" class="total-time-span"></span>
        </div>
    </div>
</div>
 <script id="progress_bar_template" type="text/x-handlebars-template">
       <div style="height:16px;width:300px;" >
           <svg class="row-container">
               <rect width="300" height="16" class="rect"></rect>
           </svg>
       </div> 
</script>

 <script id="progress_bar_template_2" type="text/x-handlebars-template">
       <div style="height:16px;width:300px;" >
           <svg class="row-container-total">
           </svg>
       </div> 
</script>