﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>

<script runat="server">
    String version = WebAppVersion.GetWebAppVersion();

    //@Override this is suggested by Microsoft, overriding the initialize culture function (that is
    //automatically called by the aspx.
    //Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
    //(English).
    protected override void InitializeCulture()
    {
        HttpCookie lang = Request.Cookies["siteLanguage"];

        String selectedLanguage = (lang != null) ? lang.Value : "en";
        UICulture = selectedLanguage;
        Culture = selectedLanguage;

        Thread.CurrentThread.CurrentCulture = CultureInfo.CreateSpecificCulture(selectedLanguage);
        Thread.CurrentThread.CurrentUICulture = new CultureInfo(selectedLanguage);
        base.InitializeCulture();
    }
</script>

<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).

    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css")%>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/extensions/valid-limit-cell/backgrid-valid-limit-cell.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/autocomplete/backbone.autocomplete.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/app/custom-screens/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + ".css")%>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/multiselect/virtual-select.min.css") %>" rel="stylesheet" />

<div class="row-fluid subnavbar fixed-subnavbar not-print" style="margin-bottom: 0px;">
    <div class="row-fluid form-inline">
        <div class="span12 row-fluid">
             <div class="span4">                
                <div style="text-align: left;">
                    <button id="backNavBtn" style="margin-left:5px;" class="btn btn-nav btn-primary">
                        <asp:Localize runat="server" meta:resourcekey="back_item_btn_label" />
                    </button>          
                    <label class="control-label" style="width:200px;">
                         <div id="heat-picker-multi-select"></div>
                   </label>
                    <button id="forwardNavBtn" class="btn btn-nav btn-primary" >
                            <asp:Localize runat="server" meta:resourcekey="forward_item_btn_label" />
                    </button>
                </div>        
           
            </div>
            
            <div class="span5">                
                <div class="navigation-buttons" data-bind="classes: { hide: any(not(hasData), isLoading), }" style="margin-left: -30px;"></div>
            </div>
            <div class="span2">
                <button id="refreshBtn" class="btn btn-primary pull-right" style="margin-right: 10px;" title="<asp:localize runat=server meta:resourcekey=refresh_btn_title />">
                    <i class="fa fa-refresh"></i>
                </button>

            </div>
        </div>
    </div>
</div>

<div class="row-fluid screen-content">
    <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: any(hasData, isLoading), }" style="height: 500px;">
        <div class="row-fluid" style="position: relative; top: 100px;">
            <i class="fw-icon-circle-blank fw-icon-4x" style="font-size: 115px;"></i>
        </div>
        <div class="row-fluid" style="position: relative; top: 115px;">
            <h3 style="font-size: 50px;">
                <asp:Localize runat="server" meta:resourcekey="no_data_available" />
            </h3>
        </div>
    </div>
    <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: not(isLoading), }" style="height: 500px;">
        <div class="row-fluid" style="position: relative; top: 100px;">
            <i class="fa fa-cog fw-icon-4x fa-spin" style="font-size: 115px;"></i>
        </div>
        <div class="row-fluid" style="position: relative; top: 115px;">
            <h3 style="font-size: 50px;">
                <asp:Localize runat="server" meta:resourcekey="loading_data" />
            </h3>
        </div>
    </div>

     <div class="main-data-container" data-bind="classes: { hide: any(not(hasData), isLoading), }">
        <div class="center-box-small">
            <div class="row-fluid box-container-small" style="margin-top:10px;">  
                <div class="data-container-small">
                    <h5 class="grid-title-small" data-bind="text:  coalesce(mainData_headerInfo, '-'),"></h5>
                </div>        
            </div>
        </div>
        
    </div>

    <div class="tables-container row-fluid" data-bind="classes: { hide: any(not(hasData), isLoading), }">   
        <div class="span4">            
            <table class="grid-styles table">
                    <thead>
                    <tr>
                        <th colspan="2">Information</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>Melt Order</td>                                
                        <td> <span class="info-field-value" data-bind="text:  coalesce(mainData_meltOrder, '-'),"></span></td>
                    </tr> 
                    <tr>
                        <td>Free Open</td>                                
                        <td> 
                            <span class="info-field-value" data-bind="text:  coalesce(mainData_freeOpen, '-'),"></span>                  
                        </td>
                    </tr>
                        <tr>
                        <td>Tundish</td>                                
                        <td> <span class="info-field-value" data-bind="text:  coalesce(secondaryData1_tundish, '-'),"></span></td>
                    </tr>
                    <tr>
                        <td>Last In Sequence</td>                                
                        <td> <span class="info-field-value" data-bind="text:  coalesce(secondaryData1_last, '-'),"></span></td>
                    </tr>
                    <tr>
                        <td>Tundish Temperatures</td>                                
                        <td> <span class="info-field-value" data-bind="text:  coalesce(secondaryData1_TundishTemps, '-'),"></span></td>
                    </tr>
                
                    <tr>
                        <td>Wait Time</td>
                            <td>
                            <span class="info-field-value" data-bind="text:  coalesce(duration(secondaryData2_waitTime, 's','m:s'), '-'),"></span>
                            <span class="info-unit-label"><asp:Localize runat=server meta:resourcekey=process_info_mm_ss_unit_legend /></span>
                            </td>
                    </tr>
                    <tr>
                        <td>Open Time</td>                                
                        <td>
                                <span class="info-field-value" data-bind="text:  coalesce(duration(secondaryData2_openTime, 's','m:s'), '-'),"></span>
                            <span class="info-unit-label"><asp:Localize runat=server meta:resourcekey=process_info_mm_ss_unit_legend /></span>
                        </td>
                    </tr>                   
                    <tr>
                        <td>Cast Time</td>                                
                        <td> 
                            <span class="info-field-value" data-bind="text:  coalesce(duration(secondaryData2_castTime, 's','m:s'), '-'),"></span>
                            <span class="info-unit-label"><asp:Localize runat=server meta:resourcekey=process_info_mm_ss_unit_legend /></span>
                        </td>
                    </tr>
                    <tr>
                        <td>Arrive</td>                                
                        <td> 
                            <span class="info-field-value" data-bind="text:  coalesce(secondaryData2_arrive, '-'),"></span>
                            <span class="info-unit-label"><asp:Localize runat=server meta:resourcekey=process_info_hh_mm_unit_legend /></span>
                        </td>
                    </tr>
                    <tr>
                        <td>Open</td>                                
                        <td> 
                            <span class="info-field-value" data-bind="text:  coalesce(secondaryData2_open, '-'),"></span>                            
                            <span class="info-unit-label"><asp:Localize runat=server meta:resourcekey=process_info_hh_mm_unit_legend /></span>
                        </td>
                    </tr>
                        <tr>
                        <td>Close</td>                                
                        <td> 
                            <span class="info-field-value" data-bind="text:  coalesce(secondaryData2_close, '-'),"></span>                               
                            <span class="info-unit-label"><asp:Localize runat=server meta:resourcekey=process_info_hh_mm_unit_legend /></span>
                        </td>
                    </tr>
                </tbody>
            </table>
            <div class="probes-items-grid-container items-grid-container" ></div>
            <div class="process-products-grid-container items-grid-container"></div>
        </div>
        <div class="span8 row-fluid">
             <!---STRAND 1-->
            <div class="span3">
                <table class="grid-styles table">
                        <thead>
                        <tr>
                            <th colspan="2" data-bind="text:strandPos1"></th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>Mold Number</td>
                            <td> <span class="info-field-value" data-bind="text:  coalesce(strand1_moldNumber, '-'),"></span></td>
                        </tr>
                        <tr>
                            <td>Start Length</td>                                
                            <td> <span class="info-field-value" data-bind="text:  coalesce(strand1_startLength, '-'),"></span></td>
                        </tr>
                        <tr>
                            <td>End Length</td>                                
                            <td> <span class="info-field-value" data-bind="text:  coalesce(strand1_endLength, '-'),"></span></td>
                        </tr>
                        <tr>
                            <td>Cast Length</td>                                
                            <td> <span class="info-field-value" data-bind="text:  coalesce(strand1_castedLength, '-'),"></span></td>
                        </tr>
                        <tr>
                            <td>Products</td>                                
                            <td> <span class="info-field-value" data-bind="text:  coalesce(strand1_sumProducts, '-'),"></span></td>
                        </tr>
                        <tr>
                            <td>Lost</td>                                
                            <td> <span class="info-field-value" data-bind="text:  coalesce(strand1_strandLost, '-'),"></span></td>
                        </tr>
                    </tbody>
                </table>
            </div>
                <!---STRAND 2-->
            <div class="span3">
                <table class="grid-styles table">
                        <thead>
                        <tr>
                            <th colspan="2" data-bind="text:strandPos2"></th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>Mold Number</td>
                            <td> <span class="info-field-value" data-bind="text:  coalesce(strand2_moldNumber, '-'),"></span></td>
                        </tr>
                        <tr>
                            <td>Start Length</td>                                
                            <td> <span class="info-field-value" data-bind="text:  coalesce(strand2_startLength, '-'),"></span></td>
                        </tr>
                        <tr>
                            <td>End Length</td>                                
                            <td> <span class="info-field-value" data-bind="text:  coalesce(strand2_endLength, '-'),"></span></td>
                        </tr>
                        <tr>
                            <td>Cast Length</td>                                
                            <td> <span class="info-field-value" data-bind="text:  coalesce(strand2_castedLength, '-'),"></span></td>
                        </tr>
                        <tr>
                            <td>Products</td>                                
                            <td> <span class="info-field-value" data-bind="text:  coalesce(strand2_sumProducts, '-'),"></span></td>
                        </tr>
                        <tr>
                            <td>Lost</td>                                
                            <td> <span class="info-field-value" data-bind="text:  coalesce(strand2_strandLost, '-'),"></span></td>
                        </tr>
                    </tbody>
                </table>
            </div>
                <!---STRAND 3-->
            <div class="span3">
                <table class="grid-styles table">
                    <thead>
                        <tr>
                            <th colspan="2" data-bind="text:strandPos3"></th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>Mold Number</td>
                            <td> <span class="info-field-value" data-bind="text:  coalesce(strand3_moldNumber, '-'),"></span></td>
                        </tr>
                        <tr>
                            <td>Start Length</td>                                
                            <td> <span class="info-field-value" data-bind="text:  coalesce(strand3_startLength, '-'),"></span></td>
                        </tr>
                        <tr>
                            <td>End Length</td>                                
                            <td> <span class="info-field-value" data-bind="text:  coalesce(strand3_endLength, '-'),"></span></td>
                        </tr>
                        <tr>
                            <td>Cast Length</td>                                
                            <td> <span class="info-field-value" data-bind="text:  coalesce(strand3_castedLength, '-'),"></span></td>
                        </tr>
                        <tr>
                            <td>Products</td>                                
                            <td> <span class="info-field-value" data-bind="text:  coalesce(strand3_sumProducts, '-'),"></span></td>
                        </tr>
                        <tr>
                            <td>Lost</td>                                
                            <td> <span class="info-field-value" data-bind="text:  coalesce(strand3_strandLost, '-'),"></span></td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <!---STRAND 4-->
            <div class="span3">
                <table class="grid-styles table">
                    <thead>
                        <tr>
                            <th colspan="2" data-bind="text:strandPos4"></th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>Mold Number</td>
                            <td> <span class="info-field-value" data-bind="text:  coalesce(strand4_moldNumber, '-'),"></span></td>
                        </tr>
                        <tr>
                            <td>Start Length</td>                                
                            <td> <span class="info-field-value" data-bind="text:  coalesce(strand4_startLength, '-'),"></span></td>
                        </tr>
                        <tr>
                            <td>End Length</td>                                
                            <td> <span class="info-field-value" data-bind="text:  coalesce(strand4_endLength, '-'),"></span></td>
                        </tr>
                        <tr>
                            <td>Cast Length</td>                                
                            <td> <span class="info-field-value" data-bind="text:  coalesce(strand4_castedLength, '-'),"></span></td>
                        </tr>
                        <tr>
                            <td>Products</td>                                
                            <td> <span class="info-field-value" data-bind="text:  coalesce(strand4_sumProducts, '-'),"></span></td>
                        </tr>
                        <tr>
                            <td>Lost</td>                                
                            <td> <span class="info-field-value" data-bind="text:  coalesce(strand4_strandLost, '-'),"></span></td>
                        </tr>
                    </tbody>
                </table>
            </div>
              <div class="chart-container" style="position: relative;width:94%"  data-bind="classes: { hide: any(not(hasData), isLoading), }">        
                 <canvas id="CasterChart"></canvas>
            </div>

        </div>
    </div>

  

</div>

