﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>

<script runat="server">
    String version = WebAppVersion.GetWebAppVersion();

    //@Override this is suggested by Microsoft, overriding the initialize culture function (that is
    //automatically called by the aspx.
    //Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
    //(English).
    protected override void InitializeCulture()
    {
        HttpCookie lang = Request.Cookies["siteLanguage"];

        String selectedLanguage = (lang != null) ? lang.Value : "en";
        UICulture = selectedLanguage;
        Culture = selectedLanguage;

        Thread.CurrentThread.CurrentCulture = CultureInfo.CreateSpecificCulture(selectedLanguage);
        Thread.CurrentThread.CurrentUICulture = new CultureInfo(selectedLanguage);
        base.InitializeCulture();
    }
</script>

<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).

    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css")%>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/extensions/valid-limit-cell/backgrid-valid-limit-cell.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/app/custom-screens/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + ".css")%>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/jquery.contextMenu/jquery.contextMenu.css") %>" rel="stylesheet" />
<div class="row-fluid subnavbar fixed-subnavbar" id="subnavbar_controls" style="margin-bottom: 0px;height:38px !important;">
    <div class="row-fluid form-inline">
        <div class="span10">
            <label class="control-label" for="dateStartTbx">
                <asp:localize runat="server" meta:resourcekey="date_start_tbx_label" />
            </label>
            <label class="input-prepend">
                <span class="add-on"><i class="icon-calendar"></i></span>
                <input type="text" id="dateStartTbx" class="input-date" style="z-index:1000;" data-bind="value: momentFormat(start$, 'YYYY-MM-DD', '<asp:Localize runat=server meta:resourcekey=mmddyyyy_format />')">
            </label>
            <label class="control-label" for="dateEndTbx">
                <asp:localize runat="server" meta:resourcekey="date_end_tbx_label" />
            </label>
            <label class="input-prepend">
                <span class="add-on"><i class="icon-calendar"></i></span>
                <input type="text" id="dateEndTbx" class="input-date" style="z-index:1000;" data-bind="value: momentFormat(end$, 'YYYY-MM-DD', '<asp:Localize runat=server meta:resourcekey=mmddyyyy_format />')">
            </label>
            <label style="margin-left:10px;margin-bottom:0 !important; ">
                <asp:Localize runat="server" meta:resourcekey="caster_label" /> 
                    <select disabled data-bind=" value: casterCode, options: casters,optionsDefault: { label: '<asp:Localize runat=server meta:resourcekey=select_crew_label />', value: null }" style="width:60px;margin-top:0px;">
                    </select>
            </label>
            <label style="margin-left:10px;margin-bottom:0 !important; ">
                <asp:Localize runat="server" meta:resourcekey="crew_label" /> 
                    <select data-bind=" value: crewId, options: crews, optionsDefault: { label: '<asp:Localize runat=server meta:resourcekey=select_crew_label />', value: null }" style="width:60px;margin-top:0px;">
                    </select>
            </label>
            <label style="margin-left:10px;margin-bottom:0 !important; ">
                <asp:Localize runat="server" meta:resourcekey="shift_label" /> 
                    <select data-bind=" value: shiftId, options: shifts, optionsDefault: { label: '<asp:Localize runat=server meta:resourcekey=select_shift_label />', value: null }" style="width:60px;margin-top:0px;">
                    </select>
            </label>

        </div>
        <div class="span2">
            <button style="margin-top:0; margin-left:10px; margin-right:10px;" class="btn btn-export-to-excel pull-right" type="button">
                <span class="excel-export-state fa fa-file-excel-o"></span>
                <img class="loading-state hide" style="width:20px;height:20px;" src="<%= ResolveUrl("~/assets/img/spinner20.gif") %>" />
            </button>
            <button id="refreshBtn" class="btn btn-primary pull-right" style="" title="<asp:localize runat=server meta:resourcekey=refresh_btn_title />">
                <i class="fa fa-refresh"></i>
            </button>
            
        </div>
        
    </div>
</div>
<div class="row-fluid screen-content" id="main-div">
    <div class="pull-left" style="width:100%;margin-left:0;">  
        <div class="processes-grid-container infinite-container" id="caster-production" style="margin-top:20px"></div>
        <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: any(hasData, isLoading), }" style="height:500px;">
            <div class="row-fluid" style="position:relative;top:100px;">
                <i class="fw-icon-circle-blank fw-icon-4x" style="font-size:115px;"></i>
            </div>
            <div class="row-fluid" style="position:relative;top:115px;">
                <h3 style="font-size:50px;">
                    <asp:localize runat="server" meta:resourcekey="no_data_available" />
                </h3>
            </div>
        </div>
        <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: not(isLoading), }" style="height:500px;">
            <div class="row-fluid" style="position:relative;top:100px;">
                <i class="fa fa-cog fw-icon-4x fa-spin" style="font-size:115px;"></i>
            </div>
            <div class="row-fluid" style="position:relative;top:115px;">
                <h3 style="font-size:50px;">
                    <asp:localize runat="server" meta:resourcekey="loading_data" />
                </h3>
            </div>
        </div>
    </div>


</div>


<script id="actions_cell_template" type="text/x-handlebars-template">
    <div class="text-center">
         <button data-toggle="tooltip" data-placement="bottom" data-cell-action="EDIT_DETAILS" title="<asp:Localize runat=server meta:resourcekey=edit_details_title />" class="btn btn-cell-action btn-small btn-edit-details"><i class="fa fa-pencil"></i></button>
    </div>
</script>

<script id="heat_name_cell_template" type="text/x-handlebars-template">
    <div class="text-center">
        <label class="heatName" style="font-size:12px;"></label>   
    </div>
</script>

<script id="assign_heats_modal" type="text/x-handlebars-template">
    <div class="modal-header" >    
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h4>
            <span data-bind="text: title" style="font-weight:bold;"></span>
        </h4>    
    </div>
    <div class="modal-body">
        <div style="padding-bottom:0;" class="modal-body">
            <div class="row-fluid">                 
                
                <div class="pull-left" style="width:100%;margin-left:0;">  
                        <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: any(hasData, isLoading), }" style="height:350px;">
                            <div class="row-fluid" style="position:relative;top:100px;">
                                <i class="fw-icon-circle-blank fw-icon-4x" style="font-size:115px;"></i>
                            </div>
                            <div class="row-fluid" style="position:relative;top:115px;">
                                <h3 style="font-size:50px;">
                                    <asp:localize runat="server" meta:resourcekey="no_data_available" />
                                </h3>
                            </div>
                        </div>
                        <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: not(isLoading), }" style="height:350px;">
                            <div class="row-fluid" style="position:relative;top:100px;">
                                <i class="fa fa-cog fw-icon-4x fa-spin" style="font-size:115px;"></i>
                            </div>
                            <div class="row-fluid" style="position:relative;top:115px;">
                                <h3 style="font-size:50px;">
                                    <asp:localize runat="server" meta:resourcekey="loading_data" />
                                </h3>
                            </div>
                        </div>
                </div>
               
                <div class="last-heats-grid-container row-fluid infinite-container" data-bind="classes: { hide: any(not(hasData), isLoading), }"></div>   

            </div>
        </div>
    </div>
    <div class="modal-footer">
        <div class="modal-status-msg-container pull-left">
            <div class="modal-status-msg hide" data-bind="toggle: notEquals(errorMsg, ''),">
                <span data-bind="text: errorMsg, attr: { title: errorMsg, }," style="color:#ff0000;font-size:16px;"></span>
            </div>
            <div class="modal-status-msg hide" data-bind="toggle: processing,">
                <asp:Localize runat='server' meta:resourcekey='processing_msg' />
                <i class="fa fa-cog fa-spin"></i>
            </div>
        </div>
<%--        <button  id="unassignBtn" class="btn btn-primary btn-danger" data-bind="enabled: not(processing), classes: { hide: not(show_unassign_btn), }">
            <asp:Localize runat='server' meta:resourcekey='unassign_btn_label' />
        </button>--%>
        <button id="acceptBtn" class="btn btn-primary" data-bind="enabled: all(not(processing), selectedHeatId),">
            <asp:Localize runat='server' meta:resourcekey='accept_btn_label' />
        </button>
        
        <button id="cancelBtn" class="btn" data-dismiss="modal" data-bind="enabled: not(processing),">
            <asp:Localize runat='server' meta:resourcekey='cancel_btn_label' />
        </button>


    </div>
</script>


<script id="non_free_open_modal_template_caster_production" type="text/x-handlebars-template">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3>
            Quick Shroud | Non Free Open 
        </h3>
    </div>
    <div style="max-height:500px;padding-bottom:0;padding-top:0;" class="modal-body">
        <div style="max-height:450px;padding-bottom:0;" class="modal-body">
            <div class="row-fluid" style="text-align:center;">
                <div style="margin-top:5px; padding-top:5px; text-align:right;" class="span4 control-group form-inline">
                    Heat
                </div>
                <div style="margin-left:10px; margin-top: 5px; float:left;" class="control-group form-inline">
                    <input type="text" style="width:186px;" data-bind="value: trim(heat), enabled: false,"/>
                </div>
            </div>
            <div class="row-fluid" style="text-align:center; text-align:right;">
                <div style="margin-top:5px; padding-top:5px;" class="span4 control-group form-inline">
                    Quick Shroud
                </div>
                <div style="margin-left:10px; margin-top: 5px; float:left;" class="control-group form-inline">
                    <select style="width:80px;" data-bind="value: quickShroud, options: quickShroudOptions"></select>                
                </div>
            
            </div>    
            
            <div class="row-fluid" style="text-align:center; text-align:right;">
                <div style="margin-top:5px; padding-top:5px;" class="span4 control-group form-inline">
                    Is a Non Free Open?
                </div>
                <div style="margin-left:10px; margin-top: 5px; float:left;" class="control-group form-inline">
                    <label class="checkbox" style="font-size:14px; margin-left:10px;">
                        <input type="checkbox" name="nonFreeOpen" data-bind="checked: isNonFreeOpen"
                            style="width:18px; height:18px; vertical-align:middle; margin-right:8px;">
                    
                    </label>
                </div>
            
            </div>    

            <!-- Horizontal separator -->
            <hr style="margin-top:10px; margin-bottom:10px; border: none; border-top: 1px solid #ccc;" />

            
            
            
            <div class="row-fluid" style="text-align:center;" data-bind="classes: { hide: not(isNonFreeOpen), }">
                <div style="margin-top:5px; padding-top:5px; text-align:right;" class="span4 control-group form-inline">
                    Rods
                </div>
                <div style="margin-left:10px; margin-top: 5px; float:left;" class="control-group form-inline">
                    <input type="number" style="width:186px;" data-bind="value: trim(rods), enabled: true,"/>
                </div>
            </div>
       


            <div class="row-fluid" style="text-align:center; text-align:left;" data-bind="classes: { hide: not(isNonFreeOpen), }">
                <div style="margin-top:5px; padding-top:5px;" class="span4 control-group form-inline">
                    Comments
                </div>
            </div>
            <div class="row-fluid" style="text-align:center; text-align:right;" data-bind="classes: { hide: not(isNonFreeOpen), }">
            
                <div style="float:left; width:97%" class="control-group form-inline">
                    <textarea style="width:100%; height:90px;" data-bind="value: comments"></textarea>
                </div>
            </div>
           
        </div>
    </div>
    <div class="modal-footer">
        <button id="acceptBtn" type="button" class="btn btn-success btn-save">Save</button>
        <button type="button" class="btn btn-default btn-cancel" data-dismiss="modal"><asp:Localize runat=server meta:resourcekey=cancel_btn_label /></button>
    </div>
</script>