﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>

<script runat="server">
    String version = WebAppVersion.GetWebAppVersion();

    //@Override this is suggested by Microsoft, overriding the initialize culture function (that is
    //automatically called by the aspx.
    //Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
    //(English).
    protected override void InitializeCulture()
    {
        HttpCookie lang = Request.Cookies["siteLanguage"];

        String selectedLanguage = (lang != null) ? lang.Value : "en";
        UICulture = selectedLanguage;
        Culture = selectedLanguage;

        Thread.CurrentThread.CurrentCulture = CultureInfo.CreateSpecificCulture(selectedLanguage);
        Thread.CurrentThread.CurrentUICulture = new CultureInfo(selectedLanguage);
        base.InitializeCulture();
    }
</script>

<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).

    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css")%>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/extensions/valid-limit-cell/backgrid-valid-limit-cell.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/autocomplete/backbone.autocomplete.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/app/custom-screens/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + ".css")%>" rel="stylesheet" />

<div class="row-fluid subnavbar fixed-subnavbar" style="margin-bottom: 0px;">
    <div class="row-fluid form-inline">
        <div class="span12 row-fluid">
            <div class="span3">
                <button id="backNavBtn" style="margin-left:5px;margin-right:-5px;" class="btn btn-primary ">
                    <asp:Localize runat="server" meta:resourcekey="back_item_btn_label" />
                </button> 
                <label style="margin-left:5px;margin-bottom:0 !important; ">
                    <asp:Localize runat="server" meta:resourcekey="eaf_label" /> 
                        <select data-bind=" value: furnaceCode, options: furnaceCodes, optionsDefault: { label: '<asp:localize runat=server meta:resourcekey=furnaces_combo_all_opt />', value: '-'}" style="width:75px;margin-top:0px;">
                        </select>
                </label>
                <label style="margin-bottom:0 !important; ">
                    <asp:Localize runat="server" meta:resourcekey="heat_name_label" /> 
                    <input type="text" id="search" style="width:100px; text-align:center" data-bind="value: heatName," />
                </label>
                <button id="forwardNavBtn" class="btn btn-primary">
                        <asp:Localize runat="server" meta:resourcekey="forward_item_btn_label" />
                </button>

            </div>
            <div class="span8">
                <div class="navigation-buttons"  data-bind="classes: { hide: any(not(hasData), isLoading), }" style="margin-left:-30px;"></div>
            </div>
            <div class="span1">
                <button id="refreshBtn" class="btn btn-primary pull-right" style="margin-right:10px;" title="<asp:localize runat=server meta:resourcekey=refresh_btn_title />">
                    <i class="fa fa-refresh"></i>
                </button>
            </div>
       </div>
    </div>
</div>

<div class="row-fluid screen-content">
     <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: any(hasData, isLoading), }" style="height:500px;">
        <div class="row-fluid" style="position:relative;top:100px;">
            <i class="fw-icon-circle-blank fw-icon-4x" style="font-size:115px;"></i>
        </div>
        <div class="row-fluid" style="position:relative;top:115px;">
            <h3 style="font-size:50px;">
                <asp:localize runat="server" meta:resourcekey="no_data_available" />
            </h3>
        </div>
    </div>
    <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: not(isLoading), }" style="height:500px;">
        <div class="row-fluid" style="position:relative;top:100px;">
            <i class="fa fa-cog fw-icon-4x fa-spin" style="font-size:115px;"></i>
        </div>
        <div class="row-fluid" style="position:relative;top:115px;">
            <h3 style="font-size:50px;">
                <asp:localize runat="server" meta:resourcekey="loading_data" />
            </h3>
        </div>
    </div>
    <!---Tables--->


    <div class="grids-containers" data-bind="classes: { hide: any(not(hasData), isLoading), }">
         <div class="header-table">
            <table>
                <tbody>
                    <tr>
                        <td><h4>Heat: </h4></td>
                        <td><h5><span data-bind="text: heatName," ></span></h5></td>
                        <td style="width:10%"></td>
                        <td><h4>Grade: </h4></td>
                        <td><h5><span data-bind="text: gradeName," ></span></h5></td>
                    </tr>
                </tbody>
            </table>
        </div>
        <div class="process-process-grid-container items-grid-container"></div>

          <div class="header-table">
            <table>
                <tbody>
                    <tr>
                        <td><h4>Limits </h4></td>
                    </tr>
                </tbody>
            </table>
        </div>

        <div class="process-limits-grid-container items-grid-container"></div>
    </div>

      
</div>
