﻿//SCREEN-BOILERPLATE
//this boilerplate builds screens that are gonna be shown in the <div class='content'> tag of our main HTML.
//do not build app components with this boilerplate, only screens (reports)

define([
    // Application variable, always include it to have access to app methods.
    'app',

    //templates-loader: this loads templates async.
    'js/templates-loader',
    'backgrid',
    'moment',
    'js/d3v4/d3.v4',
    'backgrid/moment-cell',
    'backgrid/grouped-columns',

    "js/jquery.floatThead/jquery.floatThead",
],
    function (app, T, Backgrid, moment, d3) {

        var Screen = { Models: {}, Views: {}, Collections: {} }

        Screen.Models.Main = Backbone.Epoxy.Model.extend({
            defaults: {
               
                hasData: false,
                isLoading: false,
                TWIBlanket: null,
            },
            initialize: function () {
            },

            fetch: function (params) {
                var that = this,
                    qp = new Core.Database.QueryParameters();

                Core.Json.CallProcedure(
                    app.DatabaseNames.MES + '.CAS.GetCoolingBedDataWeb',
                    qp,
                    {
                        onSuccess: function (resp) {
                            try {

                                if ((resp) && (resp.Table)) {
                                    if (resp.Table2) {
                                        that.set('TWIBlanket',resp.Table2[0].TWIBlanket);
                                    }
                                    
                                    that.trigger('GetCoolingBedDataWebReady',resp);

                                }
                                else {
                                    if ((resp) && (resp.Message)) {
                                        console.error(new Error(resp.Message).stack);
                                      //  app.views.topMessages.showMessage('CALL TO DATABASE FAILED', { stay: 5000, });
                                        that.trigger('GetCoolingBedDataWebReady');
                                    }
                                    else {
                                        app.views.topMessages.showMessage('SERVER RESPONSE NOT VALID', { stay: 5000, });
                                        console.error(new Error('SERVER_RESPONSE_NOT_VALID').stack);
                                    }
                                }
                            }
                            catch (e) { console.error((e.stack) ? e.stack : new Error(e).stack); }
                        },
                        onFailure: function (resp) {
                            console.error(resp);
                        },
                        Secured: true,
                        Async: true,
                    },
                    app.ConnectionStrings.app
                );
                return this;
            },
        });


        Screen.Views.Main = Backbone.Epoxy.View.extend({
            template: 'cooling-bed',
            id: 'cooling-bed',
            title: 'Cooling Bed',
            events: function () {
                return {
                      'click #TWIBtn': this.TWIBtn_click,
                };
            },
            bindings: 'data-bind',
            bindingSources: null,
            grids: null,
            subviews: null,
            viewParams: null,


            tooltip: null,
            tooltip1: null,
            pauseTimer: false,

            initialize: function () {
                this.options.state = app.view_states.loading;
                this.options.onappend = (_.isFunction(this.options.onappend)) ? this.options.onappend : function () { };

                var that = this;

                if (!this.model)
                    this.model = new Screen.Models.Main();


                this.subviews = {};

                this.autoRefresh = {
                    enabled: null
                    , toid: null
                    , every: 2 * 1000
                };

                this.bindEvents();
            },
            bindEvents: function () {
                this.listenTo(this.model, 'GetCoolingBedDataWebReady', this.GetCoolingBedDataWebReady_ready);

            },
            TWIBtn_click: function(){
                var TWIBlanket = this.model.get('TWIBlanket')
                if (TWIBlanket)  Backbone.history.navigate('!/twi-management/' +TWIBlanket, { trigger: true });
                else Backbone.history.navigate('!/twi-management/', { trigger: true });
            },
            drawElementsInCollingBed: function(linePositions){
                var that = this;
                if (linePositions.S1_P1 ==1 && !$(".el-bed-1-1")[0]) that.drawHeatInCoolingBed(1,1,linePositions.S1_HeatData,linePositions.S1_Weight); else if (linePositions.S1_P1 ==0 && $(".el-bed-1-1")[0]) that.removeElement(".el-bed-1-1")
                if (linePositions.S1_P2 ==1 && !$(".el-bed-1-2")[0]) that.drawHeatInCoolingBed(1,2,linePositions.S1_HeatData,linePositions.S1_Weight); else if (linePositions.S1_P2 ==0 && $(".el-bed-1-2")[0]) that.removeElement(".el-bed-1-2")
                if (linePositions.S1_P3 ==1 && !$(".el-bed-1-3")[0]) that.drawHeatInCoolingBed(1,3,linePositions.S1_HeatData,linePositions.S1_Weight); else if (linePositions.S1_P3 ==0 && $(".el-bed-1-3")[0]) that.removeElement(".el-bed-1-3")
                if (linePositions.S1_P4 ==1 && !$(".el-bed-1-4")[0]) that.drawHeatInCoolingBed(1,4,linePositions.S1_HeatData,linePositions.S1_Weight); else if (linePositions.S1_P4 ==0 && $(".el-bed-1-4")[0]) that.removeElement(".el-bed-1-4")
                if (linePositions.S1_P5 ==1 && !$(".el-bed-1-5")[0]) that.drawHeatInCoolingBed(1,5,linePositions.S1_HeatData,linePositions.S1_Weight); else if (linePositions.S1_P5 ==0 && $(".el-bed-1-5")[0]) that.removeElement(".el-bed-1-5")
                if (linePositions.S1_P6 ==1 && !$(".el-bed-1-6")[0]) that.drawHeatInCoolingBed(1,6,linePositions.S1_HeatData,linePositions.S1_Weight); else if (linePositions.S1_P6 ==0 && $(".el-bed-1-6")[0]) that.removeElement(".el-bed-1-6")
                if (linePositions.S1_DD0 ==1 && !$(".el-dd-1-1")[0]) that.drawHeatsInDDPositions(1,1,linePositions.S1_HeatData,linePositions.S1_Weight)
                if (linePositions.S1_DD1 ==1 && !$(".el-dd-2-1")[0]) that.drawHeatsInDDPositions(2,1,linePositions.S1_HeatData,linePositions.S1_Weight)
                if (linePositions.S1_DD2 ==1 && !$(".el-dd-3-1")[0]) that.drawHeatsInDDPositions(3,1,linePositions.S1_HeatData,linePositions.S1_Weight)
                if (linePositions.S1_DD3 ==1 && !$(".el-dd-4-1")[0]) that.drawHeatsInDDPositions(4,1,linePositions.S1_HeatData,linePositions.S1_Weight)



                if (linePositions.S2_P1 ==1 && !$(".el-bed-2-1")[0]) that.drawHeatInCoolingBed(2,1,linePositions.S2_HeatData,linePositions.S2_Weight); else if (linePositions.S2_P1 ==0 && $(".el-bed-2-1")[0]) that.removeElement(".el-bed-2-1")
                if (linePositions.S2_P2 ==1 && !$(".el-bed-2-2")[0]) that.drawHeatInCoolingBed(2,2,linePositions.S2_HeatData,linePositions.S2_Weight); else if (linePositions.S2_P2 ==0 && $(".el-bed-2-2")[0]) that.removeElement(".el-bed-2-2")
                if (linePositions.S2_P3 ==1 && !$(".el-bed-2-3")[0]) that.drawHeatInCoolingBed(2,3,linePositions.S2_HeatData,linePositions.S2_Weight); else if (linePositions.S2_P3 ==0 && $(".el-bed-2-3")[0]) that.removeElement(".el-bed-2-3")
                if (linePositions.S2_P4 ==1 && !$(".el-bed-2-4")[0]) that.drawHeatInCoolingBed(2,4,linePositions.S2_HeatData,linePositions.S2_Weight); else if (linePositions.S2_P4 ==0 && $(".el-bed-2-4")[0]) that.removeElement(".el-bed-2-4")
                if (linePositions.S2_P5 ==1 && !$(".el-bed-2-5")[0]) that.drawHeatInCoolingBed(2,5,linePositions.S2_HeatData,linePositions.S2_Weight); else if (linePositions.S2_P5 ==0 && $(".el-bed-2-5")[0]) that.removeElement(".el-bed-2-5")
                if (linePositions.S2_P6 ==1 && !$(".el-bed-2-6")[0]) that.drawHeatInCoolingBed(2,6,linePositions.S2_HeatData,linePositions.S2_Weight); else if (linePositions.S2_P6 ==0 && $(".el-bed-2-6")[0]) that.removeElement(".el-bed-2-6")
                if (linePositions.S2_DD0 ==1 && !$(".el-dd-1-1")[0]) that.drawHeatsInDDPositions(1,1,linePositions.S2_HeatData,linePositions.S2_Weight)
                if (linePositions.S2_DD1 ==1 && !$(".el-dd-2-1")[0]) that.drawHeatsInDDPositions(2,1,linePositions.S2_HeatData,linePositions.S2_Weight)
                if (linePositions.S2_DD2 ==1 && !$(".el-dd-3-1")[0]) that.drawHeatsInDDPositions(3,1,linePositions.S2_HeatData,linePositions.S2_Weight)
                if (linePositions.S2_DD3 ==1 && !$(".el-dd-4-1")[0]) that.drawHeatsInDDPositions(4,1,linePositions.S2_HeatData,linePositions.S2_Weight)



                        
                if (linePositions.S3_P1 ==1 && !$(".el-bed-3-1")[0]) that.drawHeatInCoolingBed(3,1,linePositions.S3_HeatData,linePositions.S3_Weight); else if (linePositions.S3_P1 ==0 && $(".el-bed-3-1")[0]) that.removeElement(".el-bed-3-1")
                if (linePositions.S3_P2 ==1 && !$(".el-bed-3-2")[0]) that.drawHeatInCoolingBed(3,2,linePositions.S3_HeatData,linePositions.S3_Weight); else if (linePositions.S3_P2 ==0 && $(".el-bed-3-2")[0]) that.removeElement(".el-bed-3-2")
                if (linePositions.S3_P3 ==1 && !$(".el-bed-3-3")[0]) that.drawHeatInCoolingBed(3,3,linePositions.S3_HeatData,linePositions.S3_Weight); else if (linePositions.S3_P3 ==0 && $(".el-bed-3-3")[0]) that.removeElement(".el-bed-3-3")
                if (linePositions.S3_P4 ==1 && !$(".el-bed-3-4")[0]) that.drawHeatInCoolingBed(3,4,linePositions.S3_HeatData,linePositions.S3_Weight); else if (linePositions.S3_P4 ==0 && $(".el-bed-3-4")[0]) that.removeElement(".el-bed-3-4")
                if (linePositions.S3_P5 ==1 && !$(".el-bed-3-5")[0]) that.drawHeatInCoolingBed(3,5,linePositions.S3_HeatData,linePositions.S3_Weight); else if (linePositions.S3_P5 ==0 && $(".el-bed-3-5")[0]) that.removeElement(".el-bed-3-5")
                if (linePositions.S3_P6 ==1 && !$(".el-bed-3-6")[0]) that.drawHeatInCoolingBed(3,6,linePositions.S3_HeatData,linePositions.S3_Weight); else if (linePositions.S3_P6 ==0 && $(".el-bed-3-6")[0]) that.removeElement(".el-bed-3-6")
                if (linePositions.S3_DD0 ==1 && !$(".el-dd-1-1")[0]) that.drawHeatsInDDPositions(1,1,linePositions.S3_HeatData,linePositions.S3_Weight)
                if (linePositions.S3_DD1 ==1 && !$(".el-dd-2-1")[0]) that.drawHeatsInDDPositions(2,1,linePositions.S3_HeatData,linePositions.S3_Weight)
                if (linePositions.S3_DD2 ==1 && !$(".el-dd-3-1")[0]) that.drawHeatsInDDPositions(3,1,linePositions.S3_HeatData,linePositions.S3_Weight)
                if (linePositions.S3_DD3 ==1 && !$(".el-dd-4-1")[0]) that.drawHeatsInDDPositions(4,1,linePositions.S3_HeatData,linePositions.S3_Weight)
       
                

                if (linePositions.S4_P1 ==1 && !$(".el-bed-4-1")[0]) that.drawHeatInCoolingBed(4,1,linePositions.S4_HeatData,linePositions.S4_Weight); else if (linePositions.S4_P1 ==0 && $(".el-bed-4-1")[0]) that.removeElement(".el-bed-4-1")
                if (linePositions.S4_P2 ==1 && !$(".el-bed-4-2")[0]) that.drawHeatInCoolingBed(4,2,linePositions.S4_HeatData,linePositions.S4_Weight); else if (linePositions.S4_P2 ==0 && $(".el-bed-4-2")[0]) that.removeElement(".el-bed-4-2")
                if (linePositions.S4_P3 ==1 && !$(".el-bed-4-3")[0]) that.drawHeatInCoolingBed(4,3,linePositions.S4_HeatData,linePositions.S4_Weight); else if (linePositions.S4_P3 ==0 && $(".el-bed-4-3")[0]) that.removeElement(".el-bed-4-3")
                if (linePositions.S4_P4 ==1 && !$(".el-bed-4-4")[0]) that.drawHeatInCoolingBed(4,4,linePositions.S4_HeatData,linePositions.S4_Weight); else if (linePositions.S4_P4 ==0 && $(".el-bed-4-4")[0]) that.removeElement(".el-bed-4-4")
                if (linePositions.S4_P5 ==1 && !$(".el-bed-4-5")[0]) that.drawHeatInCoolingBed(4,5,linePositions.S4_HeatData,linePositions.S4_Weight); else if (linePositions.S4_P5 ==0 && $(".el-bed-4-5")[0]) that.removeElement(".el-bed-4-5")
                if (linePositions.S4_P6 ==1 && !$(".el-bed-4-6")[0]) that.drawHeatInCoolingBed(4,6,linePositions.S4_HeatData,linePositions.S4_Weight); else if (linePositions.S4_P6 ==0 && $(".el-bed-4-6")[0]) that.removeElement(".el-bed-4-6")
                if (linePositions.S4_DD0 ==1 && !$(".el-dd-1-1")[0]) that.drawHeatsInDDPositions(1,1,linePositions.S4_HeatData,linePositions.S4_Weight)
                if (linePositions.S4_DD1 ==1 && !$(".el-dd-2-1")[0]) that.drawHeatsInDDPositions(2,1,linePositions.S4_HeatData,linePositions.S4_Weight)
                if (linePositions.S4_DD2 ==1 && !$(".el-dd-3-1")[0]) that.drawHeatsInDDPositions(3,1,linePositions.S4_HeatData,linePositions.S4_Weight)
                if (linePositions.S4_DD3 ==1 && !$(".el-dd-4-1")[0]) that.drawHeatsInDDPositions(4,1,linePositions.S4_HeatData,linePositions.S4_Weight)


                

               if (linePositions.S1_DD0 ==0 && linePositions.S2_DD0 ==0 && linePositions.S3_DD0 ==0 && linePositions.S4_DD0 ==0 && $(".el-dd-1-1")[0]) that.removeElement(".el-dd-1-1")
               if (linePositions.S1_DD1 ==0 && linePositions.S2_DD1 ==0 && linePositions.S3_DD1 ==0 && linePositions.S4_DD1 ==0 && $(".el-dd-2-1")[0]) that.removeElement(".el-dd-2-1")
               if (linePositions.S1_DD2 ==0 && linePositions.S2_DD2 ==0 && linePositions.S3_DD2 ==0 && linePositions.S4_DD2 ==0 && $(".el-dd-3-1")[0]) that.removeElement(".el-dd-3-1")
               if (linePositions.S1_DD3 ==0 && linePositions.S2_DD3 ==0 && linePositions.S3_DD3 ==0 && linePositions.S4_DD3 ==0 && $(".el-dd-4-1")[0]) that.removeElement(".el-dd-4-1")
            },

            drawElementsInDestination: function(destinationPositions){
                var that = this;
                
                var HCPositions = _.where(destinationPositions, {DeliveredDestination : 'HC'});
                var CTPositions = _.where(destinationPositions, {DeliveredDestination : 'CT'});
                _.each(HCPositions, function(obj){
                    that.drawProductsInDestination(2,obj);
                });

                 _.each(CTPositions, function(obj){
                    that.drawProductsInDestination(1,obj);
                });

            },

            GetCoolingBedDataWebReady_ready: function (data) {
                var that = this;
                setTimeout(
                    function () {
                        var linePositions = data.Table[0];
                        var destinationPositions = data.Table1;
                        
                        that.drawElementsInCollingBed(linePositions);
                        that.drawElementsInDestination(destinationPositions);

                        that.pauseTimer = false;
                    },
                    100
                );
            },
              
            removeElement: function (className) {
                _.each(document.querySelectorAll(className), function(obj){
                    obj.remove();
                });
                        
            },
            //Auto refresh
            _refresh: function (opt) {
                if (this.autoRefresh.toid != null) {
                    clearTimeout(this.autoRefresh.toid);
                    this.autoRefresh.toid = null;
                }

                if (!this.pauseTimer) this.refresh();

                if (this.autoRefresh.enabled == true) {
                    var that = this;

                    this.autoRefresh.toid = setTimeout(
                        function () { that._refresh(); },
                        this.autoRefresh.every
                    );
                }
            },
            startAutoRefresh: function () {
                try {
                    if (this.autoRefresh.enabled !== true) {
                        var that = this;

                        if (this.autoRefresh.toid != null) {
                            clearTimeout(this.autoRefresh.toid);
                            this.autoRefresh.toid = null;
                        }

                        this.autoRefresh.enabled = true;

                        //use a timeout to execute the first refresh to return the handle to the start function caller.
                        //So when the caller finish it will do the first refresh.
                        this.autoRefresh.toid = setTimeout(
                            function () { that._refresh(); },
                            1
                        );
                    }
                } catch (error) { console.error((error.stack) ? error.stack : new Error(error).stack); }
            },
            stopAutoRefresh: function () {
                if (this.autoRefresh.toid != null) {
                    clearTimeout(this.autoRefresh.toid);
                    this.autoRefresh.toid = null;
                }
                this.autoRefresh.enabled = false;
            },

            refresh: function (viewParams) {
                this.pauseTimer = true;
                this.model.fetch();

            },
            drawProductsInDestination: function (destination, data) {
                var svg = null;
                    that = this;
                    svg = d3.select("#chart");

               
                 var order = data.Order,
                    heatData = data.HeatData,
                    weightData = data.WeightData;
                
                var className ='el-dest-' + destination + '-' + order;
                var id = heatData;

                var elementByClassName = $("."+className)[0];                
                var currenElementId = elementByClassName ? elementByClassName.id : null;

                if (elementByClassName && currenElementId != id) {
                    that.removeElement("."+className)
                }


                if (!$("."+className)[0] && order<=12) {


                    var x = null,
                        y = null,
                        height = 30,
                        width = 280,
                        xTopText = null,
                        yTopText = null,
                        xBottomText = null,
                        yBottomText = null;

                    if (order == 1) y = 570 ;                     
                    if (order == 2) y = 520;                       
                    if (order == 3) y = 470;                      
                    if (order == 4) y = 420;                      
                    if (order == 5) y = 370;                  
                    if (order == 6) y = 320; 
                
                    if (order == 7)  y = 270;                     
                    if (order == 8)  y = 220;                       
                    if (order == 9)  y = 170;                      
                    if (order == 10) y = 120;                      
                    if (order == 11) y = 70;                  
                    if (order == 12) y = 20; 



                    if (destination == 1) {
                        
                        x = 410;

                        
                        
                    if (order == 1) y = 320 ;                     
                    if (order == 2) y = 270;                       
                    if (order == 3) y = 220;                      
                    if (order == 4) y = 170;                      
                    if (order == 5) y = 120;                  
                    if (order == 6) y = 70; 
                
                    if (order == 7)  y = 20;     
                               



                    }
                    if (destination == 2) x = 20;

                                
                    xTopText = x + 25;
                    yTopText = y + 20;
                    xBottomText = x + 20;
                    yBottomText = y + 45;


                    svg.append("rect").attr("class",className).attr("id",heatData).attr("x", x).attr("y", y).attr("width", width).attr("height", height).attr("fill", "#e89f9f").attr("stroke-width", 2).attr("stroke","#de4747")
                    svg.append('text').attr("class",className).attr("id",heatData).text(heatData + ' - ' + weightData).attr('x', xTopText).attr('y', yTopText).attr('fill', 'black').attr('font-weight','bold').attr('font-size','16px');
                
                }

            },

            drawHeatsInDDPositions: function(DDPosition,order,heatData,weightData){
                var svg = null;
                    svg = d3.select("#chart");
                
                var className ='el-dd-' + DDPosition + '-' + order
                 var x = null,
                    y = null,
                    height = 30,
                    width = 280,
                    xTopText = null,
                    yTopText = null,
                    xBottomText = null,
                    yBottomText = null;

                       
                if (order == 1) x = 410;             
                if (DDPosition == 1) y = 410;
                if (DDPosition == 2) y = 460;
                if (DDPosition == 3) y = 510;
                if (DDPosition == 4) y = 560;    

                                
                xTopText = x + 25;
                yTopText = y + 20;
                xBottomText = x + 20;
                yBottomText = y + 45;

                svg.append("rect").attr("class",className).attr("x", x).attr("y", y).attr("width", width).attr("height", height).attr("fill", "#e89f9f").attr("stroke-width", 2).attr("stroke","#de4747")
                   svg.append('text').attr("class",className).text(heatData + ' - ' + weightData).attr('x', xTopText).attr('y', yTopText).attr('fill', 'black').attr('font-weight','bold').attr('font-size','16px');
            
            },


            drawHeatInCoolingBed: function(strand,position,heatData,weightData,productLenght){
                var svg = null;
                    svg = d3.select("#chart");

                
                var className ='el-bed-' + strand + '-' + position

                var x = null,
                    y = null,
                    height = 30,
                    width = 150,
                    xTopText = null,
                    yTopText = null,
                    xBottomText = null,
                    yBottomText = null;

                
                if (position == 1) x = 1200;                     
                if (position == 2) x = 1040;                       
                if (position == 3) x = 880 ;                      
                if (position == 4) x = 710 ;                      
                if (position == 5) x = 550 ;                  
                if (position == 6) x = 390  ; 

                if (strand == 1) y = 645;
                if (strand == 2) y = 685;
                if (strand == 3) y = 725;
                if (strand == 4) y = 765;                 
                               
                xTopText = x + 25;
                yTopText = y + 25;
                xBottomText = x + 20;
                yBottomText = y + 45;

                svg.append("rect").attr("class",className).attr("x", x).attr("y", y).attr("width", width).attr("height", height).attr("fill", "#e89f9f").attr("stroke-width", 2).attr("stroke","#de4747")
                //svg.append('text').attr("class",className).text(heatData).attr('x', xTopText).attr('y', yTopText).attr('fill', 'black').attr('font-weight','bold').attr('font-size','16px');
                //svg.append('text').attr("class",className).text(weightData).attr('x', xBottomText).attr('y', yBottomText).attr('fill', 'black').attr('font-weight','bold');              
            },


            drawLayout:function() {
                var that = this;
                var svg = null;
                    svg = d3.select("#chart");

                
                //Vertical Lines -- Bottom
                svg.append("line").attr("x1", 390  ).attr("y1", 640).attr("x2", 390  ).attr("y2", 800).attr("stroke","gray").attr("stroke-width",3);
                svg.append('text').text("Pos 6").attr('x', 390).attr('y', 815).attr('fill', 'black');
                svg.append("line").attr("x1", 550 ).attr("y1", 640).attr("x2", 550 ).attr("y2", 800).attr("stroke","gray").attr("stroke-width",3);
                svg.append('text').text("Pos 5").attr('x', 550).attr('y', 815).attr('fill', 'black');
                svg.append("line").attr("x1", 710 ).attr("y1", 640).attr("x2", 710 ).attr("y2", 800).attr("stroke","gray").attr("stroke-width",3);
                svg.append('text').text("Pos 4").attr('x', 710).attr('y', 815).attr('fill', 'black');
                svg.append("line").attr("x1", 880 ).attr("y1", 640).attr("x2", 880 ).attr("y2", 800).attr("stroke","gray").attr("stroke-width",3);
                svg.append('text').text("Pos 3").attr('x', 880).attr('y', 815).attr('fill', 'black');
                svg.append("line").attr("x1", 1040).attr("y1", 640).attr("x2", 1040).attr("y2", 800).attr("stroke","gray").attr("stroke-width",3);
                svg.append('text').text("Pos 2").attr('x', 1040).attr('y', 815).attr('fill', 'black');
                svg.append("line").attr("x1", 1200).attr("y1", 640).attr("x2", 1200).attr("y2", 800).attr("stroke","gray").attr("stroke-width",3);
                svg.append('text').text("Pos 1").attr('x', 1200).attr('y', 815).attr('fill', 'black');
                
                
                //Horizontal Lines -- Bottom
                
                svg.append("line").attr("x1", 390).attr("y1", 640).attr("x2", 1200).attr("y2", 640).attr("stroke","blue").attr("stroke-dasharray",5,5);
                svg.append("line").attr("x1", 390).attr("y1", 680).attr("x2", 1200).attr("y2", 680).attr("stroke","blue").attr("stroke-dasharray",5,5);
                svg.append("line").attr("x1", 390).attr("y1", 720).attr("x2", 1200).attr("y2", 720).attr("stroke","blue").attr("stroke-dasharray",5,5);
                svg.append("line").attr("x1", 390).attr("y1", 760).attr("x2", 1200).attr("y2", 760).attr("stroke","blue").attr("stroke-dasharray",5,5);
                svg.append("line").attr("x1", 390).attr("y1", 800).attr("x2", 1200).attr("y2", 800).attr("stroke","blue").attr("stroke-dasharray",5,5);
                


                //Vertical Lines -- Top                
                svg.append("line").attr("x1", 400).attr("y1", 400).attr("x2", 400 ).attr("y2", 600).attr("stroke","gray").attr("stroke-width",3);
                                
                
                //Horizontal Lines -- Top
                svg.append("line").attr("x1", 400).attr("y1", 400).attr("x2", 600 ).attr("y2", 400).attr("stroke","blue").attr("stroke-dasharray",5,5);
                svg.append('text').text("DD0").attr('x', 360).attr('y', 430).attr('fill', 'black');
                svg.append("line").attr("x1", 400).attr("y1", 450).attr("x2", 600).attr("y2", 450).attr("stroke","blue").attr("stroke-dasharray",5,5);
                svg.append('text').text("DD1").attr('x', 360).attr('y', 480).attr('fill', 'black');
                svg.append("line").attr("x1", 400).attr("y1", 500).attr("x2", 600).attr("y2", 500).attr("stroke","blue").attr("stroke-dasharray",5,5);
                svg.append('text').text("DD2").attr('x', 360).attr('y', 530).attr('fill', 'black');
                svg.append("line").attr("x1", 400).attr("y1", 550).attr("x2", 600).attr("y2", 550).attr("stroke","blue").attr("stroke-dasharray",5,5);
                svg.append('text').text("DD3").attr('x', 360).attr('y', 580).attr('fill', 'black');
                svg.append("line").attr("x1", 400).attr("y1", 600).attr("x2", 600).attr("y2", 600).attr("stroke","blue").attr("stroke-dasharray",5,5);


                svg.append("rect").attr("x", 100).attr("y", 620).attr("width", 100).attr("height", 40).attr("fill", "lightgray").attr("stroke-width", 1).attr("stroke","black")
                svg.append('text').text("To Furnace").attr('x', 115).attr('y', 645).attr('fill', 'black');

                svg.append("rect").attr("x", 490).attr("y", 355).attr("width", 100).attr("height", 40).attr("fill", "lightgray").attr("stroke-width", 1).attr("stroke","black")
                svg.append('text').text("Cooling Bed").attr('x', 500).attr('y', 380).attr('fill', 'black');


                //Arrows
                
                //svg.append("line").attr("x1", 1530).attr("y1", 720).attr("x2", 1500).attr("y2", 740).attr("stroke","gray").attr("stroke-width",3);
                //svg.append("line").attr("x1", 1530).attr("y1", 760).attr("x2", 1500).attr("y2", 740).attr("stroke","gray").attr("stroke-width",3);
                //svg.append('text').text("Torches").attr('x', 1540).attr('y', 745).attr('fill', 'black');


                    
                ////svg.append("line").attr("x1", 390).attr("y1", 340).attr("x2", 360).attr("y2", 360).attr("stroke","gray").attr("stroke-width",3);
                ////svg.append("line").attr("x1", 390).attr("y1", 380).attr("x2", 360).attr("y2", 360).attr("stroke","gray").attr("stroke-width",3);
           
                
                ////svg.append("line").attr("x1", 720).attr("y1", 360).attr("x2", 690).attr("y2", 380).attr("stroke","gray").attr("stroke-width",3);
                ////svg.append("line").attr("x1", 720).attr("y1", 360).attr("x2", 690).attr("y2", 340).attr("stroke","gray").attr("stroke-width",3);


            },
           

            render: function (container, viewParams) {
                var that = this;

                this.viewParams = viewParams;

                var thatContainer = (this.options.container) ? this.options.container : container;
                this.options.container = thatContainer;

                //the screens have a custompath, so it has to be specified in the customPath variable that is
                //then sent to the template loader.
                var customPath = '/app/custom-screens/' + this.template + '/';

                T.render.call(
                    this,
                    this.template,
                    function (tmp) {
                        if (!that.options.i18n) that.options.i18n = {};

                        app.getI18NJed(
                            that,
                            that.template,
                            function (i18nJED) {
                                //storing internationalization data
                                that.options.i18n[that.template] = i18nJED;

                                //loading the view and appeding it to the views's $el.
                                that.$el.html(tmp());

                                that.applyBindings();

                                //start: the view was already loaded an is on a div element, but not appended to the main container
                                //here you can perform anything you want DOM related, by getting the dom element via that.$el.find('#id')
                                //or this.$('#id')

                                that.$el.find('.input-date').datepicker();

                                //appending view to the main container
                                that.append(thatContainer, that.$el);
                                
                                that.drawLayout();                              
                                
                                that.startAutoRefresh();

                            },
                            true,
                            customPath
                        );
                    },
                    customPath
                );
            },

            //Common functions
            append: function (container, el) {
                el = (el != null && el != undefined) ? el : this.$el;

                if (this.options.state == app.view_states.loading
                    || this.options.state == app.view_states.shown) {
                    //appending view to the main container and set state to shown

                    this.options.state = app.view_states.shown;
                    container.append(el);

                    this.options.onappend(this);
                }

                if (this.options.state == app.view_states.hidden) {
                    //append and remain hidden
                    container.append(el);
                }

                if (this.options.state == app.view_states.closed) {
                    //return without appending.
                    return;
                }
            },
            bindViewScopedEvents: function () {
                var that = this;
            },
            unbindViewScopedEvents: function () {

            },
            close: function () {
                this.options.state = app.view_states.closed;
                this.stopAutoRefresh();
                this.closeSubviews();
                this.remove();
                this.unbindViewScopedEvents();
                this.unbind();
            },
            closeSubviews: function () {
                _.each(this.subviews, function (sview) {
                    sview.close();
                });
            },
            show: function () {
                this.options.state = app.view_states.shown;

                this.showSubviews();
                this.bindEvents();
                this.$el.show();
            },
            showSubviews: function () {
                _.each(this.subviews, function (sview) {
                    sview.show();
                });
            },
            hide: function () {
                this.options.state = app.view_states.hidden;

                this.hideSubviews();

                this.$el.hide();
                this.unbind();
                this.stopListening();
            },
            hideSubviews: function () {
                _.each(this.subviews, function (sview) {
                    sview.hide();
                });
            },
            preRender: function () {
                app.models.subnavbar.set("subnavbar", false);
            },
            reRender: function (viewParams) {
                try {
                    this.refresh(viewParams);
                } catch (Error) { }
            },
        });

        // Required, return the module for AMD compliance.
        return Screen;
    });