﻿//SCREEN-BOILERPLATE

//this boilerplate builds screens that are gonna be shown in the <div class='content'> tag of our main HTML.
//do not build app components with this boilerplate, only screens (reports)

define([
  // Application variable, always include it to have access to app methods.
  'app',

  //templates-loader: this loads templates async.
  'js/templates-loader',
    'backgrid',

    'modules/modal',
    'moment',
    'js/jquery.clearsearch/jquery.clearsearch',
    'js/multiselect/virtual-select.min',
],

function (app, T, Backgrid, Modal,moment) {

    var Screen = { Models: {}, Views: {}, Collections: {} }


    Screen.Models.Samples = Backbone.Epoxy.Model.extend({
        defaults: {
            id: null,
            heatName: null,
            sampleTime: null,
            sampleTimeColumn: null,
            hydrogenSampleLocationId: null,
            hydrogen: null,
            sampleLocationName: null,
        },

        parse: function (obj) {
            var result = {
                id: obj.Id,
                heatName: obj.Name,
                sampleTime: obj.SampleTime,
                sampleTimeColumn: obj.SampleTimeColumn,
                hydrogenSampleLocationId: obj.HydrogenSampleLocationId,
                hydrogen: obj.Hydrogen,
                sampleLocationName: obj.SampleLocationName,

            };

            return result;
        }
    })


    Screen.Collections.Items = Backbone.Collection.extend({
        model: Screen.Models.Samples,

        fetch: function (opt) {
            var that = this,
                qp = new Core.Database.QueryParameters();
            qp.Add('@HeatName', 'VARCHAR', opt.params.heatName );
            Core.Json.CallProcedure(
                app.DatabaseNames.MES + '.LAB.GetHydrogenSamples',
                qp,
                {
                    onSuccess: function (resp) {
                        try {
                            if ((resp) && (resp.Table)) {
                                var records = resp.Table,
                                    newColl;
                                newColl = _.map(records, that.model.prototype.parse);
                                that.set(newColl);
                                that.trigger('fetch', that, records);

                            }
                            else {
                                if ((resp) && (resp.Message))
                                    console.error(resp.Message);
                                else
                                    console.error('Server response not valid.');
                            }
                        }
                        catch (error) { console.error((error.stack) ? error.stack : new Error(error).stack); }
                    },
                    Async: true,
                    Secured: true,
                },
                app.ConnectionStrings.app
            );

            return this;
        },
        upsertItem: function (id, props, success, error) {
            var that = this;
            var qp = new QueryParameters();

            for (var q in props) {
                qp.Add(props[q].name, props[q].type, props[q].value);
            }
            Core.Json.CallProcedure(app.DatabaseNames.MES + '.LAB.UpsertHydrogenSample', qp, {
                onSuccess: function (data) {
                    if (data && data.Table && data.Table.length > 0) {
                        var data = data.Table;

                        if (!data[0].Message) {
                            var ids = _.pluck(data, 'Id');

                            if (success != null && _.isFunction(success))
                                success.call(this, that, ids);
                        }
                        else {
                            error.call(this, that, data[0].Message);
                        }
                    } else {
                        if (data.Message)
                            error.call(this, that, data.Message);
                        else
                            error.call(this, that);
                    }
                },
                onError: function (data) {
                    if (error != null && _.isFunction(error))
                        error.call(this, that);
                },
                Async: true,
                Secured: true,
            }, app.ConnectionStrings.app);
        },
        removeItem: function (id, success, error) {
            var model = this.get(id);
            if (model) {
                var that = this;
                var QP = new QueryParameters();
                QP.Add('@id', 'INT', id);
                Core.Json.CallProcedure(app.DatabaseNames.MES + '.LAB.RemoveHydrogenSample', QP, {
                    onSuccess: function (data) {
                        if (data && data.Table && data.Table.length > 0) {
                            var data = data.Table[0];

                            if (data.Id) {
                                if (success != null && _.isFunction(success))
                                    success.call(this, that, data.Id);
                            }
                            else {
                                if (data.Message)
                                    error.call(this, that, data.Message);
                                else
                                    error.call(this, that);
                            }
                        } else {
                            error.call(this, that);
                        }
                    },
                    onError: function (data) {
                        if (error != null && _.isFunction(error))
                            error.call(this, that);
                    },
                    Async: true,
                    Secured: true,
                }, app.ConnectionStrings.app);
            }
        },
    });

    Screen.Models.Main = Backbone.Epoxy.Model.extend({
        defaults: {
            items: null,
            itemId: null,
            search: '',

            hasData: false,
            hasItemData: false,
            hasItemSpecData: false,
            isLoading: true,
            isLoadingItemData: false,
            isLoadingItemSpecData: false,
            heatNames: [],
            heatName:null,

            urlHeatName: null,
            start: new moment().format('YYYY-MM-DD'),
            locations:[],

        },

        initialize: function () {
            this.attributes.items = new Screen.Collections.Items();
            //this.locations = this.fetchlocations();
        },

        fetchCatalogs: function () {
            var that = this,
                qp = new Core.Database.QueryParameters();           
            qp.Add('@heatName', 'VARCHAR', that.get('heatName'));
            Core.Json.CallProcedure(
                app.DatabaseNames.MES + '.LAB.GetHydrogenSamplesCatalogs',
                qp,
                {
                    onSuccess: function (resp) {
                        try {
                            if ((resp) && (resp.Table)) {
                                that.set({
                                    locations: resp.Table,
                                    heatName: resp.Table1 ? resp.Table1[0]?.HeatName : null,
                                });
                                
                            }
                            else {
                                if ((resp) && (resp.Message))
                                    console.error(resp.Message);
                                else
                                    console.error('Server response not valid.');
                            }
                        }
                        catch (error) { console.error((error.stack) ? error.stack : new Error(error).stack); }
                    },
                    Async: false,
                    Secured: true,
                },
                app.ConnectionStrings.app
            );
        },

        updateItem: function (params) {
            var that = this;
            var qp = new QueryParameters();


            qp.Add('@Id', 'INT', parseInt(params.id));
            qp.Add('@SampleTime', 'DATETIME', params.sampleTime);
            if (params.id > 0) {
                Core.Json.CallProcedure(
                app.DatabaseNames.MES + '.LAB.UpsertHydrogenSample',
                qp,
                {
                    onSuccess: function (resp) {
                        try {
                            that.trigger('sampleTime-updated');

                            if ((resp) && (resp.Message))
                                console.error(resp.Message);
                        }
                        catch (error) { console.error((error.stack) ? error.stack : new Error(error).stack); }
                    },
                    Async: true,
                    Secured: true,
                },
                app.ConnectionStrings.app
                );
            }
        },
   
    });

    //the generate id method is called everytime a view is going to be shown by the router and returns and id that
    //is used by the router to store in cache (if it is cacheable) and to know the current shown view.
    //this is useful in case your view is reusable, and displays different data depending on url parameters 
    //(such as a catalog view, or a report that doesnt change in terms of UI but it does change in terms of data)
    //so you can always use the same view on the router but the cache can tell which view is which by using differents ids.
    Screen.generateID = function (viewParams) {
        try {
            //if the viewparams change the view id, then evaluate the viewparams here
            //and return the appropiate id.
            return 'hydrogen-samples';
        } catch (Error) { }
    }

    Screen.Views.Main = Backbone.Epoxy.View.extend({
        template: 'hydrogen-samples',
        id: 'hydrogen-samples',
        title: 'Hydrogen Samples',
        //default not cacheable, change this if you want the view to be cacheable
        // if the view is set as cacheable should also have a refresh method to reset the view without erasing the DOM.
        isCacheable: false,
        events: function () {
            return {
            };
        },
        autoRefresh: null,
        subviews: null,
        viewParams: null,

        item: null,
        //specsColl: null,

        initialize: function () {
            this.options.state = app.view_states.loading;
            this.options.onappend = (_.isFunction(this.options.onappend)) ? this.options.onappend : function () { };

            var that = this;

            this.autoRefresh = {
                enabled: null
                , toid: null
                , every: 5 * 1000
            };

            this.model = new Screen.Models.Main();
            this.bus = _.extend({}, Backbone.Events);
            this.bus.on("modalAcceptBtn", this.onModalAcceptBtn, this);
            this.bus.on("heatNameChanged", this.onHeatNameChanged, this);
            this.subviews = {
                subnavbarControls: new Screen.Views.SubnavBarControls({
                    model: this.model,
                    bindingSources: this.bindingSources,
                    parent: this,
                    container: app.views.subnavbar.getSectionContainer(1, 12),
                    bus: this.bus,
                    events: function () {
                        return {
                            'click .add-item': _.bind(that.addNewBtn_click, that),
                            //'click #refreshBtn': _.bind(that.refreshBtn_click, that),
                        };
                    },
                }),
            };


            this.bindEvents();
        },
        onHeatNameChanged: function (newHeatName) {
            this.model.set({ heatName: newHeatName });
            this._refresh();
            this.UpdateURL();
        },
        onModalAcceptBtn: function (model,newDatetime) {
            this.model.updateItem({
                id: model.id,
                sampleTime: new moment(model.dateModal, 'MM/DD/YYYY').format('YYYY-MM-DD') + ' ' + new moment(model.timeModal, 'HH:mm:ss').format('HH:mm:ss'),
            });
            if (model.id === -1) {
                var timestamp = newDatetime.datetime;
                var coll = this.model.get('items');
                var model = coll.get(-1);  // Get model with id = -1
                model.set({
                    sampleTime: new moment(timestamp, 'YYYY-MM-DD HH:mm:ss').format('YYYY-MM-DD HH:mm:ss'),
                    sampleTimeColumn: new moment(timestamp, 'YYYY-MM-DD HH:mm:ss').format('MM/DD/YY HH:mm:ss'),
                })
            }

        },

        render: function (container, viewParams) {
            var that = this;

            this.viewParams = viewParams;

            var thatContainer = (this.options.container) ? this.options.container : container;
            this.options.container = thatContainer;

            //the screens have a custompath, so it has to be specified in the customPath variable that is
            //then sent to the template loader.
            var customPath = '/app/custom-screens/' + this.template + '/';

            T.render.call(
                this,
                this.template,
                function (tmp) {
                    if (!that.options.i18n) that.options.i18n = {};

                    app.getI18NJed(
                        that,
                        that.template,
                        function (i18nJED) {
                            //storing internationalization data
                            that.options.i18n[that.template] = i18nJED;

                            //loading the view and appeding it to the views's $el.
                            that.$el.html(tmp());
                            that.applyBindings();

                            //start: the view was already loaded an is on a div element, but not appended to the main container
                            //here you can perform anything you want DOM related, by getting the dom element via that.$el.find('#id')
                            //or this.$('#id')

                            that.subviews.subnavbarControls.render();

                            var grid = that.options.itemsGrid = new Backgrid.Grid({
                                className: 'backgrid table table-hover',
                                columns: [
                                    {
                                        name: 'heatName',
                                        label: 'Heat Name',
                                        editable: false,
                                        sortable: false,
                                        cell: Backgrid.StringCell.extend({
                                            className: 'string-cell align-center-cell',
                                        }),
                                    },
                                    {
                                        name: 'sampleTimeColumn',
                                        label: 'Timestamp',
                                        editable: false,
                                        sortable: false,
                                        cell: Backgrid.Cell.extend({
                                            template: Handlebars.compile(that.$el.find('#datetime_picker_hydrogen_samples').html()),
                                            className: 'actions-cell',
                                            events: {
                                                'click': 'cellActionClick'
                                            },

                                            initialize: function () {
                                                Backgrid.Cell.prototype.initialize.apply(this, arguments);
                                            },
                                            render: function () {
                                                this.$el.html(this.template());
                                                var rowModel = this.model.toJSON();
                                                var SampleTimeColumn = rowModel.sampleTimeColumn ? rowModel.sampleTimeColumn : now;
                                            
                                                this.$(".datetime-current-value").text(new moment(SampleTimeColumn).format('MM/DD/YY HH:mm:ss'));
                                                this.$el.find('[data-toggle="tooltip"]').tooltip();
                                                this.delegateEvents();
                                                return this;
                                            },
                                            cellActionClick: function (e) {
                                                try {
                                                    var target = $(e.target);
                                                    that.actionOnRowModalDatetime(this.model);
                                                }
                                                catch (error) { console.error((error.stack) ? error.stack : new Error(error).stack); }
                                            },
                                        }),
                                    },
                                    {
                                        name: 'hydrogenSampleLocationId',
                                        label: app.translate(that, 'location_col'),
                                        editable: true,
                                        sortable: false,
                                        cell: Backgrid.SelectCell.extend({
                                            optionValues: function () {
                                                return that.locations;
                                            },
                                            className: 'string-cell align-center-cell click-to-edit',
                                        }) 
                                    },
                                    {
                                        name: 'hydrogen',
                                        label: app.translate(that, 'hydrogen_col'),
                                        editable: true,
                                        sortable: false,
                                        cell: Backgrid.NumberCell.extend({
                                            orderSeparator: '',
                                            className: 'string-cell align-center-cell click-to-edit',
                                            enterEditMode: function () {
                                                // Call the parent's enterEditMode function
                                                Backgrid.NumberCell.prototype.enterEditMode.apply(this, arguments);

                                                // Get the input element and select the text
                                                var inputEl = this.$el.find('input');
                                                if (inputEl.length) {
                                                    inputEl[0].select();
                                                }
                                            }
                                        }),
                                    },
                                    {
                                        name: 'actions',
                                        label: '',
                                        editable: false,
                                        sortable: false,
                                        cell: Backgrid.Cell.extend({
                                           template: Handlebars.compile(that.$el.find('#actions_cell_template_hydrogen_samples').html()),
                                            className: 'actions-cell',
                                            events: {
                                                'click .btn-cell-action': 'cellActionClick'
                                            },

                                            initialize: function () {
                                                Backgrid.Cell.prototype.initialize.apply(this, arguments);

                                                this.bindEvents();
                                            },
                                            render: function () {
                                                this.$el.html(this.template());

                                                this.$el.find('[data-toggle="tooltip"]').tooltip();

                                                this.checkMode();
                                                this.delegateEvents();
                                                return this;
                                            },
                                            bindEvents: function () {
                                                this.listenTo(this.model, 'change:isNew', this.checkMode);
                                            },

                                            checkMode: function () {
                                                var newRow = this.model.get('isNew');
                                                if (newRow) this.setNewRowMode(true);
                                                else this.setNewRowMode(false);
                                            },
                                            setNewRowMode: function (val) {
                                                var btnRemove = this.$el.find('.btn-remove');
                                                var btnSave = this.$el.find('.btn-save');
                                                var btnDiscard = this.$el.find('.btn-discard');
                                                if (val) {
                                                    btnRemove.addClass('hide');
                                                    btnSave.removeClass('hide');
                                                    btnDiscard.removeClass('hide');
                                                } else {
                                                    btnRemove.removeClass('hide');
                                                    btnSave.addClass('hide');
                                                    btnDiscard.addClass('hide');
                                                }
                                            },

                                            cellActionClick: function (e) {
                                                try {
                                                    var target = $(e.target);
                                                    var actionData = target.closest('[data-cell-action]').data('cell-action');
                                                    if (actionData) {
                                                        that.actionOnRow(this.model, actionData);
                                                    }
                                                }
                                                catch (error) { console.error((error.stack) ? error.stack : new Error(error).stack); }
                                            },
                                        }),
                                    },
                                ],
                                collection: that.model.get('items'),
                            });
                            that.$el.find('.items-grid-container').append(grid.render().el);

                            if (viewParams && viewParams.heatName) {
                                that.model.set(viewParams);
                            }
                            //appending view to the main container
                            that.append(thatContainer, that.$el);


                            that.fetchCatalogs();
                            //Call first refresh.
                            //that.startAutoRefresh();
                            that._refresh();
                        },
                        true,
                        customPath
                    );
                },
                customPath
            );
        },
        fetchCatalogs: function () {
            var that = this;
            this.model.fetchCatalogs();

            var array = [];
            _.each(this.model.get('locations'), function (obj, i) {
                array[i] = [obj.Name, obj.Id];
            });
            this.locations = array;


            //var attrs = that.model.toJSON();
            //var heatNames = attrs.heatNames;
            //var heatfound = _.where(heatNames, { label: attrs.heatName});
            //if (heatfound && heatfound[0] && heatfound[0].value) {
            //    var currentHeatId = heatfound[0].value;
            //    that.model.set({ heatId: currentHeatId });
            //}

        },

        actionOnRowModalDatetime: function (model) {
            var params = this.model.toJSON();
            var modal = new Screen.Views.DatetimeModal({
                parentModel: params,
                row: model,
                bus: this.bus,
            });
            modal.show();
        },
        //refreshBtn_click: function () {
        //    this.model.set({
        //        hasData: false,
        //        isLoading: true,
        //    });
        //    this._refresh();
        //},
        bindEvents: function () {
            this.listenTo(this.model, 'change:search', this.model_change_pickers)
                .listenTo(this.model, 'change:heatName', this.model_change_heatName)
                .listenTo(this.model.get('items'), 'change', this.collection_changed)
                .listenTo(this.model.get('items'), 'fetch', this.collection_fetch)
                .listenTo(this.model, 'sampleTime-updated', this.sampleTime_updated);

        },
        sampleTime_updated: function () {
            this._refresh();
        },
        model_change_heatName: function () {
            this.bus.trigger("heatNameChangedSubnavbar", this.model.get('heatName'));

            this._refresh();
            this.UpdateURL();
        },


        UpdateURL: function () {
            try {
                var params = this.model.toJSON();
                app.router.navigate('!/hydrogen-samples/' + params.heatName, { trigger: false });
            }
            catch (e) { console.error((e.stack) ? e.stack : new Error(e).stack); }
        },

        _refresh: function (opt) {
            if (this.autoRefresh.toid != null) {
                clearTimeout(this.autoRefresh.toid);
                this.autoRefresh.toid = null;
            }

            this.refreshItemsColl(opt);

            if (this.autoRefresh.enabled == true) {
                var that = this;

                this.autoRefresh.toid = setTimeout(
                    function () { that._refresh(); },
                    this.autoRefresh.every
                );
            }
        },
        refresh: function (viewParams) {
            if (viewParams.sectionParam1)
                viewParams.sectionParam1 = parseInt(viewParams.sectionParam1, 10);
            else
                viewParams.sectionParam1 = Screen.Models.Main.prototype.defaults.itemId;

        },
        refreshItemsColl: function (options) {
            var that = this,
                itemsColl = this.model.get('items'),
                opt = _.extend({}, options, { params: {}, refresh: true, });

            if (opt.reset == true)
                this.model.set('isLoading', true);

            var that = this,
                modelAttrs = this.model.toJSON();
            itemsColl.fetch(_.extend(
                opt,
                {
                    params: _.extend(
                        modelAttrs,
                        opt.params,
                        {
                            refresh: opt.refresh,
                            reset: opt.reset,
                        }
                    ),
                }
            ));
        },
        addNew: function () {
            this.model.get('items').unshift({
                id: -1,
                isNew: true,
                heatName: this.model.get('heatName'),
                sampleTime: new moment().format('YYYY-MM-DD HH:mm:ss'),
                sampleTimeColumn: new moment().format('YYYY-MM-DD HH:mm:ss'),
                hydrogenSampleLocationId: 1,
                hydrogen:0,
                    
            });
        },
        discardRow: function (m) {
            //to discard just remove the model from the collection.
            m.collection.remove(m);
        },
        removeRow: function (model) {
            var that = this;
            model.collection.removeItem(
                model.get('id')
                , function (coll, data) {
                    that._refresh();
                }
                , function (coll, msg) {
                    app.views.topMessages.showMessage('Sample removed', { stay: 3000, });
                    that._refresh();
                }
            );
        },
        saveRow: function (m) {
            var that = this;
            m.collection.upsertItem(null, [

                { name: 'id', type: 'INT', value: m.get('id') === -1 ? null : m.get('id') },
                    { name: 'heatName', type: 'VARCHAR', value: this.model.get('heatName') },
                {
                    name: 'hydrogenSampleLocationId', type: 'INT', value: m.get('hydrogenSampleLocationId')  ? parseInt(m.get('hydrogenSampleLocationId')) : null,
                },
                    { name: 'sampleTime', type: 'DATETIME', value: m.get('sampleTime') }, // m.get('sampleTime')
                    { name: 'hydrogen', type: 'FLOAT', value: m.get('hydrogen') },
            ], function (ref, ids) {
                m.set({ id: ids[0], isNew: false }, { avoidSync: true });
            }, function (coll, msg) {
              // app.views.topMessages.showMessage(app.translate(app, msg), { stay: 10000, });
                that._refresh();
            });
        },
        append: function (container, el) {
            el = (el != null && el != undefined) ? el : this.$el;

            if (this.options.state == app.view_states.loading
                || this.options.state == app.view_states.shown) {
                //appending view to the main container and set state to shown

                this.options.state = app.view_states.shown;
                container.append(el);

                this.options.onappend(this);
            }

            if (this.options.state == app.view_states.hidden) {
                //append and remain hidden
                container.append(el);
            }

            if (this.options.state == app.view_states.closed) {
                //return without appending.
                return;
            }
        },
        startAutoRefresh: function () {
            try {
                if (this.autoRefresh.enabled !== true) {
                    var that = this;

                    if (this.autoRefresh.toid != null) {
                        clearTimeout(this.autoRefresh.toid);
                        this.autoRefresh.toid = null;
                    }

                    this.autoRefresh.enabled = true;

                    //use a timeout to execute the first refresh to return the handle to the start function caller.
                    //So when the caller finish it will do the first refresh.
                    this.autoRefresh.toid = setTimeout(
                        function () { that._refresh(); },
                        1
                    );
                }
            } catch (error) { console.error((error.stack) ? error.stack : new Error(error).stack); }
        },
        stopAutoRefresh: function () {
            if (this.autoRefresh.toid != null) {
                clearTimeout(this.autoRefresh.toid);
                this.autoRefresh.toid = null;
            }
            this.autoRefresh.enabled = false;
        },
        bindViewScopedEvents: function () {
        },
        unbindViewScopedEvents: function () {
        },
        close: function () {
            this.options.state = app.view_states.closed;

            this.stopAutoRefresh();
            this.closeSubviews();
            this.remove();
            this.unbindViewScopedEvents();
            this.unbind();
        },
        closeSubviews: function () {
            _.each(this.subviews, function (sview) {
                sview.close();
            });
        },
        show: function () {
            this.options.state = app.view_states.shown;

            this.showSubviews();
            this.bindEvents();
            this.$el.show();
        },
        showSubviews: function () {
            _.each(this.subviews, function (sview) {
                sview.show();
            });
        },
        hide: function () {
            this.options.state = app.view_states.hidden;

            this.hideSubviews();
            this.stopAutoRefresh();

            this.$el.hide();
            this.unbind();
            this.stopListening();
        },
        hideSubviews: function () {
            _.each(this.subviews, function (sview) {
                sview.hide();
            });
        },
        preRender: function () {
            app.models.subnavbar.setAll(false);
            app.models.subnavbar.set('sections', '12');
            app.models.subnavbar.set('subnavbar', true);
        },
        reRender: function () {
            this.startAutoRefresh();
        },

        actionOnRow: function (model, action) {
            try {
                switch (action.toUpperCase()) {
                    case 'DELETE':
                        var that = this,
                            modal = new Modal.Views.Main({
                                focusOk: false,
                                focusSelector: '#btn-cancel',
                                title: app.translate([this, app], "delete_item_modal_confirm_title"),
                                message: app.translate([this, app], "delete_item_modal_confirm_message"),
                                buttons_type: "CONTINUE-CANCEL",
                            });

                        this.listenToOnce(modal, "continue", function (modal) {
                            try {
                                that.removeRow(model);
                            }
                            catch (error) { console.error((error.stack) ? error.stack : new Error(error).stack); }
                        });

                        modal.show();
                        break;
                    case 'SAVE':
                        this.saveRow(model);
                        break;
                    case 'DISCARD':
                        this.discardRow(model);
                        break;
                }
            }
            catch (error) { console.error((error.stack) ? error.stack : new Error(error).stack); }
        },
        addNewBtn_click: function (e) {
            try {
                this.model.set({ hasData: true, id: null, hydrogenSampleLocationId:1 });
                this.addNew();
            }
            catch (error) { console.error((error.stack) ? error.stack : new Error(error).stack); }
        },
        collection_changed: function (m, b, c) {
            var that = this;
            var fromFetch = (b && b.from == 'fetch') ? true : false;
            var avoidSync = (b && b.avoidSync) ? b.avoidSync : false;
            var isNewRow = m.get('isNew');
            if (!fromFetch && !isNewRow && !avoidSync) {
                m.collection.upsertItem(m.get('id'), [
                { name: 'id', type: 'INT', value: m.get('id') },
                { name: 'heatName', type: 'VARCHAR', value: m.get('heatName') },
                { name: 'hydrogenSampleLocationId', type: 'INT', value: parseInt(m.get('hydrogenSampleLocationId')) },
                { name: 'sampleTime', type: 'DATETIME', value: null }, 
                { name: 'hydrogen', type: 'FLOAT', value: m.get('hydrogen') },
                ], function (ref, ids) {
                }, function (coll, msg) {
                   // app.views.topMessages.showMessage(app.translate(app, msg), { stay: 10000, });
                    that._refresh();
                });
            }
        },
        collection_fetch: function (coll, resp) {
            try {
                this.model.set({
                    hasData: (this.model.get('items').length > 0),
                    isLoading: false,
                });
            }
            catch (error) { console.error((error.stack) ? error.stack : new Error(error).stack); }
        },
        item_fetch: function (model, resp) {
            try {
                this.model.set({
                    isLoadingItemData: false,
                    hasItemData: this.item.get('id'),
                });
            }
            catch (error) { console.error((error.stack) ? error.stack : new Error(error).stack); }
        },
        model_change_pickers: function (model, value, opt) {
            try {
                var params = this.model.toJSON();
                this.refreshItemsColl({
                    reset: true,
                    params: _.extend(
                        {},
                        params,
                        {}
                    ),
                });
            }
            catch (error) { console.error((error.stack) ? error.stack : new Error(error).stack); }
        },
      
    });

    Screen.Models.DatetimeModal = Backbone.Epoxy.Model.extend({
        defaults: {
            errorMsg: '',
            processing: false,
            id: null,
            dateModal: new moment().format('MM/DD/YYYY'),
            timeModal: new moment().format('HH:mm:ss'),
            title: '',
        },

    });


    Screen.Views.DatetimeModal = Backbone.Epoxy.View.extend({
        template: "hydrogen-samples",
        id: "datetime-modal",
        className: "modal hydrogen-samples-delays hide fade",
        bindings: "data-bind",
        isCacheable: true,
        events: function () {
            return {
                "click #acceptBtn": this.acceptBtn_click,
                "click #cancelBtn": this.cancelBtn_click,
                "submit form": this.form_submit,
                "keypress": this.modal_keypress,
                "show.bs.modal": this.modal_show,
                "shown.bs.modal": this.modal_shown,
                "hidden.bs.modal": this.modal_hidden,
            };
        },

        container: null,
        disposed: false,
        isRendered: false,
        preventDispose: false,
        visible: false,
        sampleLocationName: '',
        hydrogen: '',

        initialize: function (options) {
            _.extend(this, options);
            if (!this.model) {
                this.model = new Screen.Models.DatetimeModal();
            }

            var currentHeatName = options.parentModel.heatName;
            this.model.set({
                id: options.row.attributes.id,
                dateModal: new moment(options.row.attributes.sampleTime,'YYYY-MM-DD HH:mm:ss').format('MM/DD/YYYY'),
                timeModal: new moment(options.row.attributes.sampleTime, 'YYYY-MM-DD HH:mm:ss').format('HH:mm:ss'),
                title: 'Edit Datetime - Heat: ' + currentHeatName,
                sampleLocationName: options.row.attributes.sampleLocationName ? options.row.attributes.sampleLocationName :'',
                hydrogen: options.row.attributes.hydrogen ? options.row.attributes.hydrogen :'',


            });
            this.bus = options.bus;

            this.bindEvents();

            return this;
        },

        hide: function (preventDispose) {
            this.preventDispose = (preventDispose);

            this.$el.modal('hide');
        },
        render: function (container) {
            if (container)
                this.container = container;

            var that = this;
            var customPath = '/app/custom-screens/' + this.template + '/';
            T.render.call(this, this.template, function (tmp) {
                if (!that.i18n) that.i18n = {};
                app.getI18NJed(that, that.template, function (i18nJED) {
                    that.i18n[that.template] = i18nJED;
                    that.$el.html(tmp(that.model.toJSON()));
                    that.applyBindings();

                    that.isRendered = true;

                    that.$el.find('#dateModal').datepicker();
                    that.$el.find('#timeModal').timepicker({
                        showMeridian: false,
                        secondStep: 1,
                        minuteStep: 1,
                        showSeconds: true,
                    });


                    that.trigger("render");
                   


                }, true, customPath);

            }, customPath, "datetime_picker_modal");

        },
        show: function () {
            if (!this.isRendered) {
                this.render();
            }
            else {
                this.$el.modal({
                    keyboard: true,
                    backdrop: 'both',
                });
            }

            return this;
        },

        bindEvents: function () {
            this.listenToOnce(this, "render", this.view_render);
        },

        close: function () {
            if (this.disposed == false) {
                if (this.visible == true) {
                    this.hide();
                }
                else {
                    this.trigger('close');

                    this.remove();
                    this.unbind();

                    this.disposed = true;
                }
            }
        },
        preRender: function () {
            app.models.subnavbar.set("dateControl", false);
        },
        reRender: function () {
        },

        acceptBtn_click: function (e) {
            try {
                var that = this,
                    attrs = that.row.attributes,
                    modelAttrs = this.model.toJSON();
                var params = {
                    datetime: new moment(modelAttrs.dateModal, 'MM/DD/YYYY').format('YYYY-MM-DD') + ' ' + new moment(modelAttrs.timeModal, 'HH:mm:ss').format('HH:mm:ss'),
                }

                this.bus.trigger("modalAcceptBtn", modelAttrs, params);

                this.close();
            }
            catch (e) { console.error((e.stack) ? e.stack : new Error(e).stack); }
        },
        form_submit: function (e) {
            try {
                e.preventDefault();
            }
            catch (e) { console.error((e.stack) ? e.stack : new Error(e).stack); }
        },
        modal_hidden: function (e) {
            try {
                this.visible = false;

                if (!this.preventDispose)
                    this.close();
                else
                    this.preventDispose = false;
            }
            catch (e) { console.error((e.stack) ? e.stack : new Error(e).stack); }
        },
        modal_show: function (e) {
            try {
                this.visible = true;
            }
            catch (e) { console.error((e.stack) ? e.stack : new Error(e).stack); }
        },
        modal_shown: function (e) {
            try {
                this.$el.find(".autofocus").focus();
            }
            catch (e) { console.error((e.stack) ? e.stack : new Error(e).stack); }
        },
        view_render: function () {
            try {
                this.show();
            }
            catch (e) { console.error((e.stack) ? e.stack : new Error(e).stack); }
        },

    });

    //subview for the subnavbar controls
    Screen.Views.SubnavBarControls = Backbone.Epoxy.View.extend({
        id: 'hydrogen-samples-subnavbar-controls',
        title: '',
        template: 'hydrogen-samples',
        heatNames: [],
        heatName: null,
        processId: null,
        firstRender: true,
        initialize: function () {
            this.options.state = app.view_states.loading;
            this.options.onappend = (_.isFunction(this.options.onappend)) ? this.options.onappend : function () { };
            this.bindEvents();
            var parentModel = this.options.model.toJSON();
            this.bus = this.options.bus;

            this.bus.on("heatNameChangedSubnavbar", this.onHeatNameChanged, this);
        },

        onHeatNameChanged: function (heatName) {
            this.heatName = heatName;
            this.heatNames = [{
                label: heatName,
                processId: null,
                value: heatName,
            }];
            this.fetchHeatNamesCatalog();
        },
        fetchHeatNamesCatalog: function () {
            var that = this;
            var qp = new Core.Database.QueryParameters();
            qp.Add('@Asset', 'CHAR(3)', 'CAS');
            qp.Add('@SelectedHeatName', 'VARCHAR(10)', this.heatName);
            qp.Add('@HeatName', 'VARCHAR(10)', this.heatName);
            Core.Json.CallProcedure(
                app.DatabaseNames.MES + '.MES.GetAutocompleteHeats',
                qp,
                {
                    onSuccess: function (resp) {
                        try {
                            if (resp && resp.Table) {
                                that.heatNames = resp.Table;
                                that.heatName = resp.Table[0] && resp.Table[0].value ? resp.Table[0].value : '';
                                that.processId = resp.Table[0] && resp.Table[0].processId ? resp.Table[0].processId : null;

                                that.trigger('fetch-catalogs');
                            }
                            else {
                                if ((resp) && (resp.Message)) {
                                    app.views.topMessages.showMessage(resp.Message, { stay: 3000, });
                                    console.error(resp.Message);
                                    that.set({
                                        hasData_process: false,
                                        isLoading_process: false,


                                    });
                                }
                                else {
                                    app.views.topMessages.showMessage("Server response not valid.", { stay: 3000, });
                                    console.error("Server response not valid.");
                                    that.set({
                                        hasData_process: false,
                                        isLoading_process: false,
                                    });
                                }

                            }


                        }
                        catch (error) { console.error((error.stack) ? error.stack : new Error(error).stack); }
                    },
                    Secured: true,
                    Async: false,
                },
                app.ConnectionStrings.app
            );
        },

        onSampleSelectServerSearch: function (searchValue, virtualSelect) {
            var qp = new Core.Database.QueryParameters();
            qp.Add('@HeatName', 'VARCHAR(10)', searchValue);
            qp.Add('@SelectedHeatName', 'VARCHAR(10)', this.selectedValues[0]);
            qp.Add('@Asset', 'CHAR(3)', 'CAS');

            Core.Json.CallProcedure(
                app.DatabaseNames.MES + '.MES.GetAutocompleteHeats',
                qp,
                {
                    onSuccess: function (resp) {
                        try {
                            virtualSelect.setServerOptions(resp.Table);

                        }
                        catch (error) { console.error((error.stack) ? error.stack : new Error(error).stack); }
                    },
                    Secured: true,
                    Async: false,
                },
                app.ConnectionStrings.app
            );
        },
        fetchNavigateHeat: function (params) {
            var qp = new Core.Database.QueryParameters();
            var that = this;
            qp.Add('@heatName', 'VARCHAR(10)', that.get('heatName'));
            qp.Add('@direction', 'SMALLINT', params.direction);
            qp.Add('@Asset', 'CHAR(3)', 'EAF');

            Core.Json.CallProcedure(
                app.DatabaseNames.MES + '.MES.GetNavigatedHeat',
                qp,
                {
                    onSuccess: function (resp) {
                        try {
                            if (resp && resp.Table && resp.Table[0] && resp.Table[0].HeatName && resp.Table[0].HeatName !== '') {
                                that.set({
                                    heatName: resp.Table[0].HeatName,
                                    heatNames: [{
                                        value: resp.Table[0].HeatName,
                                        label: resp.Table[0].HeatName
                                    }],
                                });
                                that.trigger('heat-name-changed');
                            }
                            else {
                                if ((resp) && (resp.Message)) {
                                    app.views.topMessages.showMessage(resp.Message, { stay: 3000, });
                                    console.error(resp.Message);
                                    that.set({
                                        hasData_process: false,
                                        isLoading_process: false,
                                    });
                                }
                                else {
                                    app.views.topMessages.showMessage("Server response not valid.", { stay: 3000, });
                                    console.error("Server response not valid.");
                                    that.set({
                                        hasData_process: false,
                                        isLoading_process: false,
                                    });
                                }

                            }


                        }
                        catch (error) { console.error((error.stack) ? error.stack : new Error(error).stack); }
                    },
                    Secured: true,
                    Async: false,
                },
                app.ConnectionStrings.app
            );
        },

        renderMultipicker: function () {
            var that = this;
            var heatNamesPicker = new VirtualSelect.init({
                ele: '#heat-picker-multi-select',
                options: that.heatNames,
                multiple: false,
                search: true,
                placeholder: 'Select Heat',
                hasOptionDescription: false,
                showSelectedOptionsFirst: true,
                hideClearButton: true,
                onServerSearch: that.onSampleSelectServerSearch,
            });
            var heat = that.heatName;
            if (!document.querySelector('#heat-picker-multi-select')) return;
            document.querySelector('#heat-picker-multi-select').setOptions(that.heatNames);
            document.querySelector('#heat-picker-multi-select').setValue(heat);
            document.querySelector('#heat-picker-multi-select').addEventListener('change', function () {
                $('.vscomp-search-clear').click();
                if (this.value === that.heatName) {
                    return 0;
                }
                else {
                    var newHeatName = this.value;
                    if (newHeatName && newHeatName != '') {
                        that.heatName = newHeatName    
                        that.bus.trigger("heatNameChanged", newHeatName);
                    }
                }
            });

        },


        render: function (container, onComplete) {
            var that = this;
            var thatContainer = (container) ? container : (this.options.container) ? this.options.container : null;
            var onViewComplete = (onComplete) ? onComplete : function () { };

            //the screens have a custompath, so it has to be specified in the customPath variable that is
            //then sent to the template loader.
            var customPath = '/app/custom-screens/hydrogen-samples/';

            T.render.call(this, this.template, function (tmp) {
                if (!that.options.i18n) that.options.i18n = {};
                app.getI18NJed(that, that.template, function (i18nJED) {
                    //storing internationalization data
                    that.options.i18n[that.template] = i18nJED;

                    var ctx = {
                        editable: (($.inArray('AdminUserRole', app.models.user.get('roles')) != -1
                            || $.inArray('SupervisorUserRole', app.models.user.get('roles')) != -1) ? true : false),
                    };

                    //loading the view and appeding it to the views's $el.
                    that.$el.html(tmp(
                        _.extend({}, ctx, (that.model) ? that.model.toJSON() : {})
                    ));

                    //that.$el.find('.clear-search').clearSearch();

                    that.applyBindings();
                    that.append(thatContainer, that.$el);

                    if (that.heatName && that.heatNames) {
                        that.renderMultipicker();
                        that.firstRender = false;
                    }
                }, true, customPath);
            }, customPath, 'subnavbar_controls_hydrogen_samples');

        },

        bindEvents: function () {
            //this function should be in every view that uses listenTo anywhere
            //all the model bindings or view-model binding should be here, to manage
            //the show/hide view easily
            this.listenTo(this,'fetch-catalogs', this.fetchCatalogs);
        },
        fetchCatalogs: function () {
            if (this.firstRender) {
                this.renderMultipicker();
                this.firstRender = false;
            }
        },
        append: function (container, el) {
            el = (el != null && el != undefined) ? el : this.$el;

            if (this.options.state == app.view_states.loading
                || this.options.state == app.view_states.shown) {
                //appending view to the main container and set state to shown

                this.options.state = app.view_states.shown;
                container.append(el);

                this.options.onappend(this);
            }

            if (this.options.state == app.view_states.hidden) {
                //append and remain hidden
                container.append(el);
            }

            if (this.options.state == app.view_states.closed) {
                //return without appending.
                return;
            }
        },
        close: function () {
            this.options.state = app.view_states.closed;

            this.remove();
            this.unbind();
        },
        show: function () {
            this.options.state = app.view_states.shown;

            this.bindEvents();
            this.$el.show();
        },
        hide: function () {
            this.options.state = app.view_states.hidden;

            this.$el.hide();
            this.unbind();
            this.stopListening();
        },
    });

    // Required, return the module for AMD compliance.
    return Screen;

});
