USE [IHBoxSystem]
GO


delete from frontend.menu where  name = 'Ladle Wall'

delete from frontend.routes where ModuleName='ladle-wall'


INSERT INTO [FrontEnd].[Routes]
           ([Route]
           ,[ModuleName]
           ,[ModulePath]
           ,[RequiredRole]
       )
     VALUES
           (
		   '!/ladle-wall(/:ladleId)'
           , 'ladle-wall'
		   , 'custom-screens/ladle-wall/'
           , 'ladlewall_readWrite'       
		   )



INSERT INTO [FrontEnd].[Menu]
           ([Parent]
           ,[Name]
           ,[RouteID]
           ,[SortOrder]
           ,[Enabled]
           ,[Visible]
           ,[RequiredRole]
           ,[Group]
          )
     VALUES
           (
		   (select top 1 Id from [frontend].[Menu] where [Name]='Ladles')
		   ,'Ladle Wall'
           ,@@IDENTITY
           ,1
           ,1
           ,1
           ,'ladlewall_readWrite'
           ,NULL
           )
GO



USE IHBoxSystem

IF DATABASE_PRINCIPAL_ID('ladlewall_readWrite') IS NULL
BEGIN
	CREATE ROLE ladlewall_readWrite;
end
go


insert into [Security].[Modules] (Code,[Name])
values ('ladle-wall' ,'Ladle Wall')

insert into [Security].[ModuleActions] (ModuleID,Code,[Name],[Role])
values (@@IDENTITY,'readWrite','Read/Write','ladlewall_readWrite')


EXEC sp_addrolemember 'ladlewall_readWrite', 'admin'

go

EXEC sp_dropextendedproperty @level0type = N'USER' ,@level0name = [ladlewall_readWrite] ,@name = N'securedsp-LAD.ChangeLadleEquipment' 
EXEC sp_dropextendedproperty @level0type = N'USER' ,@level0name = [ladlewall_readWrite] ,@name = N'securedsp-LAD.DrainLadle'
EXEC sp_dropextendedproperty @level0type = N'USER' ,@level0name = [ladlewall_readWrite] ,@name = N'securedsp-LAD.GetLadleEquipmentHistory' 
EXEC sp_dropextendedproperty @level0type = N'USER' ,@level0name = [ladlewall_readWrite] ,@name = N'securedsp-LAD.GetCurrentEquipment' 
EXEC sp_dropextendedproperty @level0type = N'USER' ,@level0name = [ladlewall_readWrite] ,@name = N'securedsp-LAD.GetLadles' 
EXEC sp_dropextendedproperty @level0type = N'USER' ,@level0name = [ladlewall_readWrite] ,@name = N'securedsp-LAD.OverrideHeatCounters' 
EXEC sp_dropextendedproperty @level0type = N'USER' ,@level0name = [ladlewall_readWrite] ,@name = N'securedsp-LAD.GetEquipmentsPerType' 


EXEC sp_addextendedproperty  @level0type = N'USER' ,@level0name = [ladlewall_readWrite] ,@name = N'securedsp-LAD.ChangeLadleEquipment'		  ,@value =  N'SendCurrentUser=TRUE'  
EXEC sp_addextendedproperty  @level0type = N'USER' ,@level0name = [ladlewall_readWrite] ,@name = N'securedsp-LAD.DrainLadle'				  ,@value =  N'SendCurrentUser=TRUE'  
EXEC sp_addextendedproperty  @level0type = N'USER' ,@level0name = [ladlewall_readWrite] ,@name = N'securedsp-LAD.GetLadleEquipmentHistory'   ,@value =  null
EXEC sp_addextendedproperty  @level0type = N'USER' ,@level0name = [ladlewall_readWrite] ,@name = N'securedsp-LAD.GetCurrentEquipment'		,@value =  null
EXEC sp_addextendedproperty  @level0type = N'USER' ,@level0name = [ladlewall_readWrite] ,@name = N'securedsp-LAD.GetLadles'					 ,@value =  null
EXEC sp_addextendedproperty  @level0type = N'USER' ,@level0name = [ladlewall_readWrite] ,@name = N'securedsp-LAD.OverrideHeatCounters'    ,@value =  N'SendCurrentUser=TRUE'  
EXEC sp_addextendedproperty  @level0type = N'USER' ,@level0name = [ladlewall_readWrite] ,@name = N'securedsp-LAD.GetEquipmentsPerType'    ,@value =  null  


insert into MES.LAD.catLadleEventTypes values (17,'Drain')

insert into MES.LAD.catLadleEventTypes values (18,'Override Counters')

use MES


SET IDENTITY_INSERT LAD.catEquipmentTypes ON
insert into LAD.catEquipmentTypes (id,name,replaceable)
select id,[name],0 from IHBoxSystem.EQUIP.EquipmentTypes
where id in (39,42,44,45,46,47,49,58,59)
SET IDENTITY_INSERT LAD.catEquipmentTypes OFF
update LAD.catEquipmentTypes set replaceable=1 where id in (39,42,44)



SET IDENTITY_INSERT LAD.catEquipments ON
insert into LAD.catEquipments (id,name,equipmenttypeid)
select EquipmentId,[Name],TypeId
from IHBoxSystem.EQUIP.EquipmentTemplates t 
left join IHBoxSystem.EQUIP.Equipments e on t. EquipmentId = e.id
where TypeId in (39,42,44,45,46,47,49,58,59) and equipmentid is not null
SET IDENTITY_INSERT LAD.catEquipments OFF



