﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
//@Override this is suggested by Microsoft, overriding the initialize culture function (that is
//automatically called by the aspx.
//Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
//(English).
protected override void InitializeCulture()
{
    HttpCookie lang = Request.Cookies["siteLanguage"]; 
    
    String selectedLanguage = (lang != null) ? lang.Value : "en";
    UICulture = selectedLanguage ;
    Culture = selectedLanguage ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(selectedLanguage);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(selectedLanguage);
    base.InitializeCulture();
}
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
    
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/jstree/themes/default/style.css") %>" rel="stylesheet" />

<style>
    .backgrid th{
        font-size:12px !important;
    }

    /*.backgrid td{
        min-height: 15px !important;
        height: 15px !important;
    }*/

    .backgrid tr{
        font-size:12px !important;
    }

    .blocker {
        position:absolute;
        top:0; 
        left:0; 
        width:100%;
        height:100%;
        background-color:#ccc; 
        opacity:0.4;
        z-index:1000; 
    }

    li.node-disabled {
        background-color:#e2e2e2 !important; 
        /*opacity:0.7;*/
        color:#a1a1a1;
    }

    .node-disabled.jstree-default.jstree-wholerow-hovered {
        background: red !important;
    }

    .jstree-themeicon-custom {
        background-color: transparent;
        background-size: 24px !important;
    }
    
    .form-horizontal .control-label {
        float: left;
        width: 80px;
        padding-top: 5px;
        text-align: right;
    }

    .form-horizontal .controls {
        margin-left: 100px;
    }

    .backgrid .align-center-cell {
        text-align: center !important;
    }

    .backgrid .align-left-cell {
        text-align: left !important;
    }

    .backgrid .align-right-cell {
        text-align: right !important;
    }

    .backgrid th.eventIdentityId,
    .backgrid td.eventIdentityId,
    .backgrid th.modeId,
    .backgrid td.modeId,
     .backgrid th.counterId,
     .backgrid td.counterId,
    .backgrid th.alarmTypeId,
    .backgrid td.alarmTypeId,
    .backgrid td.triggerValue,
    .backgrid td.triggerValue{
        width:120px !important;
        min-width:120px !important;
        max-width:120px !important;
    }

    .backgrid th.counterConfigurationId,
     .backgrid td.counterConfigurationId{
        width:200px !important;
        min-width:200px !important;
        max-width:200px !important;
    }

    .backgrid td.counterConfigurationId select{
        width:200px !important;
        margin: 0px !important;
        font-size:12px !important;
    }

    .backgrid td.eventIdentityId,
    .backgrid td.counterId,
    .backgrid td.modeId,
    .backgrid td.factorValue,
    .backgrid td.resetValue,
    .backgrid td.counterConfigurationId,
    .backgrid td.alarmTypeId,
    .backgrid td.triggerValue{
        padding-left: 10px !important;
        padding-right: 0px !important;
        margin: 0px !important;
    }

    .backgrid th.resetValue,
    .backgrid td.resetValue,
    .backgrid th.factorValue {
        width: 60px !important;
        min-width: 60px !important;
        max-width: 60px !important;
    }
    
    .backgrid td.eventIdentityId select,
    .backgrid td.counterId select,
    .backgrid td.modeId select,
    .backgrid td.alarmTypeId select{
        width:120px !important;
        margin: 0px !important;
        font-size:12px !important;
    }
    
    .backgrid td.resetValue input,
    .backgrid td.factorValue input{
        margin: 0px !important;
        width: 50px !important;
        min-width: 50px !important;
        max-width: 50px !important;
    }

    .backgrid td.triggerValue input{
        margin: 0px !important;
        width: 100px !important;
        min-width: 100px !important;
        max-width: 1100px !important;
    }

    .locked-row {
    background-color: #f5f5f5 !important;
    color: #aaa !important;
}

.locked-td{
    background-color: #f5f5f5 !important;
    color: #505050 !important;
}

.locked-row:hover {
    background-color: #f5f5f5 !important;
}

.machine-configuration-container .container-fluid{
    padding-right:0px !important;
   padding-left:0px !important;
   width: 105% !important;
}


</style>

<div class="container-fluid">
    <div class="row-fluid">
        <div class="span4">
            <%--<h5><asp:Localize runat="server" meta:resourcekey="lines_and_machines_title" /></h5>--%>
            <div style="margin-bottom:5px;">
                <%--
                <select data-bind="value: typeId, options: types, optionsDefault: { label: '<asp:Localize runat=server meta:resourcekey=all_option_label />', value: '' }" id="selectTypeFilter" name="selectTypeFilter">
                </select>
                <button class="btn btn-mini btn-add-item"><asp:Localize runat="server" meta:resourcekey="add_item_label" /></button>
                --%>

                <%--
                <button class="btn btn-mini btn-add-area"><asp:Localize runat="server" meta:resourcekey="add_area_label" /></button>
                <button class="btn btn-mini btn-add-line"><asp:Localize runat="server" meta:resourcekey="add_line_label" /></button>
                <button class="btn btn-mini btn-add-machine" disabled="disabled"><asp:Localize runat="server" meta:resourcekey="add_machine_label" /></button>
                --%>
            </div>
            <div style="height:500px;overflow-y:auto;" class="tree">
            </div>
        </div>
        <div class="span8">
            <%--<div class="machine-configuration-messages row-fluid hide">
                <span style="font-size:14px;">Seleccione una máquina para configurar.</span>
            </div>--%>
            <div class="machine-configuration-container row-fluid">
            </div>

            <div class="create-equipment-container row-fluid">
            </div>
        </div>
    </div>
</div>



<script id="machine_configuration" type="text/x-handlebars-template">
    <div class="container-fluid">
        <div class="row-fluid">
            <h5><asp:Localize runat="server" meta:resourcekey="configuration_title" /></h5>
        </div>
        <%--<div data-bind="toggle: hasBatchOpened" class="row-fluid batch-opened-message">
            <div class="alert alert-info">
                <span>
                    <asp:Localize runat="server" meta:resourcekey="batch_opened_on_machine_msg" />
                </span>
            </div>
        </div>--%>
        <div style="position:relative;" class="row-fluid">
            <%--<div data-bind="toggle: hasBatchOpened" class="blocker"></div>--%>
            <div class="row-fluid">
                <form id="detailsForm" class="form-horizontal">
                    <div class="">
                        <label class="control-label" for="labelName"><asp:Localize runat="server" meta:resourcekey="name_label" /></label>
                        <div class="controls">
                                <label style="padding-top:5px; text-align:left;" data-bind="text: name, " id="labelName"></label>    
                        </div>
                    </div>
                    {{HBExp '#ifEquals typeName "UNKNOWN"'}}
                    <div class="">
                        <label class="control-label" for="selectType"><asp:Localize runat="server" meta:resourcekey="type_label" /></label>
                        <div class="controls">
                            <select data-bind="value: type, options: typesBinding, optionsDefault: { label: '<asp:Localize runat=server meta:resourcekey=select_option_label />', value: -1 }" id="selectType" name="selectType">
                            </select>
                        </div>
                    </div>
                    {{HBExp 'else'}}
                    <div class="">
                        <label class="control-label" for="labelType"><asp:Localize runat="server" meta:resourcekey="type_label" /></label>
                        <div class="controls">
                            <label style="padding-top:5px;text-align:left;" data-bind="text: typeName, " id="labelType"></label>
                        </div>
                    </div>
                    {{HBExp '/ifEquals'}}

                    {{HBExp '#ifEquals internal true'}}
                    {{HBExp 'else'}}
                    <div class="">
                        <label class="control-label" for="selectStatusCode"><asp:Localize runat="server" meta:resourcekey="status_code_label" /></label>
                        <div class="controls">
                            <label style="padding-top:5px;text-align:left;" data-bind="text: statusName, " id="label1"></label>
                        </div>
                    </div>
                    {{HBExp '/ifEquals'}}
                </form>
            </div>
        </div>
        <div class="row-fluid" >
            {{HBExp '#ifEquals internal true'}}

            {{HBExp 'else'}}
            <div class="row-fluid">
                <div class="span8">
                    <h5><asp:Localize runat="server" meta:resourcekey="counter_configuration_title" /></h5>
                </div>
                <div class="span4">
                    <button class="btn btn-mini btn-block btn-add-counter" style="float:right; margin:5px; width: 65px;"><asp:Localize runat="server" meta:resourcekey="add_counter_label" /></button>
                </div>
            </div>
            <div class="row-fluid" style="max-width:100%; ">
                <div class="row-fluid items-grid-container infinite-container" data-bind="classes: { hide: false, /*any(not(hasData), isLoading)*/ },"></div>
            </div>
            {{HBExp '/ifEquals'}}
        </div>
        <div style="margin-top:8px;" class="row-fluid">
            {{HBExp '#ifEquals internal true'}}

             {{HBExp 'else'}}
            <div class="span6 offset3 hide counter_configuration_buttons" style="margin-bottom: 15px;">
                <div class="span6">
                    <button disabled="disabled" class="btn btn-primary btn-block btn-save-counters"><asp:Localize runat="server" meta:resourcekey="save_label" /></button>
                </div>
                <div class="span6">
                    <button disabled="disabled" class="btn btn-block btn-cancel-counters"><asp:Localize runat="server" meta:resourcekey="cancel_label" /></button>
                </div>
            </div>
            {{HBExp '/ifEquals'}}
        </div>
        <div class="row-fluid" style="margin-top:30px;position:relative;" >
            
            {{HBExp '#ifEquals internal true'}}

            {{HBExp 'else'}}
            <div data-bind="toggle: any(not(hasConfigurations))" class="blocker"></div>
            <div  class="row-fluid">
                
                <div class="span8">
                    <h5><asp:Localize runat="server" meta:resourcekey="alarm_configuration_title" /></h5>
                </div>
                <div class="span4">
                    <button class="btn btn-mini btn-block btn-add-alarm" style="float:right; margin:5px; width: 65px;"><asp:Localize runat="server" meta:resourcekey="add_alarm_label" /></button>
                </div>
            </div>
            <div class="row-fluid" style="max-width:100%; ">
                <div class="row-fluid alarms-grid-container infinite-container" data-bind="classes: { hide: false, /*any(not(hasData), isLoading)*/ },"></div>
            </div>
            {{HBExp '/ifEquals'}}
            <div style="margin-top:8px;" class="row-fluid">
                {{HBExp '#ifEquals internal true'}}

                 {{HBExp 'else'}}
                <div class="span6 offset3 hide counter_alarm_configuration_buttons" style="margin-bottom: 15px;">
                    <div class="span6">
                        <button disabled="disabled" class="btn btn-primary btn-block btn-save-alarms"><asp:Localize runat="server" meta:resourcekey="save_label" /></button>
                    </div>
                    <div class="span6">
                        <button disabled="disabled" class="btn btn-block btn-cancel-alarms"><asp:Localize runat="server" meta:resourcekey="cancel_label" /></button>
                    </div>
                </div>
                {{HBExp '/ifEquals'}}
            </div>
        </div>
        
    </div>
    
    <script id="actions_cell_template" type="text/x-handlebars-template">
        <div class="text-center">
            <button data-toggle="tooltip" data-placement="bottom" data-cell-action="DELETE" 
                ="<asp:Localize runat=server meta:resourcekey=remove_batch_title />" class="btn btn-cell-action btn-small btn-remove"><i class="fa fa-trash-o"></i></button>
        </div>
    </script>


</script>


<script id="subnavbar_controls" type="text/x-handlebars-template">
    <div class="span12">
        <div class="subnavbar-toolbar form-inline">

            <button class="btn btn-mini btn-collapse-tree btn-tree" style="margin:0; float:left; margin-left:10px; margin-top:5px;" type="button">
                <span class="collapse"> <asp:Localize runat="server" meta:resourcekey="collapse_tree" /> </span>
            </button>

            <button class="btn btn-mini btn-expand-tree btn-tree hide" style="margin:0; float:left; margin-left:10px; margin-top:5px;" type="button">
                <span class="expand"><asp:Localize runat="server" meta:resourcekey="expand_tree" /></span>
            </button>
        </div>
    </div>
</script>
