﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>

<script runat="server">
    String version = WebAppVersion.GetWebAppVersion();

    //@Override this is suggested by Microsoft, overriding the initialize culture function (that is
    //automatically called by the aspx.
    //Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
    //(English).
    protected override void InitializeCulture()
    {
        HttpCookie lang = Request.Cookies["siteLanguage"];

        String selectedLanguage = (lang != null) ? lang.Value : "en";
        UICulture = selectedLanguage;
        Culture = selectedLanguage;

        Thread.CurrentThread.CurrentCulture = CultureInfo.CreateSpecificCulture(selectedLanguage);
        Thread.CurrentThread.CurrentUICulture = new CultureInfo(selectedLanguage);
        base.InitializeCulture();
    }
</script>

<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).

    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css")%>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/extensions/valid-limit-cell/backgrid-valid-limit-cell.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/autocomplete/backbone.autocomplete.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/app/custom-screens/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + ".css")%>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/multiselect/virtual-select.min.css") %>" rel="stylesheet" />

<div class="row-fluid subnavbar fixed-subnavbar" style="height: 0px;padding:0px;">
    <div class="row-fluid form-inline">
    </div>
</div>

<div class="row-fluid screen-content"  stlye="margin-top: 10px;">
     <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: any(hasData, isLoading), }" style="height:500px;">
        <div class="row-fluid" style="position:relative;top:100px;">
            <i class="fw-icon-circle-blank fw-icon-4x" style="font-size:115px;"></i>
        </div>
        <div class="row-fluid" style="position:relative;top:115px;">
            <h3 style="font-size:50px;">
                <asp:localize runat="server" meta:resourcekey="no_data_available" />
            </h3>
        </div>
    </div>
    <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: not(isLoading), }" style="height:500px;">
        <div class="row-fluid" style="position:relative;top:100px;">
            <i class="fa fa-cog fw-icon-4x fa-spin" style="font-size:115px;"></i>
        </div>
        <div class="row-fluid" style="position:relative;top:115px;">
            <h3 style="font-size:50px;">
                <asp:localize runat="server" meta:resourcekey="loading_data" />
            </h3>
        </div>
    </div>
    <!---Tables--->


    <div class="row-fluid" <%--data-bind="classes: { hide: any(not(hasData), isLoading), }"--%>>
        <div class="span4">            
            <label class="title-power">Caster 1</label>
            <div class="power-curtailment-grid-1-container items-grid-container"></div>
        </div>
        <div class="span4">      
            <label class="title-power">Caster 2</label>      
            <div class="power-curtailment-grid-2-container items-grid-container"></div>
        </div>
        <div class="span4">             
            <label class="title-power">LMF</label>
            <div class="power-curtailment-grid-3-container items-grid-container"></div>
        </div>     
    </div>
    <div class="row-fluid">
        <div class="span4" style="margin-top:10px">            
            <label class="title-power">VTD Boiler</label>
            <div class="power-curtailment-grid-4-container items-grid-container"></div>
        </div>
        <div class="span4" style="margin-top:10px">      
            <label class="title-power">Refractory</label>      
            <div class="power-curtailment-grid-5-container items-grid-container"></div>
        </div>        
        <div class="span4" style="margin-top:10px">
            <label class="title-power">
                Notes:			
            </label>
            <label class="title-power">
                1. Off means try not use, not turning off power.									
            </label>
             <label class="title-power">
                2. Maintenance only means a short run of equipment											
            </label>
            <label class="title-power">
                3. Minimize crane use. Only one motion at a time is preferred.									
            </label>
            <label class="title-power">            								
                4. If Hydrualics are shut off, please contact Millwright before starting.									
            </label>
            								
        </div>
    </div>

      
</div>

