﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" %>

<!DOCTYPE html>

<script runat="server">
    String version = WebAppVersion.GetWebAppVersion(); 
</script>

<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
//@Override this is suggested by Microsoft, overriding the initialize culture function (that is
//automatically called by the aspx.
//Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
//(English).
protected override void InitializeCulture()
{
    HttpCookie lang = Request.Cookies["siteLanguage"]; 
    
    String selectedLanguage = (lang != null) ? lang.Value : "en";
    UICulture = selectedLanguage ;
    Culture = selectedLanguage ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(selectedLanguage);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(selectedLanguage);
    base.InitializeCulture();
}
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
    
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>
<html>
    <head>
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />
    <meta charset="utf-8" />
    <meta name="description" content="" />

    <title>Trending</title>

    <script src="<%
        Response.Write(ResolveUrl(VirtualPathUtility.GetDirectory(Request.ApplicationPath) + "IndustrialDashboard/Scripts/IndustrialDashboard-debug.js?v=" + version)); 
    %>" type="text/javascript"></script> 

    <link type="text/css" href="<%= ResolveUrl(VirtualPathUtility.GetDirectory(Request.ApplicationPath) + "IndustrialDashboard/Styles/IndustrialDashboard.css?v=" + version) %>" rel="stylesheet" />

    <script type="text/javascript">
        var _Includer = new window.Includer({
            Widgets: [
                'SecurityLogin'
            ]
            , XML: { Available: false }
            , Theme: "DZSupervision"
        });
    </script>
    
    <%--mousetrap for key shortcuts--%>
    <script src="<%= ResolveUrl("~/assets/libs/jam/Mousetrap/mousetrap.js") %>"></script>
    <script src="<%= ResolveUrl("~/assets/libs/jam/jquery/dist/jquery.js") %>"></script>
    <script src="<%= ResolveUrl("~/assets/libs/js/moment/moment.js") %>"></script>

    <link href="<%= ResolveUrl(VirtualPathUtility.GetDirectory(Request.ApplicationPath) + "IndustrialDashboard/Widgets/ValuePicker/Styles/ValuePicker.css?v=" + version) %>" rel="stylesheet" />
    <link href="<%= ResolveUrl(VirtualPathUtility.GetDirectory(Request.ApplicationPath) + "IndustrialDashboard/Widgets/IndustrialContainer/Styles/IndustrialContainer.css?v=" + version) %>" rel="stylesheet" />
    <link href="<%= ResolveUrl(VirtualPathUtility.GetDirectory(Request.ApplicationPath) + "IndustrialDashboard/ForeignFiles/JSColor/Styles/jscolor.css?v=" + version) %>" rel="stylesheet" />
    <link href="<%= ResolveUrl(VirtualPathUtility.GetDirectory(Request.ApplicationPath) + "IndustrialDashboard/ForeignFiles/jstree/scripts/themes/default/style.css?v=" + version) %>" rel="stylesheet" />
    <link href="<%= ResolveUrl(VirtualPathUtility.GetDirectory(Request.ApplicationPath) + "IndustrialDashboard/Widgets/IndustrialChartConfiguration/Styles/IndustrialChartConfiguration.css?v=" + version) %>" rel="stylesheet" />
    <link href="<%= ResolveUrl(VirtualPathUtility.GetDirectory(Request.ApplicationPath) + "IndustrialDashboard/Widgets/TimePicker/Styles/TimePicker.css?v=" + version) %>" rel="stylesheet" />
    <link href="<%= ResolveUrl(VirtualPathUtility.GetDirectory(Request.ApplicationPath) + "IndustrialDashboard/Widgets/CalendarPicker/Styles/CalendarPicker.css?v=" + version) %>" rel="stylesheet" />
    <link href="<%= ResolveUrl(VirtualPathUtility.GetDirectory(Request.ApplicationPath) + "IndustrialDashboard/Widgets/IndustrialChart/Styles/IndustrialChart.css?v=" + version) %>" rel="stylesheet" />
    <link href="<%= ResolveUrl(VirtualPathUtility.GetDirectory(Request.ApplicationPath) + "IndustrialDashboard/Widgets/ScopePicker/Styles/ScopePicker.css?v=" + version) %>" rel="stylesheet" />

    <%--<script src="<%= ResolveUrl(VirtualPathUtility.GetDirectory(Request.ApplicationPath) + "IndustrialDashboard/ForeignFiles/jquery/Scripts/jquery-1.4.2.js?v=" + version) %>"></script>--%>
    <script src="<%= ResolveUrl(VirtualPathUtility.GetDirectory(Request.ApplicationPath) + "IndustrialDashboard/ForeignFiles/canvas/Scripts/excanvas.js?v=" + version) %>"></script>
    <script src="<%= ResolveUrl(VirtualPathUtility.GetDirectory(Request.ApplicationPath) + "IndustrialDashboard/ForeignFiles/canvas/Scripts/dateformat.js?v=" + version) %>"></script>
    <script src="<%= ResolveUrl(VirtualPathUtility.GetDirectory(Request.ApplicationPath) + "IndustrialDashboard/ForeignFiles/canvas/Scripts/canvastext.js?v=" + version) %>"></script>
    <script src="<%= ResolveUrl(VirtualPathUtility.GetDirectory(Request.ApplicationPath) + "IndustrialDashboard/ForeignFiles/canvas/Scripts/CanvasText-0.4.1.js?v=" + version) %>"></script>
    <script src="<%= ResolveUrl(VirtualPathUtility.GetDirectory(Request.ApplicationPath) + "IndustrialDashboard/Addons/Export/Scripts/export.js?v=" + version) %>"></script>
    <script src="<%= ResolveUrl(VirtualPathUtility.GetDirectory(Request.ApplicationPath) + "IndustrialDashboard/Widgets/ValuePicker/Scripts/ValuePicker.js?v=" + version) %>"></script>
    <script src="<%= ResolveUrl(VirtualPathUtility.GetDirectory(Request.ApplicationPath) + "IndustrialDashboard/Widgets/IndustrialContainer/Scripts/IndustrialContainer.js?v=" + version) %>"></script>
    <script src="<%= ResolveUrl(VirtualPathUtility.GetDirectory(Request.ApplicationPath) + "IndustrialDashboard/ForeignFiles/JSColor/Scripts/jscolor.js?v=" + version) %>"></script>
    <script src="<%= ResolveUrl(VirtualPathUtility.GetDirectory(Request.ApplicationPath) + "IndustrialDashboard/ForeignFiles/jstree/Scripts/jstree.js?v=" + version) %>"></script>
    <script src="<%= ResolveUrl(VirtualPathUtility.GetDirectory(Request.ApplicationPath) + "IndustrialDashboard/Widgets/IndustrialChartConfiguration/Scripts/IndustrialChartConfiguration.js?v=" + version) %>"></script>
    <script src="<%= ResolveUrl(VirtualPathUtility.GetDirectory(Request.ApplicationPath) + "IndustrialDashboard/Widgets/TimePicker/Scripts/TimePicker.js?v=" + version) %>"></script>
    <script src="<%= ResolveUrl(VirtualPathUtility.GetDirectory(Request.ApplicationPath) + "IndustrialDashboard/Widgets/CalendarPicker/Scripts/CalendarPicker.js?v=" + version) %>"></script>
    <script src="<%= ResolveUrl(VirtualPathUtility.GetDirectory(Request.ApplicationPath) + "IndustrialDashboard/Widgets/IndustrialChart/Scripts/IndustrialChart.js?v=" + version) %>"></script>
    <script src="<%= ResolveUrl(VirtualPathUtility.GetDirectory(Request.ApplicationPath) + "IndustrialDashboard/Widgets/ScopePicker/Scripts/ScopePicker.js?v=" + version) %>"></script>

    <script src="<%= "trending-instance.js?v=" + version %>"></script>
    </head>
    <body style="height:100%; width:100%; margin:0; padding:0; position:fixed;">
        <div style="width:98%; margin-left:1%;position:relative;height:100%;">
            <div style="height:90%;" id="trending_widget_container">

            </div>
        </div>
    </body>
</html>