﻿define([
  'app',
  'modules/base/base',
],
function (app, Base) {

    var Main = {
        Models: {},
        Collections: {},
    };

    (function () {
        var superRef, superProto, classRef;

        superRef = Base.Models.Base;
        superProto = superRef.prototype;

        Main.Models.CatalogCode = classRef = superRef.extend({
            defaults: {
                code: null,

                active: null,
                description: null,
                name: null,
            },
            idAttribute: 'code',

            parse: function (obj) {
                return {
                    code: obj.Code,

                    active: obj.Active,
                    description: $.trim(obj.Description),
                    name: $.trim(obj.Name),
                };
            },
        });
    })();

    (function () {
        var superRef, superProto, classRef;

        superRef = Base.Collections.Base;
        superProto = superRef.prototype;

        Main.Collections.CatalogCodes = classRef = superRef.extend({
            model: Main.Models.CatalogCode,

            comparator: 'name',
        });
    })();

    // Required, return the module for AMD compliance.
    return Main;

});