﻿/// <reference path="http://localhost/IndustrialDashboard/Scripts/IndustrialDashboard.js" />

define([
  // Application.
  "app",

  //templates-loader
  "js/templates-loader"

],

function (app, T) {

    var DateControl = { Model: {}, Views: {} }

    DateControl.Model = Backbone.Model.extend({
        defaults: {
            date: Core.DateTime.ToString(new Date(), "yyyy-mm-dd")
            , updateURI: true
        }
        , initialize: function () {
            
        }
        
    });

    DateControl.Views.Main = Backbone.View.extend({
        template: "dateControl/dateControl"
        , id: "global-date-control"
        , title: ""
        //default not cacheable, change this if you want the view to be cacheable
        // if the view is set as cacheable should also have a refresh method to reset the view without erasing the DOM.
        //refreshing only the data, maybe?
        , isCacheable: false
        , initialize: function () {
            this.options.MYREFERENCES = {};

            this.options.instance_id = (new Date()).getTime(); 

            this.listenTo(this.model, "change:date", this.dateModelChanged);
        }, 
        // global view variable (seen in this scope, public to the view, and SHARED BETWEEN OTHER INSTANCES OF THE SAME VIEW)
        // containing all the variables for this view

        //properties that you wanna scope as private variables for each instance of a view should not be placed here
        //the only way i found to maintain the variables between instances of the same view, is either using models,
        // (each view will have its own model so data is not shared between them), or in case you don't want to use a model
        // you can use the Backbone.View.options object, and doing something like
        // this.options.attributes = {}
        // and storing every single variable inside attributes.

        events: {
            "click #calendar-icon-clickeable": "showCalendar"
            , "focus .datepicker_input": "showCalendarFocus"
        }, 

        render: function (container) {
            var that = this;
            var thatContainer = container;
            
            T.render.call(this, this.template, function (tmp) {
                //getInternationalizationData
                if (!that.options.i18n) that.options.i18n = {};
                app.getI18NJed(that, that.template, function (i18nJED) {
                    //storing internationalization data
                    that.options.i18n[that.template] = i18nJED;

                    //start: before the view is visible, but the template was already loaded (not instanced nor appended)

                    //end:

                    //loading the view and appeding it to the views's $el.
                    that.$el.html(tmp({
                        instance_id: that.options.instance_id, 
                    }));

                    //start: the view was already loaded an is on a div element, but not appended to the main container
                    //here you can perform anything you want DOM related, by getting the dom element via that.$el.find("#id")

                    that.options.MYREFERENCES.datePicker1 = that.$el.find("#datePicker1_" + that.options.instance_id).datepicker(
                        _.extend({
                            showOn: "focus"
                            , beforeShow: function () { that.calendarBeforeShow.call(that); }
                            , onSelect: function () { that.calendarChanged.call(that); }
                            , showOtherMonths: true
                            , selectOtherMonths: true
                            , dateFormat: 'mm/dd/yy'
                        }, that.options.datepicker_options || {})
                    );

                    that.options.MYREFERENCES.datePicker1.datepicker("setDate", Core.DateTime.Parse(that.model.get("date")));

                    $(".ui-datepicker").wrap('<div class="jqueryUIcontrols" />');

                    that.$el.find("#datePicker1_" + that.options.instance_id).show();

                    //:end

                    //appending view to the main container
                    thatContainer.append(that.$el);

                }, false);
            });
        }
        , dateModelChanged: function () {
            if (this.options.MYREFERENCES.datePicker1) {
                if (Core.DateTime.ToString(this.options.MYREFERENCES.datePicker1.datepicker("getDate"), "yyyy-mm-dd HH:MM:ss") != this.model.get("date"))
                    this.options.MYREFERENCES.datePicker1.datepicker("setDate", Core.DateTime.Parse(this.model.get("date")));
            }
        }

        , calendarChanged: function (params) {
            var dateSelected = Core.DateTime.ToString(this.options.MYREFERENCES.datePicker1.datepicker("getDate"), "yyyy-mm-dd HH:MM:ss");
            this.model.set("date", dateSelected);
        }

        , calendarBeforeShow: function () {
            try {                
            } catch (Error) { }
        }

        , showCalendar: function () {
            if (this.options.MYREFERENCES.datePicker1.datepicker("widget").is(":visible"))
                this.options.MYREFERENCES.datePicker1.datepicker("hide");
            else
                this.options.MYREFERENCES.datePicker1.datepicker("show"); 
        }

        , showCalendarFocus: function () {
            //$("#calendar-icon-clickeable").click();
        }
        , _setSectionsLayout: function () {
            app.models.subnavbar.set("sections", "4-4-4");
        }
        , close: function () {
            this.remove();
            this.unbind();
        }
        , show: function () {
            this._setSectionsLayout(); 
            this.$el.show();
        }
        , hide: function () {
            this.$el.hide();
        }
    });

    // Required, return the module for AMD compliance.
    return DateControl;

});
