﻿define([
  'app',
  'modules/catalog',
],
function (app, Catalog) {

    var Main = {
        Models: {},
        Collections: {},
    };

    (function () {
        var superRef, superProto, classRef;

        superRef = Catalog.Models.Catalog;
        superProto = superRef.prototype;

        Main.Models.EventType = classRef = superRef.extend({
            defaults: _.extend(
                {},
                superProto.defaults,
                {
                    name: null,
                    tagId: null,
                    tagAscendingFlank: null,
                    tag2Id: null,
                    tag2AscendingFlank: null,
                    active: null,
                    tagResetValue: null,
                    tagRealAsDigital: null,

                }
            ),
            procedures: {
                get: app.DatabaseNames.ELT + '.CAT.GetEventTypes',
            },

            parse: function (obj) {
                return _.extend(superProto.parse.apply(this, arguments), {
                    name: obj.Name,
                    tagId: obj.TagId,
                    tagAscendingFlank: obj.TagAscendingFlank,
                    tag2Id: obj.Tag2Id,
                    tag2AscendingFlank: obj.tag2AscendingFlank,
                    active: obj.Active,
                    tagResetValue: obj.TagResetValue,
                    tagRealAsDigital: obj.TagRealAsDigital,
                });
            },
        });
    })();

    (function () {
        var superRef, superProto, classRef;

        superRef = Catalog.Collections.Catalogs;
        superProto = superRef.prototype;

        Main.Collections.EventTypes = classRef = superRef.extend({
            model: Main.Models.EventType,
        });
        _.extend(classRef, {
            fetch: function (options) {
                var opt = _.extend(
                        { error: function () { }, success: function () { }, },
                        options
                    );

                classRef.prototype.getData.apply(classRef.prototype, [_.extend(
                    {},
                    opt,
                    {
                        success: function (resp) {
                            if (resp.Table) {
                                opt.success(_.map(resp.Table, classRef.prototype.model.prototype.parse));
                            }
                            else {
                                var msg = (resp.Message) ? resp.Message : 'Can not fetch event type.';

                                console.error(new Error(msg).stack);
                                opt.error(msg);
                            }
                        },
                    }
                )]);
            },
        });
    })();

    // Required, return the module for AMD compliance.
    return Main;

});