﻿define([
  'app',
  'modules/catalog',
],
function (app, Catalog) {

    var Main = {
        Models: {},
        Collections: {},
    };

    (function () {
        var superRef, superProto, classRef;

        superRef = Catalog.Models.Catalog;
        superProto = superRef.prototype;

        Main.Models.Event = classRef = superRef.extend({
            defaults: _.extend(
                {},
                superProto.defaults,
                {
                    
                    name: null,
                    eventId: null,
                    eventTypeId: null,
                    thresholdValue: null,
                }
            ),
            procedures: {
                get: app.DatabaseNames.System + '.EVENT.GetEvents',
            },

            parse: function (obj) {
                return _.extend(superProto.parse.apply(this, arguments), {
                    name: obj.Name,
                    eventId: obj.EventId,
                    eventTypeId: obj.EventTypeId,
                    thresholdValue: obj.ThresholdValue,
                });
            },
        });
    })();

    (function () {
        var superRef, superProto, classRef;

        superRef = Catalog.Collections.Catalogs;
        superProto = superRef.prototype;

        Main.Collections.Events = classRef = superRef.extend({
            model: Main.Models.Event,
        });
        _.extend(classRef, {
            fetch: function (options) {
                var opt = _.extend(
                        { error: function () { }, success: function () { }, },
                        options
                    );

                classRef.prototype.getData.apply(classRef.prototype, [_.extend(
                    {},
                    opt,
                    {
                        success: function (resp) {
                            if (resp.Table) {
                                opt.success(_.map(resp.Table, classRef.prototype.model.prototype.parse));
                            }
                            else {
                                var msg = (resp.Message) ? resp.Message : 'Can not fetch event.';

                                console.error(new Error(msg).stack);
                                opt.error(msg);
                            }
                        },
                    }
                )]);
            },
        });
    })();

    // Required, return the module for AMD compliance.
    return Main;

});