﻿define([
    // Application.
    "app",
    'js/templates-loader',
    'modules/modal2',
    'moment',
    'js/jquery.clearsearch/jquery.clearsearch',
],

    function (app, T, Modal, moment) {

        var Screen = {
            Views: {},
        };


        Screen.Views.LadleInfoWidget = Backbone.Epoxy.View.extend({
            template: "ladle-info-widget/ladle-info-widget"
            , tagName: 'div'
            , className: 'draggable draggable-object'
            , isCacheable: false          
            , bindings: "data-bind"

            , initialize: function (attr) {
                this.model = attr.model;
                var params = this.model.toJSON();
                $(this.el).attr("id", 'container' + params.ContainerId);
                this.render();

            }
            , render: function (container) {
                if (container)
                    this.container = container;

                //the screens have a custompath, so it has to be specified in the customPath variable that is
                //then sent to the template loader.
                var that = this,
                    //customPath = "/app/custom-screens/rolling-mill-setup/";
                    customPath = "/app/templates/";

                var attrs = this.model.toJSON();

                T.render.call(this, this.template, function (tmp) {
                    if (!that.i18n) that.i18n = {};
                    app.getI18NJed(that, that.template, function (i18nJED) {
                        //storing internationalization data
                        that.i18n[that.template] = i18nJED;
                        //loading the view and appeding it to the views's $el.
                        that.$el.html(tmp(that.model.toJSON()));
                        that.applyBindings();

                        that.isRendered = true;

                        that.trigger("render");


                    }, true, customPath);

                }, customPath, "ladle-info-widget");
            }

        });


        // Required, return the module for AMD compliance.
        return Screen;

    });
