﻿/// <reference path="http://localhost:50976/IndustrialDashboard/Scripts/IndustrialDashboard-debug.js" />
define([
  // Application.
  "app",

  "Mousetrap", 

  //templates-loader
  "js/templates-loader"

],

function (app, Mousetrap, T) {

    var TopMessagesControl = { Model: {}, Views: {} }

    TopMessagesControl.Model = Backbone.Model.extend({
        defaults: {
        },
        initialize: function () {
        }
    });

    TopMessagesControl.Views.Main = Backbone.View.extend({
        template: "topMessagesControl/topMessagesControl"
        , id: "top-messages-control"
        //default not cacheable, change this if you want the view to be cacheable
        // if the view is set as cacheable should also have a refresh method to reset the view without erasing the DOM.
        //refreshing only the data, maybe?
        , isCacheable: false
        , el: null
        , initialize: function () {
            _.bindAll(this); 

            this.bindEvents();

            this.options.MYREFERENCES = {
                message_container: null
                , isVisible: false
                , hide_toid: null
            }; 
        },
        // global view variable (seen in this scopy, public to the view, and SHARED BETWEEN OTHER INSTANCES OF THE SAME VIEW)
        // containing all the variables for this view

        //properties that you wanna scope as private variables for each instance of a view should not be placed here
        //the only way i found to maintain the variables between instances of the same view, is either using models,
        // (each view will have its own model so data is not shared between them), or in case you don't want to use a model
        // you can use the Backbone.View.options object, and doing something like
        // this.options.attributes = {}
        // and storing every single variable inside attributes.
        events: {
            "click .close-button": "closeMessage"
        },
        render: function (tmpOptions, onComplete) {
            var that = this;
            tmpOptions = (tmpOptions) ? tmpOptions : {};
            onComplete = (onComplete) ? onComplete : function () { };

            T.render.call(this, this.template, function (tmp) {

                //start: before the view is visible, but the template was already loaded (not instanced nor appended)
                that.$el.empty();
                //end:

                //loading the view and appeding it to the views's $el.
                that.$el.html(tmp(tmpOptions));

                that.options.MYREFERENCES.message_container = that.$("#message_container"); 

                onComplete(); 

            }, null, "main_template");
        }

        , showMessage: function (message, opt) {
            var options = {
                stay: 5000
            }

            options = _.extend(options, (opt) ? opt : {}); 

            var that = this;

            if (this.options.MYREFERENCES.hide_toid != null) {
                clearTimeout(this.options.MYREFERENCES.hide_toid);
                this.options.MYREFERENCES.hide_toid = null; 
            }
            
            //this.render({
            //    message: message
            //}, function () { that._afterRender(options); });

            this.$("#message_content").text(message);
            this._afterRender(options); 
        }

        , _afterRender: function (options) {
            var elemToFadeIn = this.options.MYREFERENCES.message_container;
            var that = this;
            if (!this.options.MYREFERENCES.isVisible) {
                elemToFadeIn.fadeIn(function () {
                    that.options.MYREFERENCES.isVisible = true;
                    that.options.MYREFERENCES.hide_toid = setTimeout(that.hideMessage, options.stay);
                });
            } else {
                this.options.MYREFERENCES.hide_toid = setTimeout(this.hideMessage, options.stay); 
            }
        }

        , hideMessage: function () {
            if (this.options.MYREFERENCES.hide_toid != null) {
                clearTimeout(this.options.MYREFERENCES.hide_toid);
                this.options.MYREFERENCES.hide_toid = null; 
            }

            var elemToFadeOut = this.options.MYREFERENCES.message_container;
            var that = this;
            if (this.options.MYREFERENCES.isVisible) {
                elemToFadeOut.fadeOut(function () {
                    that.options.MYREFERENCES.isVisible = false;
                });
            }
        }

        , closeMessage: function () {
            this.hideMessage(); 
        }

        , bindEvents: function () {

        }

        , unbindEvents: function () {

        }

        , close: function () {
            this.remove();
            this.unbindEvents(); 
            this.unbind();
        }
        , show: function () {
            this.bindEvents(); 
            this.$el.show();
        }
        , hide: function () {
            this.$el.hide();
            this.unbindEvents(); 
            this.unbind();
            this.stopListening();
        }
    });

    // Required, return the module for AMD compliance.
    return TopMessagesControl;

});
