﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" %>

<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
protected override void InitializeCulture()
{

    HttpCookie lang = Request.Cookies["siteLanguage"]; 
    
    String selectedLanguage = (lang != null) ? lang.Value : "en";
    UICulture = selectedLanguage ;
    Culture = selectedLanguage ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(selectedLanguage);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(selectedLanguage);
    base.InitializeCulture();
}
</script>
<%  Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<div id="dropdown-user" class="">
    <a style="font-size:18px; font-weight:normal;" class="btn dropdown-toggle" data-toggle="dropdown">
        <%--<i class="icon-user"></i> <span id="logged-username">{{username}}</span>
        <span class="caret"></span>--%>
        <i class="fw-icon-user fw-icon-large" style="margin-right:5px;"></i> <span id="logged-username">{{spaceFriendlyString username 10}}</span>
        <span class="caret"></span>
    </a>
    <ul style="color:#000; " class="dropdown-menu">
        <li style="display:none;" id="user-dropdown-option-settings" ><a href="#!/user/settings"><asp:Localize runat="server" meta:resourcekey="settings" /></a></li>
        <li id="user-dropdown-option-logOut" ><a href="#!/user/logout"><asp:Localize runat="server" meta:resourcekey="log_out" /></a></li>
    </ul>
</div>


            

