﻿/*
  backgrid-add-row-cell 1.0.0
*/
(function (root, factory) {

    if (typeof define === 'function' && define.amd) {
        // AMD
        define(["underscore", "backgrid"], factory);
    } else if (typeof exports === 'object') {
        // CommonJS
        module.exports = factory(require("underscore"), require("backgrid"));
    } else {
        // Browser globals
        factory(root._, root.Backgrid, root.moment);
    }

}(this, function (_, Backgrid) {

    //Fix require config issue with Underscore.
    if (!_)
        _ = this._;

    Backgrid.Extension.AddRowHeaderCell = Backgrid.HeaderCell.extend({
        template: null,
        className: 'add-row-cell',
        events: function () {
            return {
                'click .btn-cell-action': this.actionBtn_click,
            };
        },

        render: function () {
            this.$el.html(this.template());

            this.$el.find('[data-toggle="tooltip"]').tooltip();

            this.delegateEvents();

            return this;
        },

        actionBtn_click: function (e) {
            try {
                var attrs = { isNew: true, };
                attrs[this.collection.model.prototype.idAttribute] = -1;

                this.collection.unshift(attrs);
            }
            catch (Error) { console.error(Error.stack); }
        },
    });
}));
