﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class landing_api_validation_status : System.Web.UI.Page
{
    System.Web.Script.Serialization.JavaScriptSerializer jss = new System.Web.Script.Serialization.JavaScriptSerializer();
    protected void Page_Load(object sender, EventArgs e)
    {
        try
        {
            bool validated = false;
            string username = (String.IsNullOrEmpty(Request.Form["username"])) ? null : Request.Form["username"];
            string email = (String.IsNullOrEmpty(Request.Form["email"])) ? null : Request.Form["email"];

            if (username != null || email != null)
            {
                int? userid = DAL.getUserId(username, email);
                if (userid != null)
                {
                    Dictionary<string, string> userinfo = DAL.getUserInfo((int)userid);
                    if (userinfo != null)
                    {
                        if (!String.IsNullOrEmpty(userinfo["Validated"])) validated = bool.Parse(userinfo["Validated"]);
                        Response.Write(jss.Serialize(new { status = "OK", validated = validated }));
                    }
                    else
                    {
                        Response.Write(jss.Serialize(new { status = "FAILED_WHEN_GETTING_USER_INFO", validated = validated }));
                    }
                }
                else
                {
                    Response.Write(jss.Serialize(new { status = "FAILED_WHEN_GETTING_USER_ID", validated = validated }));
                }
            }
            else
            {
                Response.Write(jss.Serialize(new { status = "MISSING_PARAMETERS", validated = validated }));
            }
        }
        catch (Exception ex)
        {
            Response.Write(jss.Serialize(new { status = "FAILED_WITH_EXCEPTION" }));
        }
    }
}