﻿Core.DOM.Ready(function () {
    //settings the baseURL for the requirejs
    require.config({
        baseUrl: configPath, 
        packages: [
                {
                    "name": "underscore",
                    "location": "../assets/libs/jam/underscore",
                    "main": "underscore.js"
                },
        ],
    });

    require(['require-config'], function () {
        require(["app-config"], function (app_config) {
            var timezoneCode = null;
            Core.Include({
                Widgets: []
                , Events: {
                    onLoad: function () {
                        function autoLogin() {
                            try {
                                if (window && window["SecurityLogin"] && window["SecurityLogin"].Logoff
                                    && window["SecurityLogin"].Login
                                    && window["SecurityLogin"].IsLogged) {
                                    //always log off first
                                    SecurityLogin.Logoff();
                                    loginDefault();

                                    if (SecurityLogin.IsLogged()) {
                                        setTimeout(instanceScreen, 1000);
                                    } else {
                                        setTimeout(autoLogin, 100); 
                                    }
                                } else {
                                    setTimeout(autoLogin, 100);
                                }
                            } catch (error) {
                                console.log(error);
                            }
                        }

                        function loginDefault() {
                            try {
                                var username = "IHBoxDefaultUser";
                                var password = "public";
                                SecurityLogin.Login(username, password);
                                var logged = SecurityLogin.IsLogged();
                            } catch (error) { console.log(error); }
                        }

                        autoLogin();

                        function instanceScreen() {
                            $("#loading_poster").addClass("hide");
                            var that = this;
                            require(["app", "custom-screens/IHConfiguration/network-overview-d3js/network-overview"], function (app, Screen) {
                                function t1() {
                                    if (app.models.user) {
                                        t();
                                    } else {
                                        setTimeout(t1, 500);
                                    }
                                }

                                function t() {
                                    var ss = new Screen.Views.Main({
                                        parent: this,
                                        container: $(".container"),
                                    });

                                    ss.render();
                                    setTimeout(function () {
                                        $(".container").find(".variables-list-view").addClass("hide"); 
                                    }, 2000); 
                                }

                                t1();
                            });
                        };
                    }
                }
                , ExternalWidgets: [
                ]
                , Theme: "DZSupervision"
            });
        }); 
    });

});