define([
    'app',
    'js/templates-loader'
],

    function (app, T ) {

        var Screen = {
            Models: {}, Views: {}, Collections: {},
        };

        Screen.Models.ModalConfirmation = Backbone.Epoxy.Model.extend({
            defaults: {
                title: "Confirm",
                message: "Are you sure?",
                acceptBtnLabel: "Accept",
                cancelBtnLabel: "Cancel",
                action: "CONFIRM" // To change color of confirmation BUTTON Actions : DELETE / ADD / CONFIRM
            },
            initialize: function () {

            },
           
        });
        Screen.Views.ModalConfirmation = Backbone.Epoxy.View.extend({
            template: "modal-confirmation",
            id: "modal-confirmation",
            className: "modal modal-confirmation hide fade",
            bindings: "data-bind",
            isCacheable: true,
            events: function () {
                return {
                    "click #acceptBtn": this.acceptBtn_click,
                    "click #cancelBtn": this.cancelBtn_click,
                    "submit form": this.form_submit,
                    "keypress": this.modal_keypress,
                    "show.bs.modal": this.modal_show,
                    "shown.bs.modal": this.modal_shown,
                    "hidden.bs.modal": this.modal_hidden,
                };
            },
            container: null,
            disposed: false,
            isRendered: false,
            preventDispose: false,
            visible: false,
            data: null,
            initialize: function (options) {
                _.extend(this, options);
                if (!this.model) {
                    this.model = new Screen.Models.PrintTagConfirmation();
                }
               
                this.bus = options.bus;
                this.bindEvents();

                return this;
            },

            hide: function (preventDispose) {
                this.preventDispose = (preventDispose);

                this.$el.modal('hide');
            },
            render: function (container) {
                if (container)
                    this.container = container;

                var that = this;
                var customPath = '/app/components/' + this.template + '/';
                T.render.call(this, this.template, function (tmp) {
                    if (!that.i18n) that.i18n = {};
                    app.getI18NJed(that, that.template, function (i18nJED) {
                        that.i18n[that.template] = i18nJED;
                        that.$el.html(tmp(that.model.toJSON()));
                        that.applyBindings();

                        if (that.model.get("action") !== "CONFIRM") {
                            var acceptBtn = that.$el[0].getElementsByTagName("button").acceptBtn;
                        
                            // Remove all classes starting with "bg-" and "hover:bg-"
                            acceptBtn.classList.forEach(cls => {
                                if (cls.startsWith("hover") || cls.startsWith("bg-")) {
                                    acceptBtn.classList.remove(cls);
                                }
                            });
                        
                            // Add the new class based on action
                            switch (that.model.get("action")) {
                                case "DELETE":
                                    acceptBtn.classList.add("bg-red-600", "hover:bg-red-500");
                                    break;
                                case "ADD":
                                    acceptBtn.classList.add("bg-green-600", "hover:bg-green-500");
                                    break;
                            }
                        }
                        

                        that.isRendered = true;
                        that.trigger("render");


                    }, true, customPath);

                }, customPath, "confirmation_modal");

            },



            show: function () {
                if (!this.isRendered) {
                    this.render();
                }
                else {
                    this.$el.modal({
                        keyboard: true,
                        backdrop: 'both',
                    });
                }

                return this;
            },

            bindEvents: function () {
                this.listenToOnce(this, "render", this.view_render);
            },

            close: function () {
                if (this.disposed == false) {
                    if (this.visible == true) {
                        this.hide();
                    }
                    else {
                        this.trigger('close');

                        this.remove();
                        this.unbind();

                        this.disposed = true;
                    }
                }
            },
            preRender: function () {
                app.models.subnavbar.set("dateControl", false);
            },
            reRender: function () {
            },
            
            acceptBtn_click: function (e) {
                try {
                  this.trigger("acceptBtn", this);
                  this.close();
                }
                catch (e) { console.error((e.stack) ? e.stack : new Error(e).stack); }
            },
            cancelBtn_click: function (e) {
                try {
                  this.close();
                }
                catch (e) { console.error((e.stack) ? e.stack : new Error(e).stack); }
            },

            form_submit: function (e) {
                try {
                    e.preventDefault();
                }
                catch (e) { console.error((e.stack) ? e.stack : new Error(e).stack); }
            },
            modal_hidden: function (e) {
                try {
                    this.visible = false;

                    if (!this.preventDispose)
                        this.close();
                    else
                        this.preventDispose = false;
                }
                catch (e) { console.error((e.stack) ? e.stack : new Error(e).stack); }
            },
            modal_show: function (e) {
                try {
                    this.visible = true;
                }
                catch (e) { console.error((e.stack) ? e.stack : new Error(e).stack); }
            },
            modal_shown: function (e) {
                try {
                    this.$el.find(".autofocus").focus();
                }
                catch (e) { console.error((e.stack) ? e.stack : new Error(e).stack); }
            },
            view_render: function () {
                try {
                    //this.renderMultipicker();
                    this.show();
                }
                catch (e) { console.error((e.stack) ? e.stack : new Error(e).stack); }
            },
        });
        // Required, return the module for AMD compliance.
        return Screen;

    });