﻿/// <reference path="http://localhost/IHBOX/IndustrialDashboard/Scripts/IndustrialDashboard-debug.js" />
define([
  // Application.
  "app",  

  //templates-loader
  "js/templates-loader"

],

function (app, T) {

    var TrendingViewsDropdown = { Model: {}, Views: {} }

    TrendingViewsDropdown.init = function (ctx, module, app) {
        var customModule_tvd = new module.Views.Main({ model: new module.Model(), el: $(".trending-dropdown-container") });
    }; 

    TrendingViewsDropdown.Model = Backbone.Model.extend({
        defaults: {
            views: [],
            autorefresh: {
                toid: null
                , delay: 30000
            },
        },
        initialize: function () {
            _.bindAll(this);

            this.fetch(); 
        }, 
        fetch: function (opt) {
            var that = this; 
            var options = {
                async: true
            };

            var jsonObj = {
                views: []
            };

            Core.Json.CallProcedure(app.DatabaseNames.IH + ".dbo.GetViews", null, {
                onSuccess: function (data) {
                    var data = data.Table1;

                    jsonObj.views = data; 
                    //change method is fired.
                    that.set(that.parse(jsonObj), {});
                },
                onFailure: function () {

                },
                Async: options.async,
                //CachePerUser: true, 
            }, app.ConnectionStrings.app);

            _.defer(this.autofetch);
            return this;
        },
        autofetch: function () {
            var auto = this.get("autorefresh"); 
            if (auto.toid != null) {
                clearTimeout(auto.toid);
                auto.toid = null; 
            }

            auto.toid = setTimeout(this.fetch, auto.delay); 
        },

    });

    TrendingViewsDropdown.Views.Main = Backbone.View.extend({
        id: "trending-views-dropdown"
        , template: "trending-views-dropdown"
        , isCacheable: false
        , initialize: function () {
            this.options.MYREFERENCES = {
                screenLoading: {
                    toid: null
                }
            }; 

            _.bindAll(this);

            //binding model-view events (all models and views should be created BEFORE calling to this function
            this.bindEvents();
        },
        render: function (container) {
            var that = this;
            //var thatContainer = container;
            
            var customPath = "/app/custom-modules/trending-views-dropdown/";

            T.render.call(this, this.template, function (tmp) {
                //getInternationalizationData
                if (!that.options.i18n) that.options.i18n = {};
                app.getI18NJed(that, that.template, function (i18nJED) {
                    //storing internationalization data
                    that.options.i18n[that.template] = i18nJED;

                    //start: before the view is visible, but the template was already loaded (not instanced nor appended)

                    //end:
                    //loading the view and appeding it to the views's $el.
                    var views = that.model.get("views");

                    views = _.filter(views, function (a) {
                        if (a.Type && a.Type == "VIEWGROUP") return false;
                        else return true; 
                    }); 

                    var dot_views = _.filter(that.model.get('views'), function (a) {
                        if (a.Internal == 1 && a.Name.indexOf('DOT') != -1) {
                            views = _.filter(views, function (b) {
                                return !(b.Internal == a.Internal && b.Name == a.Name);
                            });
                            return true; 
                        }
                        return false; 
                    });

                    that.$el.html(tmp({
                        views: views,
                        dot_views: dot_views, 
                        most_used_views: views.slice(0, 5), 
                        other_views: views.slice(5, views.length),
                    }));
                    //start: the view was already loaded an is on a div element, but not appended to the main container
                    //here you can perform anything you want DOM related, by getting the dom element via that.$el.find("#id")

                    //:end

                    //appending view to the main container
                    //thatContainer.append(that.$el);
                }, true, customPath);
            }, customPath); 
        }
        , bindEvents: function () {
            this.listenTo(this.model, "change", this.render);
        }
    });

    // Required, return the module for AMD compliance.
    return TrendingViewsDropdown;

});
