﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
//@Override this is suggested by Microsoft, overriding the initialize culture function (that is
//automatically called by the aspx.
//Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
//(English).
protected override void InitializeCulture()
{
    HttpCookie lang = Request.Cookies["siteLanguage"]; 
    
    String selectedLanguage = (lang != null) ? lang.Value : "en";
    UICulture = selectedLanguage ;
    Culture = selectedLanguage ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(selectedLanguage);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(selectedLanguage);
    base.InitializeCulture();
}
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
    
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<style type="text/css">

    .main-wrapper
    {
        position:relative;
        height:auto;
        min-width:1210px;
    }

    .variables-list-container {
        position:relative;
        width:300px;
        height:97%;
        border:1px dashed #ACA7A7;
    }
    .variables-list-container .ContainerSliderContainer {
        width:100%;
        border:none;
        max-height:500px;
        overflow:auto;
    }
    .variables-list-container .Variables-ItemContainer {
        position:relative;
        margin:0;
        padding:0;
        top:0;
        left:2%;
        width:96%;
        height:30px;
        display:inline-block;
        font-size:12px;
        line-height:30px;
        overflow:hidden;
    }
    .variables-list-container .Variables-ItemContainer .Variables-Item {
        position:relative;
        margin:0;
        padding:0;
        top:0;
        left:0;
        display:inline-block;
        overflow:hidden;
        width:100%; 
    }
    .variables-list-container .Variables-ItemContainer .Variables-Item .Variables-ItemNameContainer {
        position:relative;
        float:left;
        margin:0;
        padding:0;
        top:0;
        left:0;
        display:inline-block;
        overflow:hidden;
    }
    .variables-list-container .Variables-ItemContainer .Variables-Item .Variables-ItemNameContainer .Variables-ItemName {
        position:relative;
        margin:0;
        padding:0;
        top:-1px;
        left:0;
        width:100%;
        height:100%;
        border:none;
        color:inherit;
        display:inline-block;
        font:inherit;
        overflow:hidden;
        text-align:left;
        white-space:-moz-pre; /* Mozilla */
        white-space:-hp-pre; /* HP printers */
        white-space:-o-pre; /* Opera 7 */
        white-space:-pre; /* Opera 4-6 */
        white-space:pre; /* CSS 2.1 */
        white-space:pre; /* CSS 3 (and 2.1 as well, actually) */
        word-wrap:break-word; /* IE */
        -moz-binding:url('xbl.xml#wordwrap'); /* Firefox (using XBL) */
        text-indent:4px;
        float:left;
    }
    .variables-list-container .Variables-ItemContainer .Variables-Item .Variables-ItemName {
        position:relative;
        margin:0;
        padding:0;
        top:0;
        left:0;
        width:70%;
        height:100%;
        border:none;
        color:inherit;
        display:inline-block;
        font:inherit;
        overflow:hidden;
        text-align:left;
        white-space:-moz-pre; /* Mozilla */
        white-space:-hp-pre; /* HP printers */
        white-space:-o-pre; /* Opera 7 */
        white-space:-pre; /* Opera 4-6 */
        white-space:pre; /* CSS 2.1 */
        white-space:pre; /* CSS 3 (and 2.1 as well, actually) */
        word-wrap:break-word; /* IE */
        -moz-binding:url('xbl.xml#wordwrap'); /* Firefox (using XBL) */
        text-indent:4px;
        float:left;
    }
    .variables-list-container .Variables-ItemContainer .Variables-Item .Variables-ItemNameContainer .Variables-ItemName:focus {
        border:none;
        color:#000000;
        font-weight:normal;
    }
    .variables-list-container .Variables-ItemContainer .Variables-Item .Variables-ItemNameContainer .Variables-ItemLoading 
    {
        width:16px; 
        height:16px;
        float:right;
        background-image: url("../Styles/images/mini-loader.gif"); 
        margin-top:7px;
        margin-right:4px;
        display:none;
    }
    .variables-list-container .Variables-ItemContainer .Variables-Item .Variables-ItemType { 
        position:relative;
        float:left;
        margin:0;
        padding:0;
        top:0;
        left:0;
        border:none;
        display:inline-block;
        overflow:hidden;
        text-align:left;
        white-space:-moz-pre; /* Mozilla */
        white-space:-hp-pre; /* HP printers */
        white-space:-o-pre; /* Opera 7 */
        white-space:-pre; /* Opera 4-6 */
        white-space:pre; /* CSS 2.1 */
        white-space:pre; /* CSS 3 (and 2.1 as well, actually) */
        word-wrap:break-word; /* IE */
        -moz-binding:url('xbl.xml#wordwrap'); /* Firefox (using XBL) */
    }
    .variables-list-container .Variables-ItemContainer .Variables-Item .Variables-ItemValue {
        position:relative;
        /*float:left;*/
        margin:0;
        padding:0;
        width:30%;
        top:0;
        left:0;
        display:inline-block;
        overflow:hidden;
        text-align:right;
        float:right;
    }
    .variables-list-container .Variables-ItemContainer .Variables-ItemBorder {
        border-top:1px solid #E4DCDC;
    }
    .variables-list-container .Variables-ItemContainer .Variables-ItemSelectable {
        cursor:pointer;
    }
    .variables-list-container .Variables-Adquiring {
        font-weight:bold;
    }
    .variables-list-container .Variables-Agent {
        font-weight:bold;
        /*font-size:15px;*/
    }
    .variables-list-container .Variables-AgentColor {
        color:#6C8DCA;
    }
    .variables-list-container .Variables-AgentOutlineColor:focus {
        outline-color:#6C8DCA;
    }
    .variables-list-container .Variables-DashColor {
        color:#9AC23E;
    }
    .variables-list-container .Variables-DashOutlineColor:focus {
        outline-color:#9AC23E;
    }
    .variables-list-container .Variables-DotColor {
        color:#FFA300;
    }
    .variables-list-container .Variables-DotOutlineColor:focus {
        outline-color:#FFA300;
    }
    .variables-list-container .Variables-NotActiveColor {
 	    color:#CDCDCD;
    }
    .variables-list-container .Variables-OPCColor {
        color:#F7912D;
    }
    .variables-list-container .Variables-OPCOutlineColor:focus {
        outline-color:#F7912D;
    }

    .mimic-container {
        width:100%;
        height:100%;
        background-color:transparent;
	    overflow:hidden;
    }

</style>

<script id="main_template" type="text/x-handlebars-template">

<style type="text/css">
    .ul-variables-list {

    }

    .ul-variables-list:empty{
        display:none; 
    }

    .limit-size-overflow {
        max-height:500px; 
        overflow:auto;
        border:1px dashed #ccc; 
        padding:5px;
    }

        .ul-variables-list li {
            font-size:13px;
        }

            .ul-variables-list li .apply-line-height {
                line-height:30px;
            }

        .ul-variables-list li .boldy {
            font-weight:bold;
        }

        .ul-variables-list li .hover-highlight:hover {
            background-color:#CDCDCD; 
        }

        .ul-variables-list li:hover {

        }

            .ul-variables-list li .colored {
            }

</style>

<style>

.link line {
  stroke: #696969;
}

.link line.separator {
  stroke: #fff;
  stroke-width: 2px;
}

.node {
    cursor:pointer; 
    
}

.node path{
    stroke:#696969; 
    stroke-width:1px;
}

    .node .selected {
        stroke: #f2d737; 
        stroke-width: 3px; 
    }

    .node .connected {
    }

.node circle {
  stroke: #000;
  stroke-width: 1.5px;
}

.node text {
  font: 10px sans-serif;
  pointer-events: none;
}

.overlay {
  fill: none;
  pointer-events: all;
}

</style>

<div>
    <div class="row-fluid">
        <div style="overflow:hidden;border:1px dashed #ccc;position:relative;" class="span8 graph-frame">    
            <div class="graph-container span12"></div>
            <div class="controls-container" style="width:auto;height:auto;position:absolute;right:3px;top:3px;">
                <div class="row-fluid">
                    <div class="btn-group btn-group-vertical">
                        <button title="<asp:Localize runat='server' meta:resourcekey='zoom_in_btn_title' />" type="button" class="toolbar-btn btn btn-zoom-in"><span class="fa fa-search-plus"></span></button>
                        <button title="<asp:Localize runat='server' meta:resourcekey='zoom_out_btn_title' />" type="button" class="toolbar-btn btn btn-zoom-out"><span class="fa fa-search-minus"></span></button>    
                    </div>
                </div>
                <div style="margin-top:5px;" class="row-fluid">
                    <button title="<asp:Localize runat='server' meta:resourcekey='restore_zoom_pan_btn_title' />" type="button" style="padding-right:13px;" class="toolbar-btn btn btn-restore-zoom-pan"><span class="fa fa-crosshairs"></span></button>
                </div>
                <div style="margin-top:5px;" class="row-fluid">
                    <button disabled="disabled" title="<asp:Localize runat='server' meta:resourcekey='trending_view_btn_title' />" type="button" style="padding-right:9px;" class="toolbar-btn btn btn-go-to-trending-view"><span class="fa fa-line-chart"></span></button>
                </div>
                <div style="margin-top:5px;" class="row-fluid">
                    <button title="<asp:Localize runat='server' meta:resourcekey='show_only_connected_btn_title' />" type="button" style="padding-right:15px;padding-left:15px;" class="toolbar-btn btn btn-show-only-connected"><span class="fa fa-bolt"></span></button>
                </div>
            </div>
        </div>
        <div class="span4">
            <div class="variables-list-view span12">
                <ul id="variablesListHolder" class="nav nav-list ul-variables-list limit-size-overflow"></ul>
            </div>
        </div>
    </div>
</div>

</script>

<script id="variables_list" type="text/x-handlebars-template">
    <%--<div class="span12">--%>
        {{#if AgentsList}}
        <%--<ul class="nav nav-list limit-size-overflow">--%>
            {{#each AgentsList}}
            <li>
                <div class="span12 apply-line-height boldy hover-highlight">
                    <div class="span10">
                        <div class="span2">
                            {{#ifEquals Type "OPC" }}
                            <span class="label label-info">Agent</span>
                            {{/ifEquals}}
                            {{#ifEquals Type "PLC" }}
                            <span class="label label-info">PLC</span>
                            {{/ifEquals}}
                            {{#ifEquals Type "DASH" }}
                            <span class="label label-success">DASH</span>
                            {{/ifEquals}}
                        </div>
                        <div class="span10">
                            <%--<span style="margin-left:5px;">{{Name}} ({{substringText InternalName 12 -1}})</span>--%>
                            <span style="margin-left:5px;">{{Name}}</span>
                        </div>
                    </div>
                    <div class="span2">
                        <div class="pull-right">
                            <span class="badge badge-important">#{{VariablesActiveCount}}/{{VariablesCount}}</span>
                        </div>
                    </div>
                </div>
            </li>
            {{#each AdquiringsList}}
            <li>
                <div class="span12 apply-line-height boldy hover-highlight">
                    <div class="span10">
                        <div class="span2">
                            <span class="label label-warning">{{Type}}</span>
                        </div>
                        <div class="span10">
                            {{#ifEquals Type "DOT" }}
                            <span style="margin-left:5px;">{{Name}} ({{substringText InternalName 12 -1}})</span>
                            {{else}}
                            <span style="margin-left:5px;">{{Name}}</span>
                            {{/ifEquals}}
                        </div>
                    </div>
                    <div class="pull-right">
                        <div class="span2">
                            <span class="badge badge-important">#{{VariablesActiveCount}}/{{VariablesCount}}</span>
                        </div>
                    </div>
                </div>
            </li>
            {{#each VariablesList}}
            <li>
                <div class="span12 apply-line-height hover-highlight">
                    <div class="span10">
                        <span>{{TagName}}</span>
                    </div>
                    <div class="span2">
                        <div class="pull-right">
                            <span>{{TagValue}}</span>
                        </div>
                    </div>
                </div>
            </li>
            {{/each}}
            {{/each}}
            {{/each}}
        <%--</ul>--%>
        {{/if}}
    <%--</div>--%>

</script>