﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
//@Override this is suggested by Microsoft, overriding the initialize culture function (that is
//automatically called by the aspx.
//Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
//(English).
protected override void InitializeCulture()
{
    HttpCookie lang = Request.Cookies["siteLanguage"]; 
    
    String selectedLanguage = (lang != null) ? lang.Value : "en";
    UICulture = selectedLanguage ;
    Culture = selectedLanguage ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(selectedLanguage);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(selectedLanguage);
    base.InitializeCulture();
}
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
    
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<div class="container-fluid">
    <div class="hero-unit">
        <h4><asp:Localize runat="server" meta:resourcekey="reset_to_factory_description_title" /></h4>
        <p>
            <asp:Localize runat="server" meta:resourcekey="reset_to_factory_description_part_1" />
            <br /><br />
            <asp:Localize runat="server" meta:resourcekey="reset_to_factory_description_steps_title" />
            <ul>
                <li><asp:Localize runat="server" meta:resourcekey="reset_to_factory_description_step_1" /></li>
                <li><asp:Localize runat="server" meta:resourcekey="reset_to_factory_description_step_2" /></li>
                <li><asp:Localize runat="server" meta:resourcekey="reset_to_factory_description_step_3" /></li>
                <li><asp:Localize runat="server" meta:resourcekey="reset_to_factory_description_step_4" /></li>
            </ul>
        </p>
        <br />
        <p class="text-center">
            <button <% if (WebApp.IsDemo()){ %> disabled="disabled" <% } %> id="reset_to_factory_defaults_btn" class="btn btn-primary btn-large">
                <asp:Localize runat="server" meta:resourcekey="reset_to_factory_defaults_btn_label" />
            </button>
        </p>
    </div>
    
    <script id="reset_to_factory_loading_modal_template" type="text/x-handlebars-template">
        <span style="float:left;font-size:16px;top:6px;position:relative;">
            <asp:Localize runat="server" meta:resourcekey="starting_reset_to_factory_defaults_process" />
        </span>
        <div style="height:31px;cursor:default;margin-left:15px;position:relative;float:left;width:30px;"><img style="width:30px;height:30px;" src="<%= ResolveUrl("~/assets/img/spinner22.gif") %>" /></div>
    </script>
</div>