USE [IHBoxSystem]
GO

USE [IHBoxSystem]
GO
CREATE ROLE caster_log_book_by_shift_read AUTHORIZATION dbo 
GO  

USE [IHBoxSystem]
GO
CREATE ROLE caster_log_book_by_shift_readWrite AUTHORIZATION dbo 
GO  




USE [IHBoxSystem]
GO
EXEC sp_addrolemember 'caster_log_book_by_shift_read', 'SDI/australtek'
GO

USE [IHBoxSystem]
GO
EXEC sp_addrolemember 'caster_log_book_by_shift_readWrite', 'SDI/australtek'
GO

USE [IHBoxSystem]
GO
EXEC sp_addrolemember 'caster_log_book_by_shift_read', 'admin'
GO

USE [IHBoxSystem]
GO
EXEC sp_addrolemember 'caster_log_book_by_shift_readWrite', 'admin'
GO



INSERT INTO [FrontEnd].[Routes]
           ([Route]
           ,[ModuleName]
           ,[ModulePath]
           ,[RequiredRole]
       )
     VALUES
           (
		   '!/caster-log-book-by-shift(/:productionDate)(/:shiftId)'
           , 'caster-log-book-by-shift'
		   , 'custom-screens/caster-log-book-by-shift/'
           , 'caster_log_book_by_shift_read'
           
		   )



INSERT INTO [FrontEnd].[Menu]
           ([Parent]
           ,[Name]
           ,[RouteID]
           ,[SortOrder]
           ,[Enabled]
           ,[Visible]
           ,[RequiredRole]
           ,[Group]
          )
     VALUES
           (
		   (select top 1 Id from FrontEnd.menu where Name = 'Caster' and Parent is null)
		   ,'Log Book By Shift'
           ,@@IDENTITY
           ,(select Max(SortOrder)+1 from FrontEnd.Menu where Parent = (select Id from frontend.Menu where [Name] = 'Caster'))
           ,1
           ,1
           ,'caster_log_book_by_shift_read'
           ,NULL
         )
GO

/*------------------------------------------------------Profiles------------------------------------------------------*/

	USE [IHBoxSystem]
	GO

	DECLARE @ModuleId INT

	INSERT INTO [SECURITY].[Modules]([Code],[Name])
	VALUES('caster_log_book_by_shift','Caster Log Book By Shift')

	SET @ModuleId = @@IDENTITY

	INSERT INTO [SECURITY].[ModuleActions]([ModuleId],[Code],[Name],[Role])
	VALUES(@ModuleId,'readWrite','Read/Write','caster_log_book_by_shift_readWrite')


	INSERT INTO [SECURITY].ModuleActions(ModuleId,Code,[Name],[Role])
	VALUES (@ModuleId,'read','Read','caster_log_book_by_shift_read')




/*------------------------------------------------------SP Permissions------------------------------------------------------*/

EXECUTE sys.sp_addextendedproperty 
@level0type = N'USER' -- The object type
,@level0name = [caster_log_book_by_shift_read] -- The role
,@name = N'securedsp-LB.GetLogBookByShift' -- the procedure
,@value = N'' 
GO

EXECUTE sys.sp_addextendedproperty 
@level0type = N'USER' -- The object type
,@level0name = [caster_log_book_by_shift_read] -- The role
,@name = N'securedsp-LB.GetLogBookByShiftCatalogs' -- the procedure
,@value = N'' 
GO


EXECUTE sys.sp_addextendedproperty 
@level0type = N'USER' -- The object type
,@level0name = [caster_log_book_by_shift_readWrite] -- The role
,@name = N'securedsp-LB.UpsertEntry' -- the procedure
,@value = N'SendCurrentUser=TRUE' 
GO

EXECUTE sys.sp_addextendedproperty 
@level0type = N'USER' -- The object type
,@level0name = [caster_log_book_by_shift_readWrite] -- The role
,@name = N'securedsp-LB.DeleteLogEntry' -- the procedure
,@value = N'SendCurrentUser=TRUE' 
GO




