USE [IHBoxSystem]
GO
CREATE ROLE labchemistrysamples_readWrite AUTHORIZATION dbo 
GO  

USE [IHBoxSystem]
GO
EXEC sp_addrolemember 'labchemistrysamples_readWrite', 'admin'
GO

USE [IHBoxSystem]
GO
EXEC sp_addrolemember 'labchemistrysamples_readWrite', 'SDI/australtek'
GO

EXECUTE sys.sp_addextendedproperty 
@level0type = N'USER' -- The object type
,@level0name = [labchemistrysamples_readWrite] -- The role
,@name = N'securedsp-LAB.GetChemistrySamplesCatalogs' -- the procedure
,@value = N'' 
GO

EXECUTE sys.sp_addextendedproperty 
@level0type = N'USER' -- The object type
,@level0name = [labchemistrysamples_readWrite] -- The role
,@name = N'securedsp-LAB.GetChemistrySamplesReport' -- the procedure
,@value = N'' 
GO


declare @parent int, @result_routeId INT
select @parent=id from [FrontEnd].[Menu] where name='LAB'

INSERT INTO [FrontEnd].[Routes]
		   ([Route]
		   ,[ModuleName]
		   ,[ModulePath]
		   ,[RequiredRole]
	   )
	 VALUES
		   (
		   '!/chemistry-samples-report(/:heatName)(/)'
		   , 'chemistry-samples-report'
		   , 'custom-screens/chemistry-samples-report/'
		   , 'labchemistrysamples_readWrite'           
		   )
		   SET @result_routeId = @@IDENTITY
INSERT INTO [FrontEnd].[Menu]
		   ([Parent]
		   ,[Name]
		   ,[RouteID]
		   ,[SortOrder]
		   ,[Enabled]
		   ,[Visible]
		   ,[RequiredRole]
		   ,[Group]
		  )
	 VALUES
		   (
		   @parent
		   ,'Chemistry Samples'
		   ,@result_routeId 
		   ,1
		   ,1
		   ,1
		   ,'labchemistrysamples_readWrite'
		   ,NULL
		 )
GO

/*------------------------------------------------------Profiles------------------------------------------------------*/
USE [IHBoxSystem]
GO

DECLARE @ModuleId INT

INSERT INTO [SECURITY].[Modules]
		   ([Code]
		   ,[Name])
	 VALUES
		   ('lab_chemistry_samples_report'
		   ,'Chemistry Samples')

		  SET @ModuleId = @@IDENTITY

INSERT INTO [SECURITY].[ModuleActions]
		   ([ModuleId]
		   ,[Code]
		   ,[Name]
		   ,[Role])
	 VALUES
		   (@ModuleId
		   ,'readWrite'
		   ,'Read/Write'
		   ,'labchemistrysamples_readWrite')
GO

/*---------------------------------------------------------------------------------------------------------------------------------------------*/
USE [MES]
GO
/****** Object:  StoredProcedure [LAB].[GetChemistrySamplesReport]    Script Date: 7 ago. 2020 10:05:32 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
ALTER PROCEDURE [LAB].[GetChemistrySamplesReport]
	@heatId INT = NULL,
	@direction BIT = NULL,
	@ladleFurnaceCode INT = NULL,
	@timeZoneCode CHAR(10) = NULL
AS
BEGIN
	-----------------------
	-- Common procedures variables
	-----------------------
	DECLARE 
		--Start of the message to be printed at the end of the procedure.
		@finishEndMSG VARCHAR(300),
		--The name of the procedure with its schema.
		@procName VARCHAR(300)

	SET @procName = OBJECT_SCHEMA_NAME(@@PROCID) + '.' + OBJECT_NAME(@@PROCID)
	
	SET @finishEndMSG =  @procName + ' finished.'

	PRINT @procName + ' Parameters:'
		+ ', @heatId: ' + ISNULL(CAST(@heatId AS VARCHAR), '')
		+ ', @direction: ' + ISNULL(CAST(@direction AS VARCHAR), '')
		+ ', @ladleFurnaceCode: ' + ISNULL(CAST(@ladleFurnaceCode AS VARCHAR), '')
		+ ', @timeZoneCode: ' + ISNULL(CAST(@timeZoneCode AS VARCHAR), '')

		
	-----------------------
	-- Variables
	-----------------------
	--Navigate Buttons
	declare @buttons table ([Text] VARCHAR(50), HeatId INT, Treatment INT)

	--Navigation
	DECLARE @newHeatId INT,
			@start DATETIME

	
	-----------------------
	-- Validation
	-----------------------
	IF (@timeZoneCode IS NULL)	SET @timeZoneCode = 'EDTIND'

	-----------------------
	-- Navigation
	-----------------------
	IF (@direction IS NOT NULL)
	BEGIN
		if (@direction = 1)
			SET @start = (SELECT TOP 1 [Timestamp] FROM LAB.ChemistrySamplesWithCalculated WHERE HeatId = @heatId ORDER BY [Timestamp] DESC)
		if (@direction = 0)
			SET @start = (SELECT TOP 1 [Timestamp] FROM LAB.ChemistrySamplesWithCalculated WHERE HeatId = @heatId ORDER BY [Timestamp] ASC)

		print @start
		SET @newHeatId = CASE 
						WHEN (@direction = 1) THEN
								(SELECT TOP 1 l.HeatId 
									FROM LAB.ChemistrySamplesWithCalculated l
									left join eaf.Processes p on p.HeatId = l.HeatId
									WHERE l.[Timestamp] >= @start and l.HeatId <> @heatId
									AND (@ladleFurnaceCode IS NULL OR p.FurnaceCode = @ladleFurnaceCode) 
									ORDER BY l.[Timestamp] ASC
								)
						WHEN (@direction = 0) THEN
								(SELECT TOP 1 l.HeatId 
									FROM LAB.ChemistrySamplesWithCalculated l
									left join eaf.Processes p on p.HeatId = l.HeatId
									WHERE l.[Timestamp] <= @start and l.HeatId <> @heatId
									AND (@ladleFurnaceCode IS NULL OR p.FurnaceCode = @ladleFurnaceCode)  
									ORDER BY l.[Timestamp] DESC
								)
					END
		print @newHeatId
		IF (@newHeatId) IS NOT NULL 
			SET @heatId =@newHeatId
	END



	-----------------------
	-- Begin Query
	-----------------------
	SELECT 
		record.*,
		LocalTimestamp = IH.ToLocal(record.[Timestamp], @timeZoneCode),
		GradeId = heat.gradeId,
		GradeName = grade.[Name],
		HeatName = heat.[Name]
	FROM LAB.ChemistrySamplesWithCalculated record
		LEFT JOIN MES.Heats heat ON heat.Id = record.HeatId
		LEFT JOIN CAT.Grades grade ON grade.Id = heat.GradeId
	WHERE record.HeatId = @heatId
		

		-----------------------
		-- Navigate Buttons
		-----------------------
		
		select top 5 [Text]= 'LMF', Treatment = p.Treatment, HeatName = h.[Name], HeatId = h.Id 
		from LF.Processes p 
		left join mes.Heats h on h.Id = p.HeatId
		where p.HeatId = @heatId

		union all
		
		select top 5 [Text]= 'VTD', Treatment = p.Treatment, HeatName = h.[Name], HeatId = h.Id
		from VTD.Processes p 
		left join mes.Heats h on h.Id = p.HeatId
		where p.HeatId = @heatId

		union all
		
		select top 5 [Text]= 'EAF', Treatment = null, HeatName = h.[Name], HeatId = h.Id
		from EAF.Processes p 
		left join mes.Heats h on h.Id = p.HeatId
		where p.HeatId = @heatId
		
		union all
		
		select top 5 [Text]= 'SLAG EAF', Treatment = null, HeatName = h.[Name], HeatId = h.Id
		from LAB.SlagChemistrySamples l
		left join mes.Heats h on h.Id = l.HeatId
		where l.HeatId = @heatId

	-----------------------
	-- Finish procedure
	-----------------------
	PRINT @finishEndMSG

	RETURN 0
END

GO
/*---------------------------------------------------------------------------------------------------------------------------------------------*/
USE [MES]
GO
/****** Object:  StoredProcedure [LAB].[GetChemistrySamplesCatalogs]    Script Date: 7 ago. 2020 11:46:08 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
ALTER PROCEDURE [LAB].[GetChemistrySamplesCatalogs]
 	@heatName VARCHAR(50) = NULL
AS
BEGIN
	-----------------------
	-- Common procedures variables
	-----------------------
	DECLARE 
		--Start of the message to be printed at the end of the procedure.
		@finishEndMSG VARCHAR(300),
		--The name of the procedure with its schema.
		@procName VARCHAR(300)

	SET @procName = OBJECT_SCHEMA_NAME(@@PROCID) + '.' + OBJECT_NAME(@@PROCID)
	
	SET @finishEndMSG =  @procName + ' finished.'

	PRINT @procName + ' Parameters:'
		+ ', @heatName: ' + ISNULL(CAST(@heatName AS VARCHAR), '')

	-----------------------
	-- Begin Query
	-----------------------
	IF (@heatName IS NOT NULL)

	SELECT DISTINCT
		[Name] = h.[Name]
		,[HeatId] = h.Id
	FROM MES.Heats h 
	LEFT JOIN LAB.ChemistrySamplesWithCalculated s on s.HeatId = h.Id
	WHERE h.[Name] LIKE '%' + @heatName + '%'
	
	ELSE
		SELECT TOP 1
			[Name] = h.[Name]
			,[HeatId] = h.Id
		FROM LAB.ChemistrySamplesWithCalculated s
		LEFT JOIN MES.Heats h on s.HeatId = h.Id
		ORDER BY s.[Timestamp] DESC

	-----------------------
	-- Finish procedure
	-----------------------
	PRINT @finishEndMSG

	RETURN 0
END
GO



/*------------------------------------------------- 13 Feb-----------------------------------------------------------*/
USE [MES]
GO
/****** Object:  UserDefinedFunction [EAF].[GetTapTagId]    Script Date: 14 feb. 2021 17:47:29 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
ALTER FUNCTION [LAB].[GetGradeSpecsLimit]
(
	@gradeId int,
	@gradeVersionId int,
	@elementCode char(10),
	@limitType char(3)
)
RETURNS decimal(18,2)
AS
BEGIN
		declare @value float

		select 
			@value = (
			case when @limitType = 'MAX' then cat.[Max] when @limitType = 'MIN' then cat.[Min]
				when  @limitType = 'AIM' then cat.[Aim] end
		)
		FROM CAT.GradeSpecs cat
		JOIN CAT.GradeVersions gradeVersion ON gradeVersion.Id = cat.GradeVersionId
		JOIN CAT.Grades gr ON gr.Id = gradeVersion.GradeId
		WHERE gr.Id = @gradeId and cat.GradeVersionId = @gradeVersionId and ElementCode = @elementCode

		return  cast(@value as decimal(18,3))
END

GO

USE [MES]
GO
/****** Object:  StoredProcedure [LAB].[GetChemistrySamplesReport]    Script Date: 14 feb. 2021 16:26:18 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
ALTER PROCEDURE [LAB].[GetChemistrySamplesReport]
	@heatId INT = NULL,
	@direction BIT = NULL,
	@ladleFurnaceCode INT = NULL,
	@timeZoneCode CHAR(10) = NULL
AS
BEGIN
	-----------------------
	-- Common procedures variables
	-----------------------
	DECLARE 
		--Start of the message to be printed at the end of the procedure.
		@finishEndMSG VARCHAR(300),
		--The name of the procedure with its schema.
		@procName VARCHAR(300)

	SET @procName = OBJECT_SCHEMA_NAME(@@PROCID) + '.' + OBJECT_NAME(@@PROCID)
	
	SET @finishEndMSG =  @procName + ' finished.'

	PRINT @procName + ' Parameters:'
		+ ', @heatId: ' + ISNULL(CAST(@heatId AS VARCHAR), '')
		+ ', @direction: ' + ISNULL(CAST(@direction AS VARCHAR), '')
		+ ', @ladleFurnaceCode: ' + ISNULL(CAST(@ladleFurnaceCode AS VARCHAR), '')
		+ ', @timeZoneCode: ' + ISNULL(CAST(@timeZoneCode AS VARCHAR), '')

		
	-----------------------
	-- Variables
	-----------------------
	--Navigate Buttons
	declare @buttons table ([Text] VARCHAR(50), HeatId INT, Treatment INT)

	--Navigation
	DECLARE @newHeatId INT,
			@start DATETIME

	
	-----------------------
	-- Validation
	-----------------------
	IF (@timeZoneCode IS NULL)	SET @timeZoneCode = 'EDTIND'

	-----------------------
	-- Navigation
	-----------------------
	IF (@direction IS NOT NULL)
	BEGIN
		if (@direction = 1)
			SET @start = (SELECT TOP 1 [Timestamp] FROM LAB.ChemistrySamplesWithCalculated WHERE HeatId = @heatId ORDER BY [Timestamp] DESC)
		if (@direction = 0)
			SET @start = (SELECT TOP 1 [Timestamp] FROM LAB.ChemistrySamplesWithCalculated WHERE HeatId = @heatId ORDER BY [Timestamp] ASC)

		print @start
		SET @newHeatId = CASE 
						WHEN (@direction = 1) THEN
								(SELECT TOP 1 l.HeatId 
									FROM LAB.ChemistrySamplesWithCalculated l
									left join eaf.Processes p on p.HeatId = l.HeatId
									WHERE l.[Timestamp] >= @start and l.HeatId <> @heatId
									AND (@ladleFurnaceCode IS NULL OR p.FurnaceCode = @ladleFurnaceCode) 
									ORDER BY l.[Timestamp] ASC
								)
						WHEN (@direction = 0) THEN
								(SELECT TOP 1 l.HeatId 
									FROM LAB.ChemistrySamplesWithCalculated l
									left join eaf.Processes p on p.HeatId = l.HeatId
									WHERE l.[Timestamp] <= @start and l.HeatId <> @heatId
									AND (@ladleFurnaceCode IS NULL OR p.FurnaceCode = @ladleFurnaceCode)  
									ORDER BY l.[Timestamp] DESC
								)
					END
		print @newHeatId
		IF (@newHeatId) IS NOT NULL 
			SET @heatId =@newHeatId
	END



	-----------------------
	-- Begin Query
	-----------------------
	SELECT 
		record.*
		,LocalTimestamp = IH.ToLocal(record.[Timestamp], @timeZoneCode)
		,GradeId = heat.gradeId
		,GradeName = grade.[Name]
		,HeatName = heat.[Name]
		

		,MinAl		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Al','MIN')               
		,MinAs		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'As','MIN')               
		,MinB		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'B ','MIN')                
		,MinBi		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Bi','MIN')               
		,MinC		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'C','MIN')                
		,MinC8		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'C8','MIN')               
		,MinCE		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'CE','MIN')               
		,MinCE1		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'CE1','MIN')              
		,MinCE2		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'CE2','MIN')              
		,MinCE3		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'CE3','MIN')              
		,MinCa		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Ca','MIN')               
		,MinCb		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Cb','MIN')               
		,MinCo		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Co','MIN')                
		,MinCorrIdx	= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'CorrIdx','MIN')         
		,MinCr		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Cr','MIN')               
		,MinCu		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Cu','MIN')               
		,MinD1		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'D1','MIN')               
		,MinDI		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'DI','MIN')               
		,MinE1		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'E1','MIN')               
		,MinE8		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'E8','MIN')               
		,MinFP		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'FP','MIN')               
		,MinFe		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Fe','MIN')              
		,MinI		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'I ','MIN')                
		,MinId		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Id','MIN')               
		,MinLiq		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Liq','MIN')              
		,MinM2		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'M2','MIN')               
		,MinMg		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Mg','MIN')               
		,MinMn		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Mn','MIN')               
		,MinMn2S	= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Mn2S','MIN')             
		,MinMo		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Mo','MIN')               
		,MinN		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'N','MIN')                
		,MinNb		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Nb','MIN')               
		,MinNi		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Ni','MIN')               
		,MinP		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'P','MIN')                
		,MinPC		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'PC','MIN')               
		,MinPb		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Pb','MIN')               
		,MinS		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'S','MIN')                
		,MinS1		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'S1','MIN')               
		,MinS2		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'S2','MIN')               
		,MinS3		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'S3','MIN')               
		,MinS4		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'S4','MIN')               
		,MinS5		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'S5','MIN')               
		,MinSb		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Sb','MIN')               
		,MinSe		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Se','MIN')               
		,MinSi		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Si','MIN')               
		,MinSn		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Sn','MIN')               
		,MinTa		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Ta','MIN')               
		,MinTe		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Te','MIN')               
		,MinTi		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Ti','MIN')               
		,MinV		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'V','MIN')                
		,MinW		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'W','MIN')                
		,MinZn		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Zn','MIN')               
		,MinZr		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Zr','MIN')

		,MaxAl		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Al','MAX')               
		,MaxAs		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'As','MAX')               
		,MaxB		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'B ','MAX')                
		,MaxBi		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Bi','MAX')               
		,MaxC		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'C','MAX')                
		,MaxC8		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'C8','MAX')               
		,MaxCE		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'CE','MAX')               
		,MaxCE1		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'CE1','MAX')              
		,MaxCE2		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'CE2','MAX')              
		,MaxCE3		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'CE3','MAX')              
		,MaxCa		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Ca','MAX')               
		,MaxCb		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Cb','MAX')               
		,MaxCo		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Co','MAX')                
		,MaxCorrIdx	= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'CorrIdx','MAX')         
		,MaxCr		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Cr','MAX')               
		,MaxCu		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Cu','MAX')               
		,MaxD1		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'D1','MAX')               
		,MaxDI		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'DI','MAX')               
		,MaxE1		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'E1','MAX')               
		,MaxE8		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'E8','MAX')               
		,MaxFP		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'FP','MAX')               
		,MaxFe		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Fe','MAX')              
		,MaxI		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'I ','MAX')                
		,MaxId		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Id','MAX')               
		,MaxLiq		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Liq','MAX')              
		,MaxM2		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'M2','MAX')               
		,MaxMg		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Mg','MAX')               
		,MaxMn		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Mn','MAX')               
		,MaxMn2S	= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Mn2S','MAX')             
		,MaxMo		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Mo','MAX')               
		,MaxN		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'N','MAX')                
		,MaxNb		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Nb','MAX')               
		,MaxNi		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Ni','MAX')               
		,MaxP		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'P','MAX')                
		,MaxPC		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'PC','MAX')               
		,MaxPb		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Pb','MAX')               
		,MaxS		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'S','MAX')                
		,MaxS1		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'S1','MAX')               
		,MaxS2		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'S2','MAX')               
		,MaxS3		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'S3','MAX')               
		,MaxS4		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'S4','MAX')               
		,MaxS5		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'S5','MAX')               
		,MaxSb		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Sb','MAX')               
		,MaxSe		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Se','MAX')               
		,MaxSi		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Si','MAX')               
		,MaxSn		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Sn','MAX')               
		,MaxTa		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Ta','MAX')               
		,MaxTe		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Te','MAX')               
		,MaxTi		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Ti','MAX')               
		,MaxV		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'V','MAX')                
		,MaxW		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'W','MAX')                
		,MaxZn		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Zn','MAX')               
		,MaxZr		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Zr','MAX')  

		,AimAl		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Al','AIM')               
		,AimAs		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'As','AIM')               
		,AimB		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'B ','AIM')                
		,AimBi		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Bi','AIM')               
		,AimC		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'C','AIM')                
		,AimC8		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'C8','AIM')               
		,AimCE		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'CE','AIM')               
		,AimCE1		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'CE1','AIM')              
		,AimCE2		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'CE2','AIM')              
		,AimCE3		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'CE3','AIM')              
		,AimCa		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Ca','AIM')               
		,AimCb		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Cb','AIM')               
		,AimCo		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Co','AIM')                
		,AimCorrIdx	= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'CorrIdx','AIM')         
		,AimCr		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Cr','AIM')               
		,AimCu		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Cu','AIM')               
		,AimD1		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'D1','AIM')               
		,AimDI		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'DI','AIM')               
		,AimE1		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'E1','AIM')               
		,AimE8		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'E8','AIM')               
		,AimFP		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'FP','AIM')               
		,AimFe		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Fe','AIM')              
		,AimI		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'I ','AIM')                
		,AimId		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Id','AIM')               
		,AimLiq		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Liq','AIM')              
		,AimM2		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'M2','AIM')               
		,AimMg		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Mg','AIM')               
		,AimMn		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Mn','AIM')               
		,AimMn2S	= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Mn2S','AIM')             
		,AimMo		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Mo','AIM')               
		,AimN		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'N','AIM')                
		,AimNb		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Nb','AIM')               
		,AimNi		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Ni','AIM')               
		,AimP		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'P','AIM')                
		,AimPC		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'PC','AIM')               
		,AimPb		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Pb','AIM')               
		,AimS		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'S','AIM')                
		,AimS1		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'S1','AIM')               
		,AimS2		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'S2','AIM')               
		,AimS3		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'S3','AIM')               
		,AimS4		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'S4','AIM')               
		,AimS5		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'S5','AIM')               
		,AimSb		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Sb','AIM')               
		,AimSe		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Se','AIM')               
		,AimSi		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Si','AIM')               
		,AimSn		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Sn','AIM')               
		,AimTa		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Ta','AIM')               
		,AimTe		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Te','AIM')               
		,AimTi		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Ti','AIM')               
		,AimV		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'V','AIM')                
		,AimW		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'W','AIM')                
		,AimZn		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Zn','AIM')               
		,AimZr		= [LAB].[GetGradeSpecsLimit](grade.Id,record.GradeVersionId,'Zr','AIM')  


	FROM LAB.ChemistrySamplesWithCalculated record
		LEFT JOIN MES.Heats heat ON heat.Id = record.HeatId
		LEFT JOIN CAT.Grades grade ON grade.Id = heat.GradeId

	WHERE record.HeatId = @heatId
	

		-----------------------
		-- Navigate Buttons
		-----------------------
		
		select top 5 [Text]= 'EAF', Treatment = null, HeatName = h.[Name], HeatId = h.Id
		from EAF.Processes p 
		left join mes.Heats h on h.Id = p.HeatId
		where p.HeatId = @heatId
		
		union all
		
		select top 5 [Text]= 'LMF', Treatment = p.Treatment, HeatName = h.[Name], HeatId = h.Id 
		from LF.Processes p 
		left join mes.Heats h on h.Id = p.HeatId
		where p.HeatId = @heatId

		union all
		
		select top 5 [Text]= 'VTD', Treatment = p.Treatment, HeatName = h.[Name], HeatId = h.Id
		from VTD.Processes p 
		left join mes.Heats h on h.Id = p.HeatId
		where p.HeatId = @heatId

		union all
				
		select top 5 [Text]= 'SLAG EAF', Treatment = null, HeatName = h.[Name], HeatId = h.Id
		from LAB.SlagChemistrySamples l
		left join mes.Heats h on h.Id = l.HeatId
		where l.HeatId = @heatId

	-----------------------
	-- Finish procedure
	-----------------------
	PRINT @finishEndMSG

	RETURN 0
END

GO