﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>

<script runat="server">
    //@Override this is suggested by Microsoft, overriding the initialize culture function (that is
    //automatically called by the aspx.
    //Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
    //(English).
    protected override void InitializeCulture()
    {
   
        HttpCookie lang = Request.Cookies["siteLanguage"];

        String selectedLanguage = (lang != null) ? lang.Value : "en";
        UICulture = selectedLanguage;
        Culture = selectedLanguage;

        Thread.CurrentThread.CurrentCulture =
            CultureInfo.CreateSpecificCulture(selectedLanguage);
        Thread.CurrentThread.CurrentUICulture = new
            CultureInfo(selectedLanguage);
        base.InitializeCulture();
    }
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
 
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<%--<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css") %>" rel="stylesheet" />--%>
<link href="<%= ResolveUrl("~/app/custom-screens/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + ".css")%>" rel="stylesheet" />


<%-- SOURCE CODE IDEA --%>
<%--https://medium.com/@Idan_Co/the-ultimate-print-html-template-with-header-footer-568f415f6d2a--%>
<%--https://plnkr.co/edit/lWk6Yd?preview--%>


<%-- PDF --%>
<div class="print">
    <div id="pageborder"></div>
    <div class="contentborder"></div>
    <div class="screen-content">

        <div class="page-header" style="text-align: center">
            <div class="img-logo">
                <img src='<%= ResolveUrl("~/app/custom-screens/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" +"sdi-logo.svg") %>' />
            </div>
            <div class="sdi-company-name">               
                <img src='<%= ResolveUrl("~/app/custom-screens/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" +"sdi.svg") %>' class="img-company-name"/>
            </div>
            <div class="sdi-division">               
                <img src='<%= ResolveUrl("~/app/custom-screens/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" +"sdi-division.svg") %>' class="img-sdi-division"/>
            </div>

            <div class="report-name-container">                
                <span class="report-name">EAF Shift Report</span>             
            </div>
            <div class="line-division-top"></div>
            <div class="shift-container">        
               <span class="shift-name" id="shift-name"></span>
            </div>
    
            <div class="line-division-bottom"></div>
        </div>

      <%--  <div class="page-footer">
   
        </div>--%>

        <table style="width:100%">

            <thead>
                <tr>
                    <td>
                        <div class="page-header-space"></div>
                    </td>
                </tr>
            </thead>

            <tbody>
                <tr>
                    <td>
                    <div class="page first-page">

                       
                        <div class="main-info">
                            <table class="totals-and-averages EAF-averages-chart-print">
                            <tr>
                                <th class="big-empty-column"></th>
                                <th class="not-border" ></th>
                                <th class="top-categories">EAF A</th>
                                <th class="top-categories">EAF B</th>
                                <th class="top-categories">TOTAL | AVG</th>
                                <th class="not-border small-empty-column"></th>
                                <th class="not-border" ></th>
                                <th class="top-categories">EAF A</th>
                                <th class="top-categories">EAF B</th>
                                <th class="top-categories">TOTAL | AVG</th>
                                <th class="big-empty-column"></th>
                            </tr>
                            <tr>
                                <th class="big-empty-column"></th>
                                <td class="left-categories">Total Heats</td>
                                <td class="totals-and-averages-values"><span data-bind="text:EAF_A_TotalHeats"></span></td>
                                <td class="totals-and-averages-values"><span data-bind="text:EAF_B_TotalHeats"></span></td>
                                <td class="totals-and-averages-values"><span data-bind="text:TOTAL_TotalHeats"></span></td>
                                <td class="not-border small-empty-column"></td>
                                <td class="left-categories">Total MWH</td>
                                <td class="totals-and-averages-values"><span data-bind="text:EAF_A_TotalElectricEnergy"></span></td>
                                <td class="totals-and-averages-values"><span data-bind="text:EAF_B_TotalElectricEnergy"></span></td>
                                <td class="totals-and-averages-values"><span data-bind="text:TOTAL_TotalElectricEnergy"></span></td>
                                <th class="big-empty-column"></th>
                            </tr>
                            <tr>
                                <th class="big-empty-column"></th>
                                <td class="left-categories">Tot Steel Weight</td>
                                <td class="totals-and-averages-values"><span data-bind="text:EAF_A_TotalSteelWeight"></span></td>
                                <td class="totals-and-averages-values"><span data-bind="text:EAF_B_TotalSteelWeight"></span></td>
                                <td class="totals-and-averages-values"><span data-bind="text:TOTAL_TotalSteelWeight"></span></td>
                                <td class="not-border small-empty-column"></td>
                                <td class="left-categories">Electrode Adds</td>
                                <td class="totals-and-averages-values"><span data-bind="text:EAF_A_TotalElectrodeAdds"></span></td>
                                <td class="totals-and-averages-values"><span data-bind="text:EAF_B_TotalElectrodeAdds"></span></td>
                                <td class="totals-and-averages-values"><span data-bind="text:TOTAL_TotalElectrodeAdds"></span></td>
                                <th class="big-empty-column"></th>
                            </tr>
                            <tr>
                                <th class="big-empty-column"></th>
                                <td class="left-categories">Tot Scrap Weight</td>
                                <td class="totals-and-averages-values"><span data-bind="text:EAF_A_TotalScrapWeight"></span></td>
                                <td class="totals-and-averages-values"><span data-bind="text:EAF_B_TotalScrapWeight"></span></td>
                                <td class="totals-and-averages-values"><span data-bind="text:TOTAL_TotalScrapWeight"></span></td>
                                <td class="not-border small-empty-column"></td>
                                <td class="left-categories">Electrode Cons</td>
                                <td class="totals-and-averages-values"><span>-</span></td>
                                <td class="totals-and-averages-values"><span>-</span></td>
                                <td class="totals-and-averages-values"><span>-</span></td>
                                <th class="big-empty-column"></th>
                            </tr>
                            <tr>
                                <th class="big-empty-column"></th>
                                <td class="left-categories">Steel Weight</td>
                                <td class="totals-and-averages-values"><span data-bind="text:EAF_A_SteelWeight"></span></td>
                                <td class="totals-and-averages-values"><span data-bind="text:EAF_B_SteelWeight"></span></td>
                                <td class="totals-and-averages-values"><span data-bind="text:SteelWeightConcat"></span></td>
                                <td class="not-border small-empty-column"></td>
                                <td class="left-categories">Spray Ring Effectiveness</td>
                                <td class="totals-and-averages-values"><span data-bind="text:EAFASprayRingEffectiveness"></span></td>
                                <td class="totals-and-averages-values"><span data-bind="text:EAFBSprayRingEffectiveness"></span></td>
                                <td class="totals-and-averages-values">-</td>
                                <th class="big-empty-column"></th>
                      
                   
                            </tr>
                            <tr>
                                <th class="big-empty-column"></th>
                                <td class="left-categories">Scrap Weight</td>
                                <td class="totals-and-averages-values"><span data-bind="text:EAF_A_ScrapWeight"></span></td>
                                <td class="totals-and-averages-values"><span data-bind="text:EAF_B_ScrapWeight"></span></td>
                                <td class="totals-and-averages-values"><span data-bind="text:ScrapWeightConcat"></span></td>
                                <td class="not-border small-empty-column"></td>
                                <td class="left-categories">KWH/Ton</td>
                                <td class="totals-and-averages-values"><span data-bind="text:EAF_A_SpecificEnergy"></span></td>
                                <td class="totals-and-averages-values"><span data-bind="text:EAF_B_SpecificEnergy"></span></td>
                                <td class="totals-and-averages-values"><span data-bind="text:SpecificEnergyConcat"></span></td>
                                <th class="big-empty-column"></th>
                                 
                   
                            </tr>
                            <tr>
                                <th class="big-empty-column"></th>
                                <td class="left-categories">Yield (%)</td>
                                <td class="totals-and-averages-values"><span data-bind="text:EAF_A_Yield"></span></td>
                                <td class="totals-and-averages-values"><span data-bind="text:EAF_B_Yield"></span></td>
                                <td class="totals-and-averages-values"><span data-bind="text:YieldConcat"></span></td>
                                <td class="not-border small-empty-column"></td>
                                <td class="left-categories">Electric Power</td>
                                <td class="totals-and-averages-values"><span data-bind="text:EAF_A_ElectricPower"></span></td>
                                <td class="totals-and-averages-values"><span data-bind="text:EAF_B_ElectricPower"></span></td>
                                <td class="totals-and-averages-values"><span data-bind="text:TOTAL_ElectricPower"></span></td>
                                <th class="big-empty-column"></th>
                                
                  
                            </tr>
                            <tr>
                                <th class="big-empty-column"></th>
                                <td class="left-categories">Tap To Tap</td>
                                <td class="totals-and-averages-values"><span data-bind="text:EAF_A_TapToTap"></span></td>
                                <td class="totals-and-averages-values"><span data-bind="text:EAF_B_TapToTap"></span></td>
                                <td class="totals-and-averages-values"><span data-bind="text:TapToTapConcat"></span></td>
                                <td class="not-border small-empty-column"></td>
                                <td class="left-categories">Smart Furnace</td>
                                <td class="totals-and-averages-values"><span data-bind="text:EAF_A_SmartARC"></span></td>
                                <td class="totals-and-averages-values"><span data-bind="text:EAF_B_SmartARC"></span></td>
                                <td class="totals-and-averages-values"><span data-bind="text:TOTAL_SmartARC"></span></td>
                                <th class="big-empty-column"></th>
                            </tr>
                            <tr>
                                <th class="big-empty-column"></th>
                                <td class="left-categories">Power On</td>
                                <td class="totals-and-averages-values"><span data-bind="text:EAF_A_PowerOn"></span></td>
                                <td class="totals-and-averages-values"><span data-bind="text:EAF_B_PowerOn"></span></td>
                                <td class="totals-and-averages-values"><span data-bind="text:PowerOnConcat"></span></td>
                                <td class="not-border small-empty-column"></td>
                                <td class="left-categories">Bypass: Breaker / Maintained</td>
                                <td class="totals-and-averages-values"><span data-bind="text:EAFABypass"></span></td>
                                <td class="totals-and-averages-values">-</td>
                                <td class="totals-and-averages-values">-</td>
                                <th class="big-empty-column"></th>
                            </tr>
                        </table>

                        </div>
                    
                        <div data-bind="classes: { hide: not(showFurnace1Data), }" style="margin-bottom:-10px !important;margin-top:0px">
                           <label class="section-title">EAF A</label>
                            <div style="display:flex; justify-content:center;" class="furnace-gantt">                                
                                <svg style="margin-top:0px;width:100% !important;" class="furnace1-gantt"></svg>
                            </div>
                        </div>
                        <div style="display:flex;justify-content:center">
                            <label data-bind="classes: { hide: showFurnace1Data, }">EAF A - data no available</label>
                        </div>
                        <div data-bind="classes: { hide: not(showFurnace2Data), }"  style="margin-bottom:-10px !important;margin-top:0px"">
                            <label class="section-title">EAF B</label>
                            <div style="display:flex; justify-content:center;" class="furnace-gantt">   
                                <svg style="margin-top:0px;width:100% !important;" class="furnace2-gantt"></svg>
                            </div>
                        </div>
                        <div style="display:flex;justify-content:center">
                            <label data-bind="classes: { hide: showFurnace2Data, }">EAF B  - data no available</label>
                        </div>
                        
                        <div id="refsDuration" style="display:flex; justify-content:center;margin-top:10px"></div> 
                        <div id="refsCategories" style="display:flex; justify-content:center;margin-top:0px"></div>                      

                      
                        <div class="items-grid-container-delays items-grid-container"></div>         
                    </div>
               

                    <div class="page">                      
                        
                         <%-- Yield --%>
                        <div  data-bind="classes: { hide: any(not(hasData_yield)), }" style="display:flex;justify-content:center">
                            <div class="yield_print"></div>
                        </div>
                        
                        <%-- Slag --%>
                        <div style="margin-bottom:10px !important;margin-top:10px !important;">
                            <label class="section-title" data-bind="text:structuralAims"></label>
                            <label class="section-title" data-bind="text:railAims"></label>
                            <div class="items-grid-container-slag items-grid-container"></div>
                        </div>
                        
                    </div>
                   
                    <div class="page">
                        <div class="eaf-charts">
                             <%-- Tempreature EAF A Chart --%> 
                            <div data-bind="classes: { hide: any(not(hasData_temperature_EAFA)), }" class="chart-position-left">
                                <div class="line-chart temperature_EAFA_print"></div>
                            </div>


                            <%-- Oxygen EAF A Chart --%>  
                            <div data-bind="classes: { hide: any(not(hasData_oxygen_EAFA)), }" class="chart-position-right">
                                <div class="line-chart oxygen_EAFA_print"></div>
                            </div>    

                            <%-- Residual Chart 1  A --%>      
                            <div  data-bind="classes: { hide: any(not(hasData_residuals_EAFA)), }"  class="chart-position-left">
                                <div class="line-chart residuals_EAFA_print"></div>
                            </div>  

                            <%-- Residual Chart 2  A --%>      
                            <div  data-bind="classes: { hide: any(not(hasData_residuals_EAFA_2)), }" class="chart-position-right">
                                <div class="line-chart residuals_EAFA_2_print"></div>
                            </div>  

                             <%-- KWH/Ton A --%>
                            <div data-bind="classes: { hide: any(not(hasData_injection_fluxes_EAFA)), }"  class="chart-position-left">    
                                <div class="line-chart injection_fluxes_EAFA_print"></div>
                            </div> 


                            <%-- Buckets A --%>
                            <div data-bind="classes: { hide: any(not(hasData_bucket_fluxes_EAFA)), }" class="chart-position-right">
                                <div class="line-chart bucket_fluxes_EAFA_print"></div>
                            </div> 


                        </div>
                       


                    </div>

                    <div class="page">
                        <div class="eaf-charts">
                            <%-- Tempreature EAF A Chart --%> 
                            <div data-bind="classes: { hide: any(not(hasData_temperature_EAFB)), }" class="chart-position-left">
                                <div class="line-chart temperature_EAFB_print"></div>
                            </div>


                            <%-- Oxygen EAF A Chart --%>  
                            <div data-bind="classes: { hide: any(not(hasData_oxygen_EAFB)), }" class="chart-position-right">
                                <div class="line-chart oxygen_EAFB_print"></div>
                            </div>    

                            <%-- Residual Chart 1  A --%>      
                            <div  data-bind="classes: { hide: any(not(hasData_residuals_EAFB)), }"  class="chart-position-left">
                                <div class="line-chart residuals_EAFB_print"></div>
                            </div>  

                            <%-- Residual Chart 2  A --%>      
                            <div  data-bind="classes: { hide: any(not(hasData_residuals_EAFB_2)), }" class="chart-position-right">
                                <div class="line-chart residuals_EAFB_2_print"></div>
                            </div>  

                             <%-- KWH/Ton B --%>
                            <div data-bind="classes: { hide: any(not(hasData_injection_fluxes_EAFB)), }"  class="chart-position-left">    
                                <div class="line-chart injection_fluxes_EAFB_print"></div>
                            </div> 


                            <%-- Buckets B --%>
                            <div data-bind="classes: { hide: any(not(hasData_bucket_fluxes_EAFB)), }" class="chart-position-right">
                                <div class="line-chart bucket_fluxes_EAFB_print"></div>
                            </div> 
                        </div>


                    </div>
              
              
                    <div class="page">   
                    
                        <%-- Baghouse --%>
                        <div  data-bind="classes: { hide: any(not(hasData_baghouse)), }" style="display:flex;justify-content:center" class="baghouse-chart">
                            <div class="baghouse_print"></div>
                        </div>

                        <%-- recipes --%>
                        <div data-bind="classes: { hide: any(not(hasData_Recipes)), }" class="items-grid-container-recipes items-grid-container" style="margin-top:10px !important;"></div>    

                         <%--average recipes --%>
                        <div data-bind="classes: { hide: any(not(hasData_RecipesAverage)), }" class="items-grid-container-recipes-average items-grid-container"></div>    

                        <%-- Log Book --%>
                        <div class="items-grid-container-itemsLogBook items-grid-container" style="margin-top:10px !important; margin-bottom:10px !important;"></div>

                         <%--manual Temperatures --%>
                        <div class="items-grid-container-manualTemps items-grid-container"></div>
                         
                        <%--TapHole Non FreeOpen --%>
                         <div class="items-grid-container-tapHoleNonFreeOpen items-grid-container"></div>
                        

                    </div>
                  

                </td>
                </tr>
            </tbody>

           <%-- <tfoot>
                <tr>
                <td>
                    <div class="page-footer-space"></div>
                </td>
                </tr>
            </tfoot>--%>

        </table>
    </div>
</div>




<%-- SCREEN --%>

<%-- PICKERS --%>
<div class="not-print">
    <div class="row-fluid subnavbar fixed-subnavbar" style="min-width:1305px;margin-top: -1px;height: 45px !important;"> 
        <div class="form-inline pull-left span12" style="min-width:1260px;"> 
      
        
            <label class="control-label" id="shift">
                <button id="backNavBtn" class="btn btn-primary " style="margin-bottom:5px;margin-right:5px;" data-bind="disabled:  isLoading">
                            <asp:Localize runat="server" meta:resourcekey="back_item_btn_label" />
                </button> 
  
                <label class="input-prepend" id="date" style="margin-bottom:5px;">
                    <span class="add-on"><i class="icon-calendar"></i></span>
                    <input type="text" id="productionDateTbx" class="input-date" style="width:75px;z-index:1000;" data-bind="value: productionDate, disabled: isLoading ">
                </label>
            
                <input type="text" style="width:20px; text-align:center; margin-top: -5px;" data-bind="value:shiftId"  readonly />
                <button id="forwardNavBtn" class="btn btn-primary" style="margin-bottom:5px;margin-left:10px;" data-bind="disabled:  isLoading">
                            <asp:Localize runat="server" meta:resourcekey="forward_item_btn_label" />
                </button>
            </label>
        
            <button id="refreshBtn" class="btn btn-primary" style="margin-bottom:5px;margin-left:10px;" title="<asp:localize runat=server meta:resourcekey=refresh_btn_title />"  data-bind=" disabled: isLoading">
                <i class="fa fa-refresh"></i>
            </button>

            <div class="pull-right" style="margin-right:10px;">
                <button id="printBtn" class="btn btn-primary"  style="margin-bottom:5px;margin-left:10px;" title="<asp:localize runat=server meta:resourcekey=print_btn_title />"  data-bind="disabled:  any(not(hasData), isLoading)" >
                    <i class="fa fa-print"></i>
                </button>
                <button style="margin-top:0; margin-left:10px; margin-right:10px;" class="btn btn-export-to-excel pull-right hide" type="button">
                    <span class="excel-export-state fa fa-file-excel-o"></span>
                    <img class="loading-state hide" style="width:20px;height:20px;" src="<%= ResolveUrl("~/assets/img/spinner20.gif") %>" />
                </button>
            </div>
        
        </div>
    </div>
</div>


<%-- LOADING and NO DATA AVAILABLE --%>
<div class="row-fluid screen-content">
    <div class="no-data-poster row-fluid text-center animated fadeIn not-print" data-bind="classes: { hide: any(hasData, isLoading), }" style="height:500px;">
        <div class="row-fluid" style="position:relative;top:200px;">
            <i class="fw-icon-circle-blank fw-icon-4x" style="font-size:115px;"></i>
        </div>
        <div class="row-fluid" style="position:relative;top:215px;">
            <h3 style="font-size:50px;">
                <asp:localize runat="server" meta:resourcekey="no_data_available" />
            </h3>
        </div>
    </div> 
    <div class="no-data-poster row-fluid text-center animated fadeIn not-print" data-bind="classes: { hide: not(isLoading), }" style="height:500px;">
        <div class="row-fluid" style="position:relative;top:200px;">
            <i class="fa fa-cog fw-icon-4x fa-spin" style="font-size:115px;"></i>
        </div>
        <div class="row-fluid" style="position:relative;top:215px;">
            <h3 style="font-size:50px;">
                <asp:localize runat="server" meta:resourcekey="loading_data" />
            </h3>
        </div>
    </div>
</div>


<%-- SCREEN CONTENT --%>
<div class="not-print screen-content" data-bind="classes: { hide: any(not(hasData), isLoading), }">   
    
    <div style="margin-top:60px;">
        <label class="section-title-screen">EAF Shift Report</label>
        
        <table class="totals-and-averages EAF-averages-chart-print">
                            <tr>
                                <th class="big-empty-column"></th>
                                <th class="not-border" ></th>
                                <th class="top-categories">EAF A</th>
                                <th class="top-categories">EAF B</th>
                                <th class="top-categories">TOTAL | AVG</th>
                                <th class="not-border small-empty-column"></th>
                                <th class="not-border" ></th>
                                <th class="top-categories">EAF A</th>
                                <th class="top-categories">EAF B</th>
                                <th class="top-categories">TOTAL | AVG</th>
                                <th class="big-empty-column"></th>
                            </tr>
                            <tr>
                                <th class="big-empty-column"></th>
                                <td class="left-categories">Total Heats</td>
                                <td class="totals-and-averages-values"><span data-bind="text:EAF_A_TotalHeats"></span></td>
                                <td class="totals-and-averages-values"><span data-bind="text:EAF_B_TotalHeats"></span></td>
                                <td class="totals-and-averages-values"><span data-bind="text:TOTAL_TotalHeats"></span></td>
                                <td class="not-border small-empty-column"></td>
                                <td class="left-categories">Total MWH</td>
                                <td class="totals-and-averages-values"><span data-bind="text:EAF_A_TotalElectricEnergy"></span></td>
                                <td class="totals-and-averages-values"><span data-bind="text:EAF_B_TotalElectricEnergy"></span></td>
                                <td class="totals-and-averages-values"><span data-bind="text:TOTAL_TotalElectricEnergy"></span></td>
                                <th class="big-empty-column"></th>
                            </tr>
                            <tr>
                                <th class="big-empty-column"></th>
                                <td class="left-categories">Tot Steel Weight</td>
                                <td class="totals-and-averages-values"><span data-bind="text:EAF_A_TotalSteelWeight"></span></td>
                                <td class="totals-and-averages-values"><span data-bind="text:EAF_B_TotalSteelWeight"></span></td>
                                <td class="totals-and-averages-values"><span data-bind="text:TOTAL_TotalSteelWeight"></span></td>
                                <td class="not-border small-empty-column"></td>
                                <td class="left-categories">Electrode Adds</td>
                                <td class="totals-and-averages-values"><span data-bind="text:EAF_A_TotalElectrodeAdds"></span></td>
                                <td class="totals-and-averages-values"><span data-bind="text:EAF_B_TotalElectrodeAdds"></span></td>
                                <td class="totals-and-averages-values"><span data-bind="text:TOTAL_TotalElectrodeAdds"></span></td>
                                <th class="big-empty-column"></th>
                            </tr>
                            <tr>
                                <th class="big-empty-column"></th>
                                <td class="left-categories">Tot Scrap Weight</td>
                                <td class="totals-and-averages-values"><span data-bind="text:EAF_A_TotalScrapWeight"></span></td>
                                <td class="totals-and-averages-values"><span data-bind="text:EAF_B_TotalScrapWeight"></span></td>
                                <td class="totals-and-averages-values"><span data-bind="text:TOTAL_TotalScrapWeight"></span></td>
                                <td class="not-border small-empty-column"></td>
                                <td class="left-categories">Electrode Cons</td>
                                <td class="totals-and-averages-values"><span>-</span></td>
                                <td class="totals-and-averages-values"><span>-</span></td>
                                <td class="totals-and-averages-values"><span>-</span></td>
                                <th class="big-empty-column"></th>
                            </tr>
                            <tr>
                                <th class="big-empty-column"></th>
                                <td class="left-categories">Steel Weight</td>
                                <td class="totals-and-averages-values"><span data-bind="text:EAF_A_SteelWeight"></span></td>
                                <td class="totals-and-averages-values"><span data-bind="text:EAF_B_SteelWeight"></span></td>
                                <td class="totals-and-averages-values"><span data-bind="text:SteelWeightConcat"></span></td>
                                <td class="not-border small-empty-column"></td>
                                <td class="left-categories">Spray Ring Effectiveness</td>
                                <td class="totals-and-averages-values"><span data-bind="text:EAFASprayRingEffectiveness"></span></td>
                                <td class="totals-and-averages-values"><span data-bind="text:EAFBSprayRingEffectiveness"></span></td>
                                <td class="totals-and-averages-values">-</td>
                                <th class="big-empty-column"></th>
                      
                   
                            </tr>
                            <tr>
                                <th class="big-empty-column"></th>
                                <td class="left-categories">Scrap Weight</td>
                                <td class="totals-and-averages-values"><span data-bind="text:EAF_A_ScrapWeight"></span></td>
                                <td class="totals-and-averages-values"><span data-bind="text:EAF_B_ScrapWeight"></span></td>
                                <td class="totals-and-averages-values"><span data-bind="text:ScrapWeightConcat"></span></td>
                                <td class="not-border small-empty-column"></td>
                                <td class="left-categories">KWH/Ton</td>
                                <td class="totals-and-averages-values"><span data-bind="text:EAF_A_SpecificEnergy"></span></td>
                                <td class="totals-and-averages-values"><span data-bind="text:EAF_B_SpecificEnergy"></span></td>
                                <td class="totals-and-averages-values"><span data-bind="text:SpecificEnergyConcat"></span></td>
                                <th class="big-empty-column"></th>
                                 
                   
                            </tr>
                            <tr>
                                <th class="big-empty-column"></th>
                                <td class="left-categories">Yield (%)</td>
                                <td class="totals-and-averages-values"><span data-bind="text:EAF_A_Yield"></span></td>
                                <td class="totals-and-averages-values"><span data-bind="text:EAF_B_Yield"></span></td>
                                <td class="totals-and-averages-values"><span data-bind="text:YieldConcat"></span></td>
                                <td class="not-border small-empty-column"></td>
                                <td class="left-categories">Electric Power</td>
                                <td class="totals-and-averages-values"><span data-bind="text:EAF_A_ElectricPower"></span></td>
                                <td class="totals-and-averages-values"><span data-bind="text:EAF_B_ElectricPower"></span></td>
                                <td class="totals-and-averages-values"><span data-bind="text:TOTAL_ElectricPower"></span></td>
                                <th class="big-empty-column"></th>
                                
                  
                            </tr>
                            <tr>
                                <th class="big-empty-column"></th>
                                <td class="left-categories">Tap To Tap</td>
                                <td class="totals-and-averages-values"><span data-bind="text:EAF_A_TapToTap"></span></td>
                                <td class="totals-and-averages-values"><span data-bind="text:EAF_B_TapToTap"></span></td>
                                <td class="totals-and-averages-values"><span data-bind="text:TapToTapConcat"></span></td>
                                <td class="not-border small-empty-column"></td>
                                <td class="left-categories">Smart Furnace</td>
                                <td class="totals-and-averages-values"><span data-bind="text:EAF_A_SmartARC"></span></td>
                                <td class="totals-and-averages-values"><span data-bind="text:EAF_B_SmartARC"></span></td>
                                <td class="totals-and-averages-values"><span data-bind="text:TOTAL_SmartARC"></span></td>
                                <th class="big-empty-column"></th>
                            </tr>
                            <tr>
                                <th class="big-empty-column"></th>
                                <td class="left-categories">Power On</td>
                                <td class="totals-and-averages-values"><span data-bind="text:EAF_A_PowerOn"></span></td>
                                <td class="totals-and-averages-values"><span data-bind="text:EAF_B_PowerOn"></span></td>
                                <td class="totals-and-averages-values"><span data-bind="text:PowerOnConcat"></span></td>
                                <td class="not-border small-empty-column"></td>
                                <td class="left-categories">Bypass: Breaker / Maintained</td>
                                <td class="totals-and-averages-values"><span data-bind="text:EAFABypass"></span></td>
                                <td class="totals-and-averages-values">-</td>
                                <td class="totals-and-averages-values">-</td>
                                <th class="big-empty-column"></th>
                            </tr>
                        </table>
           
        <div data-bind="classes: { hide: not(showFurnace1Data), }">                
            <label class="section-title-screen">EAF A</label>
            <div style="display:flex; justify-content:center;margin-top:0px;margin-bottom:0px;"> 
                <svg class="furnace1-gantt-screen"></svg>
            </div>
        </div>
        <div data-bind="classes: { hide: not(showFurnace2Data), }">  
            <label class="section-title-screen">EAF B</label>             
            <div style="display:flex; justify-content:center;margin-top:0px;margin-bottom:0px;"> 
                <svg class="furnace2-gantt-screen"></svg>
            </div>     
        </div>  
        <div id="refs-screen-duration" style="display:flex; justify-content:center;margin-top:10px;margin-bottom:0px;"></div>
        <div id="refs-screen-categories" style="display:flex; justify-content:center;margin-top:0px;margin-bottom:0px;"></div>
        <div class="row-fluid">
            <div class="span3">

             

            </div>
            <div class="span6">
                <div class="items-grid-container-delays-screen items-grid-container"></div>   

            </div>
        </div>


        <div class="screen-charts">
          
            <%-- Yield --%>
            <div class="row fluid not-print" style="margin-bottom:50px;margin-top:50px;">
                <div class="span12 print-chart" data-bind="classes: { hide: any(not(hasData_yield)), }">
                    <label class="section-title-screen">Yield</label>
                    <div style="text-align:center" class="yield"></div>
                </div>
            </div> 
              <%-- Tempreature Charts --%>   
            <div class="row fluid" style="margin-bottom:50px;margin-top:50px;">
                <div class="span6 print-chart" data-bind="classes: { hide: any(not(hasData_temperature_EAFA)), }">
                    <label class="section-title-screen">EAF A - TEMPERATURE</label>
                    <div style="text-align:center" class="temperature_EAFA"></div>
                </div>  
                <div class="span6 set-margin-top print-chart" data-bind="classes: { hide: any(not(hasData_temperature_EAFB)), }">
                    <label class="section-title-screen">EAF B - TEMPERATURE</label>
                    <div style="text-align:center" class="temperature_EAFB"></div>
                </div>
            </div>
                <%-- Oxygen Charts --%>
            <div class="row fluid" style="margin-bottom:50px;margin-top:50px;">
                <div class="span6 print-chart"  data-bind="classes: { hide: any(not(hasData_oxygen_EAFA)), }">
                    <label class="section-title-screen">EAF A - OXYGEN</label>
                    <div style="text-align:center" class="oxygen_EAFA"></div>
                </div>  
                <div class="span6 print-chart"  data-bind="classes: { hide: any(not(hasData_oxygen_EAFB)), }">
                    <label class="section-title-screen">EAF B - OXYGEN</label>
                    <div style="text-align:center" class="oxygen_EAFB"></div>
                </div>
            </div>
            <%-- Residual Charts 1 --%>
            <div class="row fluid not-print" style="margin-bottom:50px;margin-top:50px">
                <div class="span6 print-chart" data-bind="classes: { hide: any(not(hasData_residuals_EAFA)), }">
                    <label class="section-title-screen">EAF A - RESIDUAL GRAPH 1</label>
                    <div style="text-align:center" class="residuals_EAFA"></div>
                </div> 
                <div class="span6 print-chart" data-bind="classes: { hide: any(not(hasData_residuals_EAFB)), }">
                    <label class="section-title-screen">EAF B - RESIDUAL GRAPH 1</label>
                    <div style="text-align:center" class="residuals_EAFB"></div>
                </div>
            </div>
            <%-- Residual Charts 2 --%>
            <div class="row fluid not-print" style="margin-bottom:50px;margin-top:50px;">
                <div class="span6 print-chart" data-bind="classes: { hide: any(not(hasData_residuals_EAFA_2)), }">
                    <label class="section-title-screen">EAF A - RESIDUAL GRAPH 2</label>
                    <div style="text-align:center" class="residuals_EAFA_2"></div>
                </div>  
                <div class="span6 print-chart" data-bind="classes: { hide: any(not(hasData_residuals_EAFB_2)), }">
                    <label class="section-title-screen">EAF B - RESIDUAL GRAPH 2</label>
                    <div style="text-align:center" class="residuals_EAFB_2"></div>
                </div>
            </div>
            <%-- KWH/Ton --%>
            <div class="row fluid not-print" style="margin-bottom:50px;margin-top:50px;">
                <div class="span6 print-chart" data-bind="classes: { hide: any(not(hasData_injection_fluxes_EAFA)), }">
                    <label class="section-title-screen">EAF A - KWH/Ton</label>
                    <div style="text-align:center" class="injection_fluxes_EAFA"></div>
                </div>  
                <div class="span6 print-chart" data-bind="classes: { hide: any(not(hasData_injection_fluxes_EAFB)), }">
                    <label class="section-title-screen">EAF B - KWH/Ton</label>
                    <div style="text-align:center" class="injection_fluxes_EAFB"></div>
                </div>
            </div>
            <%-- Buckets --%>
            <div class="row fluid not-print" style="margin-bottom:50px;margin-top:50px;">
                <div class="span6 print-chart" data-bind="classes: { hide: any(not(hasData_bucket_fluxes_EAFA)), }">
                    <label class="section-title-screen">EAF A - BUCKET FLUXES</label>
                    <div style="text-align:center" class="bucket_fluxes_EAFA"></div>
                </div>  
                <div class="span6 print-chart" data-bind="classes: { hide: any(not(hasData_bucket_fluxes_EAFB)), }">
                    <label class="section-title-screen">EAF B - BUCKET FLUXES</label>
                    <div style="text-align:center" class="bucket_fluxes_EAFB"></div>
                </div>
            </div>
              <%-- Baghouse --%>
            <div class="row fluid not-print" style="margin-bottom:50px;margin-top:50px;">
                <div class="span12 print-chart" data-bind="classes: { hide: any(not(hasData_baghouse)), }">
                    <label class="section-title-screen">Baghouse</label>
                    <div style="text-align:center" class="baghouse"></div>
                </div>
            </div> 
        </div>

        <div class="row-fluid ">  
            <div class="span6">                                 
                <div class="items-grid-container-itemsLogBook-screen items-grid-container"></div>
            </div>
            <div class="span6">              
                <label class="section-title-screen" data-bind="text:structuralAims"></label>
                <label class="section-title-screen" data-bind="text:railAims"></label>
                <div class="items-grid-container-slag-screen items-grid-container"></div>  
                
                <div class="items-grid-container-recipes-screen items-grid-container" style="margin-top:20px;"></div> 
                <div class="items-grid-container-recipes-average-screen items-grid-container"></div> 

                <div class="items-grid-container-manualTemps-screen items-grid-container"></div>
               <div class="items-grid-container-tapHoleNonFreeOpen-screen items-grid-container"></div>
             
        </div>   
    </div>
                   


</div>