﻿//SCREEN-BOILERPLATE
//this boilerplate builds screens that are gonna be shown in the <div class='content'> tag of our main HTML.
//do not build app components with this boilerplate, only screens (reports)

define([
  // Application variable, always include it to have access to app methods.
  'app',

  //templates-loader: this loads templates async.
  'js/templates-loader',
  'backgrid',
  'moment',
  'backgrid/moment-cell',
  'backgrid/infinator',
  
    'backgrid/grouped-columns',
],
function (app, T, Backgrid, moment) {

    var Screen = { Models: {}, Views: {}, Collections: {} }

    Screen.Models.Main = Backbone.Epoxy.Model.extend({
        defaults: {
            ladleFurnaceCode: '-',
            furnaces: [{ label: 'South', value: 1 }, { label: 'North', value: 2 }],

            start: new moment().subtract(1, 'days').format('MM/DD/YYYY'),
            end: new moment().format('MM/DD/YYYY'),
            crews: [{ label: 'A', value: 'A' }, { label: 'B', value: 'B' }, { label: 'C', value: 'C' }, { label: 'D', value: 'D' }],
            shifts: [{ label: 'D', value: 1 }, { label: 'N', value: 2 }],
            crewId: '-',
            shiftId:'-',

            hasData: false,
            isLoading: false,
        },
    });

    Screen.Models.Item = Backbone.Epoxy.Model.extend({
        parse: function (obj) {
            var result = {
                startLocal: obj.StartLocal ? new moment(obj.StartLocal).format('MM/DD/YYYY HH:mm:ss') : null,
                end: obj.End ? new moment(obj.End).format('MM/DD/YYYY HH:mm:ss') : null,
                ladleFurnaceCode: obj.LadleFurnaceCode ? (obj.LadleFurnaceCode == 1 ? 'South' : 'North') : null,
                treatment: obj.Treatment,
                shiftId: obj.ShiftId ? (obj.ShiftId == 1 ? 'D': 'N') : null,
                crewId: obj.CrewId,
                heatName: obj.HeatName,
                duration: obj.Duration ? obj.Duration : null,
                initialTemperature: obj.InitialTemperature ? obj.InitialTemperature : null,
                finalTemperature: obj.FinalTemperature ? obj.FinalTemperature : null,
                finalOxygen: obj.FinalOxygen ? obj.FinalOxygen : null,
                finalCarbon: obj.FinalCarbon ? obj.FinalCarbon.toFixed(0) : null,
                powerOn: obj.PowerOn ? obj.PowerOn : null,
                //energy: obj.Energy ? obj.Energy : null,
                energy: obj.Energy ? obj.Energy.toFixed(2) / 1000 : null,
                argonVolume: obj.TotalArgonVolume ? obj.TotalArgonVolume.toFixed(3) : null,
                Lime  : obj.Lime   ? obj.Lime   : null,    
                FeVn  : obj.FeVn   ? obj.FeVn   : null,
                CaC2  : obj.CaC2   ? obj.CaC2   : null,
                FeMo  : obj.FeMo    ? obj.FeMo  : null,
                Ni	  : obj.Ni	   ? obj.Ni	    : null,
                LCFeCr: obj.LCFeCr ? obj.LCFeCr : null,
                Carbon: obj.Carbon ? obj.Carbon : null,
                SiMn  : obj.SiMn   ? obj.SiMn   : null,
                LoAlSi: obj.LoAlSi ? obj.LoAlSi : null,
                EAFTapAdditionsOthers: obj.EAFTapAdditionsOthers ? obj.EAFTapAdditionsOthers : null,
                EAFDolo: obj.EAFDolo ? obj.EAFDolo : null,
                EAFTapFluxes: obj.EAFTapFluxes ? obj.EAFTapFluxes : null,
                grade: obj.GradeName ? obj.GradeName : null,

            };

            return result;
        }
    })

    Screen.Collections.Items = Backbone.Collection.extend({
        model: Screen.Models.Item,

        isFetching: false,
        currentPage: 1,
        pageSize: 100,
        fixedParameters: [],

        fetch(params) {
            var that = this
                qp = new Core.Database.QueryParameters(),
                options = params ? _.clone(params) : {};

            if (options.refresh) {
                this.resetPagination(true);
                this.fixedParameters = [
                    { Name: '@start', Type: 'DATETIME', Value: new moment(params.start, 'MM/DD/YYYY').format('YYYY-MM-DD') },
                    { Name: '@end', Type: 'DATETIME', Value: new moment(params.end, 'MM/DD/YYYY').format('YYYY-MM-DD')  },
                    { Name: '@ladleFurnaceCode', Type: 'INT', Value: params.ladleFurnaceCode != '-' ? params.ladleFurnaceCode : null },
                    { Name: '@crewId', Type: 'CHAR', Value: params.crewId != '-' ? params.crewId : null },
                    { Name: '@shiftId', Type: 'INT', Value: params.shiftId != '-' ? params.shiftId : null },
                    { Name: '@timezoneCode', Type: 'VARCHAR', Value: app.models.user.get("timezoneCode") },
                ];
            }
            this.isFetching = true;

            _.each(this.fixedParameters, function (qpParams) {
                qp.Add(qpParams.Name, qpParams.Type, qpParams.Value);
            });

            if (!options.refresh) {
                qp.Add('@fromRow', 'INT', (this.currentPage - 1) * this.pageSize + 1);
                qp.Add('@rowsToFetch', 'INT', this.pageSize - 1);
            } else {
                qp.Add('@fromRow', 'INT', 0);
                qp.Add('@toRow', 'INT', this.currentPage * this.pageSize);
                qp.Add('@rowsToFetch', 'INT', this.pageSize);
            }

            Core.Json.CallProcedure(
                app.DatabaseNames.MES + '.LF.GetProductionReport',
                qp,
                {
                    onSuccess: function (resp) {
                        try {
                            if ((resp) && (resp.Table)) { 
                                console.log("resp", resp);
                                var records = resp.Table,
                                    newColl;

                                newColl = _.map(records, that.model.prototype.parse);

                                var method = ((options.reset) || (options.refresh)) ? 'set' : 'add';

                                if (options.reset)
                                    that.reset();

                                that[method](newColl)
                                    .trigger('fetch', that, resp);

                                if (newColl.length == 0 && method == 'add')
                                    that.currentPage--;

                                that.isFetching = false;
                            }
                            else {
                                if ((resp) && (resp.Message))
                                    console.error(resp.Message);
                                else
                                    console.error('Server response not valid.');
                            }
                        }
                        catch (error) { console.error((error.stack) ? error.stack : new Error(error).stack); }
                    },
                    Secured: true,
                },
                app.ConnectionStrings.app
            );

            return this;
        },
        getNextPage: function (options) {
            if (!this.isFetching) {
                this.currentPage++;
                options = (_.isObject(options)) ? options : {};
                this.fetch(options);
            }
        },
        resetPagination: function (force) {
            if (!this.isFetching || force == true) {
                this.currentPage = 1;
            } else {
                _.delay(this.resetPagination, 100);
            }
        },
    })

    Screen.Views.Main = Backbone.Epoxy.View.extend({
        template: 'lmf-production',
        id: 'lmf-production',
        title: 'LMF Production',
        events: function () {
            return {
                'click #refreshBtn': this.refreshBtn_click,
                "click .btn-export-to-excel": this.exportToExcel,
            };
        },
        bindings: 'data-bind',

        initialize: function () {
            this.options.state = app.view_states.loading;
            this.options.onappend = (_.isFunction(this.options.onappend)) ? this.options.onappend : function () { };

            var that = this;
            this.model = new Screen.Models.Main();
            this.items = new Screen.Collections.Items();

            this.bindEvents();
        },
        
        bindEvents: function () {
            this.listenTo(this.items, 'fetch', this.items_fetched);
            this.listenTo(this.items, 'backgrid:rowclick', this.backgrid_rowclick)
        },


        render: function (container, urlParams) {
            var that = this;
            var thatContainer = (this.options.container) ? this.options.container : container;
            this.options.container = thatContainer;

            var customPath = '/app/custom-screens/' + this.template + '/';

            T.render.call(
                this,
                this.template,
                function (tmp) {
                    if (!that.options.i18n) that.options.i18n = {};

                    app.getI18NJed(
                        that,
                        that.template,
                        function (i18nJED) {
                            that.options.i18n[that.template] = i18nJED;
                            that.$el.html(tmp());
                            that.applyBindings();

                            that.$el.find('.input-date').datepicker();
                            var columns = [
                                {
                                    name: 'heatName',
                                    label: app.translate(that, 'item_heat_name_col_label'),
                                    cell: Backgrid.StringCell.extend({
                                        className: 'string-cell align-center-cell',
                                    }),
                                    editable: false,
                                },
                                {
                                    name: 'treatment',
                                    label: app.translate(that, 'item_treatment_col_label'),
                                    cell: Backgrid.StringCell.extend({
                                        className: 'string-cell align-center-cell',
                                    }),
                                    editable: false,
                                },
                                {
                                    name: 'grade',
                                    label: 'Grade',
                                    cell: Backgrid.StringCell.extend({
                                        className: 'string-cell align-center-cell',
                                    }),
                                    editable: false,
                                },
                                {
                                    name: 'startLocal',
                                    label: app.translate(that, 'item_start_col_label'),
                                    cell: Backgrid.StringCell.extend({
                                        className: 'string-cell align-center-cell',
                                    }),
                                    editable: false,
                                },
                                {
                                    name: 'crewId',
                                    label: app.translate(that, 'item_crew_col_label'),
                                    cell: Backgrid.StringCell.extend({
                                        className: 'string-cell align-center-cell',
                                    }),
                                    editable: false,
                                },
                                {
                                    name: 'shiftId',
                                    label: app.translate(that, 'item_shift_col_label'),
                                    cell: Backgrid.StringCell.extend({
                                        className: 'string-cell align-center-cell',
                                    }),
                                    editable: false,
                                },
                                {
                                    name: 'ladleFurnaceCode',
                                    label: app.translate(that, 'item_ladleFurnaceCode_col_label'),
                                    cell: Backgrid.StringCell.extend({
                                        className: 'string-cell align-center-cell',
                                    }),
                                    editable: false,
                                },
                                {
                                    name: 'duration',
                                    label: app.translate(that, 'item_duration_col_label'),
                                    cell: Backgrid.StringCell.extend({
                                        className: 'string-cell align-center-cell',
                                    }),
                                    editable: false,
                                },
                                {
                                    name: 'initialTemperature',
                                    label: app.translate(that, 'item_initial_temperature_col_label'),
                                    cell: Backgrid.StringCell.extend({
                                        className: 'string-cell align-center-cell',
                                    }),
                                    editable: false,
                                },
                                {
                                    name: 'finalTemperature',
                                    label: app.translate(that, 'item_final_temperature_col_label'),
                                    cell: Backgrid.StringCell.extend({
                                        className: 'string-cell align-center-cell',
                                    }),
                                    editable: false,
                                },
                                {
                                    name: 'finalOxygen',
                                    label: app.translate(that, 'item_final_oxygen_col_label'),
                                    cell: Backgrid.StringCell.extend({
                                        className: 'string-cell align-center-cell',
                                    }),
                                    editable: false,
                                },
                                {
                                    name: 'CaC2',
                                    label: 'CaC2',
                                    cell: Backgrid.StringCell.extend({
                                        className: 'string-cell align-center-cell',
                                    }),
                                    editable: false,
                                },
                                // {
                                //     name: 'finalCarbon',
                                //     label: app.translate(that, 'item_final_carbon_col_label'),
                                //     cell: Backgrid.StringCell.extend({
                                //         className: 'string-cell align-center-cell',
                                //     }),
                                //     editable: false,
                                // },
                                {
                                    name: 'powerOn',
                                    label: app.translate(that, 'item_power_on_col_label'),
                                    cell: Backgrid.StringCell.extend({
                                        className: 'string-cell align-center-cell',
                                    }),
                                    editable: false,
                                },
                                {
                                    name: 'energy',
                                    label: app.translate(that, 'item_energy_col_label'),
                                    cell: Backgrid.StringCell.extend({
                                        className: 'string-cell align-center-cell twenty-percent',
                                    }),
                                    editable: false,
                                },
                                {
                                    name: 'argonVolume',
                                    label: app.translate(that, 'item_argon_volume_col_label'),
                                    cell: Backgrid.StringCell.extend({
                                        className: 'string-cell align-center-cell',
                                    }),
                                    editable: false,
                                },
                                //EAF
                                {
                                    name: 'EAFDolo',
                                    label: app.translate(that, 'item_eaf_tap_additions_dolo_col_label'),
                                    cell: Backgrid.StringCell.extend({
                                        className: 'string-cell align-center-cell',
                                    }),
                                    editable: false,
                                },
                                {
                                    name: 'EAFTapFluxes',
                                    label: app.translate(that, 'item_eaf_tap_additions_fluxes_col_label'),
                                    cell: Backgrid.StringCell.extend({
                                        className: 'string-cell align-center-cell',
                                    }),
                                    editable: false,
                                },
                                {
                                    name: 'EAFTapAdditionsOthers',
                                    label: app.translate(that, 'item_eaf_tap_additions_others_col_label'),
                                    cell: Backgrid.StringCell.extend({
                                        className: 'string-cell align-center-cell',
                                    }),
                                    editable: false,
                                },
                                // LF Fluxes
                                {
                                    name: 'Lime',
                                    label: app.translate(that, 'item_lime_col_label'),
                                    cell: Backgrid.StringCell.extend({
                                        className: 'string-cell align-center-cell',
                                    }),
                                    editable: false,
                                },
                                {
                                    name: 'Carbon',
                                    label: app.translate(that, 'item_Carbon_col_label'),
                                    cell: Backgrid.StringCell.extend({
                                        className: 'string-cell align-center-cell',
                                    }),
                                    editable: false,
                                },
                                //LF SaveAlloys
                               
                                {
                                    name: 'FeVn',
                                    label: app.translate(that, 'item_FeVn_col_label'),
                                    cell: Backgrid.StringCell.extend({
                                        className: 'string-cell align-center-cell',
                                    }),
                                    editable: false,
                                },
                                {
                                    name: 'Ni',
                                    label: app.translate(that, 'item_Ni_col_label'),
                                    cell: Backgrid.StringCell.extend({
                                        className: 'string-cell align-center-cell',
                                    }),
                                    editable: false,
                                },
                                {
                                    name: 'FeMo',
                                    label: app.translate(that, 'item_FeMo_col_label'),
                                    cell: Backgrid.StringCell.extend({
                                        className: 'string-cell align-center-cell',
                                    }),
                                    editable: false,
                                },
                                // LF Batch-Dump 
                                {
                                    name: 'LCFeCr',
                                    label: 'LCFeCr',
                                    cell: Backgrid.StringCell.extend({
                                        className: 'string-cell align-center-cell',
                                    }),
                                    editable: false,
                                },
                                {
                                    name: 'SiMn',
                                    label: app.translate(that, 'item_SiMn_col_label'),
                                    cell: Backgrid.StringCell.extend({
                                        className: 'string-cell align-center-cell',
                                    }),
                                    editable: false,
                                },
                                {
                                    name: 'LoAlSi',
                                    label: app.translate(that, 'item_LoAlSi_col_label'),
                                    cell: Backgrid.StringCell.extend({
                                        className: 'string-cell align-center-cell',
                                    }),
                                    editable: false,
                                },
                            ];

                            var grid = new Backgrid.Grid({
                                className: 'backgrid table table-hover table-condensed production-table',
                                collection: that.items,
                                header: Backgrid.Extension.GroupedHeader.extend({
                                    columnLayout:
                                        [
                                            { name: 'heatName' },
                                            { name: 'treatment' },
                                            { name: 'startLocal' },
                                            { name: 'crewId' },
                                            { name: 'shiftId' },
                                            { name: 'ladleFurnaceCode' },
                                            { name: 'duration' },
                                            { name: 'initialTemperature' },
                                            { name: 'finalTemperature' },
                                            { name: 'finalOxygen' },
                                            { name: 'CaC2' },
                                            // { name: 'finalCarbon' },
                                            { name: 'powerOn' },
                                            { name: 'energy' },
                                            { name: 'argonVolume' },

                                            {
                                                name: 'EAF Tap Additions', children:
                                                    [
                                                        { name: 'EAFDolo' }
                                                        , { name: 'EAFTapFluxes' }
                                                        ,{ name: 'EAFTapAdditionsOthers' }
                                                    ]
                                            },
                                            {
                                                name: 'LF Fluxes', children:
                                                    [
                                                        { name: 'Lime' }
                                                        , { name: 'Carbon' }
                                                    ]
                                            },
                                            {
                                                name: 'LF Micro Alloys', children:
                                                    [
                                                        { name: 'FeVn' }
                                                        ,{ name: 'Ni' }
                                                        ,{ name: 'FeMo' }
                                                    ]
                                            },
                                            {
                                                name: 'LF Alloys', children:
                                                    [
                                                        { name: 'LCFeCr' }
                                                        , { name: 'SiMn' }
                                                        , { name: 'LoAlSi' }
                                                    ]
                                            },

                                        ],
                                    initialize: function (options) {
                                        Backgrid.Extension.GroupedHeader.prototype.initialize.apply(this, arguments);
                                        this.listenTo(this.collection, 'backgrid:sort', this.collection_backgrid_sort);
                                    },
                                    render: function () {
                                        var that = this;
                                        Backgrid.Extension.GroupedHeader.prototype.render.apply(this, arguments);
                                        _.each(this.columns.models, function (modelValue) {
                                            if (modelValue.get('toolTip')) that.$el.find('.' + modelValue.get('name')).attr('title', modelValue.get('toolTip'))
                                        });
                                        return this;
                                    },
                                    collection_backgrid_sort: function (column, direction) {
                                        var sortType = column.get('name').toUpperCase();

                                        switch ((direction + '').toUpperCase()) {
                                            case 'ASCENDING':
                                                sortType += '-ASC';
                                                break;
                                            case 'DESCENDING':
                                                sortType += '-DESC';
                                                break;
                                            case 'NULL':
                                                sortType = null;
                                                break;
                                        }

                                        _.each(this.row.cells, function (obj) {
                                            obj.removeCellDirection();
                                        });

                                        column.set("direction", direction);

                                        that.model.set('sortType', sortType);

                                    },
                                }),
                                footer: Backgrid.Extension.Infinator.extend({
                                    scrollToTop: false,
                                }),
                                columns: columns,
                                row: Backgrid.Row.extend({
                                    events: function () {
                                        return {
                                            'click': this.click,
                                        };
                                    },
                                    click: function (e) {
                                        try {
                                            this.model.trigger('backgrid:rowclick', this.model);
                                        }
                                        catch (Error) { console.error(Error.stack); }
                                    }
                                })
                            });

                            //container.append(grid.render().el);
                            that.$el.find('.items-grid-container').append(grid.render().el);

                                                       
                            //appending view to the main container
                            that.append(thatContainer, that.$el);

                            var fixedParams = _.extend({}, urlParams);


                            if (fixedParams.start)
                                fixedParams.start = new moment(fixedParams.start, 'YYYYMMDD').format('MM/DD/YYYY');
                            if (fixedParams.end)
                                fixedParams.end = new moment(fixedParams.end, 'YYYYMMDD').format('MM/DD/YYYY');

                            that.model.set(fixedParams);

                            that.refresh(); 
                                                       
                        },
                        true,
                        customPath
                    );
                },
                customPath
            );
        },

        setExportButtonExporting: function (val) {
            var btn_export = this.$el.find('.btn-export-to-excel');
            var export_state = btn_export.find('.excel-export-state');
            var loading_state = btn_export.find('.loading-state');

            if (val) {
                export_state.css('display', 'none', 'important');
                loading_state.removeClass('hide');

                btn_export.attr('disabled', true);
            } else {
                loading_state.addClass('hide');
                export_state.css('display', 'inline-block', 'important');

                btn_export.attr('disabled', false);
            }
        },
        refresh: function () {
            this.model.set({
                isLoading: true,
                hasData: false,
            });
            params = this.model.toJSON();
            this.items.fetch({
                start: params.start,
                end: params.end,
                ladleFurnaceCode: params.ladleFurnaceCode,
                crewId: params.crewId,
                shiftId: params.shiftId,
                refresh: true,
            });
        },
        UpdateURL: function () {
            try {
                var params = this.model.toJSON();
                app.router.navigate(
                    app.router.resolveURL(
                        app.router.currentModule,
                        _.extend(
                            {},
                            params,
                            {
                                ladleFurnaceCode: params.ladleFurnaceCode,
                                start: new moment(params.start, 'MM/DD/YYYY').format('YYYYMMDD'),
                                end: new moment(params.end, 'MM/DD/YYYY').format('YYYYMMDD'),
                                shiftId: params.shiftId,
                                crewId: params.crewId
                            }
                        ),
                        false
                    ),
                    { trigger: false, }
                );
            }
            catch (e) { console.error((e.stack) ? e.stack : new Error(e).stack); }
        },

        refreshBtn_click: function (e) {
            this.refresh();
            this.UpdateURL();
        },
        backgrid_rowclick: function (model) {
            try {

                app.router.navigate(
                    app.router.resolveURL(
                        'lmf-heat-report',
                        {
                            heatName: model.get('heatName'),
                            treatmentNumber: model.get('treatment'),
                        },
                        false
                    ),
                    { trigger: true, }
                );
            }
            catch (Error) { console.error(Error.stack); }
        },

        items_fetched: function () {
            try {
                var that = this;
                setTimeout(
                    function () {
                        that.model.set({
                            hasData: (that.items.length > 0),
                            isLoading: false,
                        });

                    },
                    100
                );
            }
            catch (e) { console.error((e.stack) ? e.stack : new Error(e).stack); }
        },


        exportToExcel: function () {
            var that = this,
                params = this.model.toJSON();
            that.setExportButtonExporting(true);
            var params = [
                { Name: '@start', Type: 'DATETIME', Value: params.start },
                { Name: '@end', Type: 'DATETIME', Value: params.end },
                { Name: '@ladleFurnaceCode', Type: 'INT', Value: params.ladleFurnaceCode != '-' ? params.ladleFurnaceCode : null },
                { Name: '@crewId', Type: 'CHAR', Value: params.crewId != '-' ? params.crewId : null },
                { Name: '@shiftId', Type: 'INT', Value: params.shiftId != '-' ? params.shiftId : null },
                { Name: '@timezoneCode', Type: 'VARCHAR', Value: app.models.user.get("timezoneCode") },
                { Name: '@ExportToExcel', Type: 'BIT', Value: 1 },

            ];
            var QP = new QueryParameters();

            _.each(params, function (qpParams) {
                QP.Add(qpParams.Name, qpParams.Type, qpParams.Value);
            });


            var data = {
                Data: [],
                ConnectionStringName: 'APP',
                ExportMethod: 3,
                FileName: 'LMF-Production',
                TemplateFileFullPath: 'generic.xls',
                SQLDataSources: [
                    {
                        Name: 'data',
                        DatabaseParameters: {
                            DBEngine: 'SQLSERVER',
                            Procedure: app.DatabaseNames.MES + '.LF.GetProductionReport',
                            QueryParameters: QP,
                        },
                    },
                ]
            };

            /* -------------------------------------------------------- 1st Table ------------------------------------------------------------ */
            data.Data.push({
                SheetName: 'Data',
                RowsData: [{
                    CellsData:
                        [
                            { Column: 'A', Value: 'Heat' },
                            { Column: 'B', Value: 'Grade' },
                            { Column: 'C', Value: 'Treatment' },
                            { Column: 'D', Value: 'Start' },
                            { Column: 'E', Value: 'CrewId' },
                            { Column: 'F', Value: 'Shift' },
                            { Column: 'G', Value: 'LMF' },
                            { Column: 'H', Value: 'Duration' },
                            { Column: 'I', Value: 'Initial Temperature' },
                            { Column: 'J', Value: 'Final Temperature' },
                            // { Column: 'K', Value: 'Final Carbon' },
                            { Column: 'K', Value: 'Final Oxygen' },
                            { Column: 'L', Value: 'Power On' },
                            { Column: 'M', Value: 'MWH' },
                            { Column: 'N', Value: 'Total Argon Volume' },
                            { Column: 'O', Value: 'EAF Tap Additions - Dolo' },
                            { Column: 'P', Value: 'EAF Tap Additions - Fluxes' },
                            { Column: 'Q', Value: 'EAF Tap Additions - Other' },
                            { Column: 'R', Value: 'Lime' },
                            { Column: 'S', Value: 'Carbon' },
                            { Column: 'T', Value: 'CaC2' },
                            { Column: 'U', Value: 'FeVn' },
                            { Column: 'V', Value: 'Ni' },
                            { Column: 'W', Value: 'LCFeCr' },
                            { Column: 'X', Value: 'SiMn' },
                            { Column: 'Y', Value: 'LoAlSi' },


                        ],
                }],
                StartRowIndex: 1,
            });

            data.Data.push({
                SheetName: 'Data',
                RowsData: [],
                StartRowIndex: 2,
                DataSourceName: 'data',
                DataSourceTableIndex: 0,
                SQLCellsData:
                    [
                        { ExcelColumnName: 'A', SQLDataColumnName: 'HeatName', DataType: 'String' },
                        { ExcelColumnName: 'B', SQLDataColumnName: 'GradeName', DataType: 'String' },
                        { ExcelColumnName: 'C', SQLDataColumnName: 'Treatment', DataType: 'String' },
                        { ExcelColumnName: 'D', SQLDataColumnName: 'StartLocal', DataType: 'String' },
                        { ExcelColumnName: 'E', SQLDataColumnName: 'CrewId', DataType: 'String' },
                        { ExcelColumnName: 'F', SQLDataColumnName: 'ShiftName', DataType: 'String' },
                        { ExcelColumnName: 'G', SQLDataColumnName: 'LadleFurnaceName', DataType: 'String' },
                        { ExcelColumnName: 'H', SQLDataColumnName: 'Duration', DataType: 'String' },
                        { ExcelColumnName: 'I', SQLDataColumnName: 'InitialTemperature', DataType: 'String' },
                        { ExcelColumnName: 'J', SQLDataColumnName: 'FinalTemperature', DataType: 'String' },
                        // { ExcelColumnName: 'K', SQLDataColumnName: 'FinalCarbon', DataType: 'String' },
                        { ExcelColumnName: 'K', SQLDataColumnName: 'FinalOxygen', DataType: 'String' },
                        { ExcelColumnName: 'L', SQLDataColumnName: 'PowerOn', DataType: 'String' },
                        { ExcelColumnName: 'M', SQLDataColumnName: 'MWH', DataType: 'String' },
                        { ExcelColumnName: 'N', SQLDataColumnName: 'TotalArgonVolume', DataType: 'String' },
                        { ExcelColumnName: 'O', SQLDataColumnName: 'EAFDolo', DataType: 'Float' },
                        { ExcelColumnName: 'P', SQLDataColumnName: 'EAFTapFluxes', DataType: 'Float' },
                        { ExcelColumnName: 'Q', SQLDataColumnName: 'EAFTapAdditionsOthers', DataType: 'Float' },
                        { ExcelColumnName: 'R', SQLDataColumnName: 'Lime', DataType: 'Float' },
                        { ExcelColumnName: 'S', SQLDataColumnName: 'Carbon', DataType: 'Float' },
                        { ExcelColumnName: 'T', SQLDataColumnName: 'CaC2', DataType: 'Float' },
                        { ExcelColumnName: 'U', SQLDataColumnName: 'FeVn', DataType: 'Float' },
                        { ExcelColumnName: 'V', SQLDataColumnName: 'Ni', DataType: 'Float' },
                        { ExcelColumnName: 'W', SQLDataColumnName: 'LCFeCr', DataType: 'Float' },
                        { ExcelColumnName: 'X', SQLDataColumnName: 'SiMn', DataType: 'Float' },
                        { ExcelColumnName: 'Y', SQLDataColumnName: 'LoAlSi', DataType: 'Float' },




                    ],
            });

            Core.Export.Excel(
                data,
                function (resp) {
                    try {
                        if ((resp) && (resp.Success == true) && (resp.Data)) {
                            location.href = app.foldersRoot + '/excel/' + resp.Data;

                        }
                        else {
                            if ((resp) && (resp.Message))
                                console.error(resp.Message);
                            else
                                console.error('Server response not valid.');
                        }
                    }
                    catch (Error) { console.error(Error); }
                    that.setExportButtonExporting(false);
                },
                function (resp) {
                    that.model.refreshProcesses();
                    that.setExportButtonExporting(false);
                    console.error(resp);
                }
            );
        },

        append: function (container, el) {
            el = (el != null && el != undefined) ? el : this.$el;

            if (this.options.state == app.view_states.loading
                || this.options.state == app.view_states.shown) {
                //appending view to the main container and set state to shown

                this.options.state = app.view_states.shown;
                container.append(el);

                this.options.onappend(this);
            }

            if (this.options.state == app.view_states.hidden) {
                //append and remain hidden
                container.append(el);
            }

            if (this.options.state == app.view_states.closed) {
                //return without appending.
                return;
            }
        },
        bindViewScopedEvents: function () {
            var that = this;
        },
        unbindViewScopedEvents: function () {

        },
        close: function () {
            this.options.state = app.view_states.closed;
            
            this.closeSubviews();
            this.remove();
            this.unbindViewScopedEvents();
            this.unbind();
        },
        closeSubviews: function () {
            _.each(this.subviews, function (sview) {
                sview.close();
            });
        },
        show: function () {
            this.options.state = app.view_states.shown;

            this.showSubviews();
            this.bindEvents();
            this.$el.show();
        },
        showSubviews: function () {
            _.each(this.subviews, function (sview) {
                sview.show();
            });
        },
        hide: function () {
            this.options.state = app.view_states.hidden;

            this.hideSubviews();

            this.$el.hide();
            this.unbind();
            this.stopListening();
        },
        hideSubviews: function () {
            _.each(this.subviews, function (sview) {
                sview.hide();
            });
        },
        preRender: function () {
            app.models.subnavbar.set("subnavbar", false);
        },
        reRender: function (urlParams) {
            try {
                this.refresh(viewParams);
            } catch (Error) { }
        },

    });

    // Required, return the module for AMD compliance.
    return Screen;
});