﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>

<script runat="server">
    //@Override this is suggested by Microsoft, overriding the initialize culture function (that is
    //automatically called by the aspx.
    //Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
    //(English).
    protected override void InitializeCulture()
    {
   
        HttpCookie lang = Request.Cookies["siteLanguage"];

        String selectedLanguage = (lang != null) ? lang.Value : "en";
        UICulture = selectedLanguage;
        Culture = selectedLanguage;

        Thread.CurrentThread.CurrentCulture =
            CultureInfo.CreateSpecificCulture(selectedLanguage);
        Thread.CurrentThread.CurrentUICulture = new
            CultureInfo(selectedLanguage);
        base.InitializeCulture();
    }
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
 
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/app/custom-screens/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + ".css")%>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/jstree/themes/default/style.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/bootstrap-timepicker/css/bootstrap-timepicker.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/autocomplete/backbone.autocomplete.css") %>" rel="stylesheet" />
 <link href="<%= ResolveUrl("~/assets/libs/js/multiselect/virtual-select.min.css") %>" rel="stylesheet" />

<div class="row-fluid subnavbar fixed-subnavbar" style="min-width:1305px;"> 
    <div class="form-inline pull-left span11" style="min-width:1500px;"> 
        <label class="control-label" for="dateStartTbx" data-bind="classes: { hide: showShiftPickers, }" > 
            <asp:localize runat="server" meta:resourcekey="date_start_tbx_label" />
        </label>
        <label class="input-prepend" data-bind="classes: { hide: showShiftPickers, }"  > 
            <span class="add-on"><i class="icon-calendar"></i></span>
            <input type="text" id="dateStartTbx" class="input-date" style="width:75px;z-index:1000;" data-bind="value: start">
        </label>
        <label class="control-label" for="dateEndTbx" data-bind="classes: { hide: showShiftPickers, }" > 
            <asp:localize runat="server" meta:resourcekey="date_end_tbx_label" />
        </label>
        <label class="input-prepend" data-bind="classes: { hide: showShiftPickers, }" > 
            <span class="add-on"><i class="icon-calendar"></i></span>
            <input type="text" id="dateEndTbx" class="input-date" style="width:75px;z-index:1000;" data-bind="value: end">
        </label>
         <label class="control-label" data-bind="classes: { hide: showShiftPickers, }" > 
            <asp:localize runat="server" meta:resourcekey="equipment_data_entry_combo_label" />
            <input autocomplete="off" type="text" class="equipment-input-picker" id="equipmentPicker" style="cursor: pointer;" data-bind="value: equipmentPickerName," placeholder="<asp:Localize runat=server meta:resourcekey=item_equipment_holder />"  readonly />
        </label>
        <label class="control-label" data-bind="classes: { hide: showShiftPickers, }"> 
            <asp:localize runat="server" meta:resourcekey="shift_combo_label" />
            <select style="width:55px;" data-bind="value: shiftId, options: shifts, optionsDefault: { label: '<asp:localize runat=server meta:resourcekey=shift_combo_all_opt />', value: '-'} ">
            </select>
        </label>
        <button id="backNavBtn" class="btn btn-primary " style="margin-bottom:5px;margin-left:10px;" data-bind="classes: { hide: not(showShiftPickers), }">
                    <asp:Localize runat="server" meta:resourcekey="back_item_btn_label" />
        </button> 
        <label class="control-label" data-bind="classes: { hide: not(showShiftPickers), }">
                    <asp:localize runat="server" meta:resourcekey="selected_date_tbx_label" />
        </label>
        <input type="text" style="width:75px; text-align:center; margin-top: -5px;" data-bind="value: selectedDate, classes: { hide: not(showShiftPickers), }" readonly />
       
        <label class="control-label" data-bind="classes: { hide: not(showShiftPickers), }">
                    <asp:localize runat="server" meta:resourcekey="selected_shift_tbx_label" />
        </label>  
        <input type="text" style="width:20px; text-align:center; margin-top: -5px;" data-bind="value: selectedShift, classes: { hide: not(showShiftPickers), }"  readonly />

        <button id="forwardNavBtn" class="btn btn-primary" style="margin-bottom:5px;margin-left:10px;" data-bind="classes: { hide: not(showShiftPickers), }">
                    <asp:Localize runat="server" meta:resourcekey="forward_item_btn_label" />
        </button>
        <label class="control-label" data-bind="classes: { hide: showShiftPickers , }">
            <asp:localize runat="server" meta:resourcekey="crew_combo_label" />
            <select style="width:55px;" data-bind="value: crewId, options: crews, optionsDefault: { label: '<asp:localize runat=server meta:resourcekey=crew_combo_all_opt />', value: '-' } "></select> 
        </label>
        <label class="control-label" data-bind="classes: { hide: showShiftPickers , }">
              <asp:localize runat="server" meta:resourcekey="logEntryType_combo_label" />
        </label>
       <label class="control-label" data-bind="classes: { hide: showShiftPickers , }">
              <span id="types-picker-multi-select" style="width:140px !important"></span>
       </label>
           
        <label class="control-label" data-bind="classes: { hide: showShiftPickers , }">
            <asp:localize runat="server" meta:resourcekey="author_label" />
            <input type="text" style="margin-top:-4px; width:80px;" id="search" data-bind="value: trim(author)," placeholder="<asp:Localize runat=server meta:resourcekey=author_place_holder />"/>
           
        </label>
        <label class="control-label" data-bind="classes: { hide: showShiftPickers , }">
            <asp:localize runat="server" meta:resourcekey="search_label" />
            <input type="text" class="input-large clear-search" style="margin-top:-4px; width:80px;" data-bind="value: trim(searchText)," placeholder="<asp:Localize runat=server meta:resourcekey=search_place_holder />" />
        </label>   
        <button id="refreshBtn" class="btn btn-primary" style="margin-bottom:5px;margin-left:10px;" title="<asp:localize runat=server meta:resourcekey=refresh_btn_title />">
            <i class="fa fa-refresh"></i>
        </button>
        <button id="excelBtn" class="btn btn-excel pull-right" style="margin-left:15px; margin-bottom:2px;" title="<asp:localize runat=server meta:resourcekey=excel_btn_title />">
            <i class="fa fa-file-excel-o"></i>
        </button>
        <div class="pull-right form-inline" style="margin-top:-6px;">
            <button id="addElectrodeBtn" class="btn btn-secondary"  data-bind="disabled:  not(writePermissions)">
                    <asp:Localize runat="server" meta:resourcekey="add_electrode_btn_label" />
            </button>
            <button id="addItemBtn" class="btn btn-secondary">
                    <asp:Localize runat="server" meta:resourcekey="add_item_btn_label" />
            </button>
            <button id="shiftViewBtn" class="btn btn-primary btn-left" data-bind="classes: { hide: showShiftPickers , }">
                    <asp:Localize runat="server" meta:resourcekey="shift_view_btn_label" />
            </button> 
            <button id="searchViewBtn" class="btn btn-primary btn-left" data-bind="classes: { hide: not(showShiftPickers) , }">
                    <asp:Localize runat="server" meta:resourcekey="search_view_btn_label" />
            </button> 
        </div>
    </div>
</div>
<div class="split-left left" style="margin-top:6.1%">
    <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: any(hasData, isLoading), }" style="height:500px;">
        <div class="row-fluid" style="position:relative;top:100px;">
            <i class="fw-icon-circle-blank fw-icon-4x" style="font-size:115px;"></i>
        </div>
        <div class="row-fluid" style="position:relative;top:115px;">
            <h3 style="font-size:50px;">
                <asp:localize runat="server" meta:resourcekey="no_data_available" />
            </h3>
        </div>
    </div>
    <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: not(isLoading), }" style="height:500px;">
        <div class="row-fluid" style="position:relative;top:100px;">
            <i class="fa fa-cog fw-icon-4x fa-spin" style="font-size:115px;"></i>
        </div>
        <div class="row-fluid" style="position:relative;top:115px;">
            <h3 style="font-size:50px;">
                <asp:localize runat="server" meta:resourcekey="loading_data" />
            </h3>
        </div>
    </div>
    <div id="grid-logBook" class="items-grid-container backgrid-container" data-bind="classes: { hideAll: any(not(hasData), isLoading), }"></div>
</div>
       
<div class="split-right right">
    <div data-bind="classes: { hide: (showDataEntryMode), }">     
        <div class="row-fluid" style="margin-top:20%">
            <i class="fw-icon-arrow-left" style="font-size:180px;margin-left:10%;"></i>
        </div>
        <div class="row-fluid" style="text-align: center;">
            <h3 style="font-size:50px;line-height:50px;">
                <asp:localize runat="server" meta:resourcekey="no_item_selected" />
            </h3>
        </div>
    </div> 
    <div id="outer" data-bind="classes: { hideAll: not(showDataEntryMode), }" style="background-color:#e5eaf6">
        <div id="inner_fixed_top">
            <div class="row entry-row"> 
                <div class="span2 entry-div-label" >
                    <label class="control-label col-class entry-label" for="dateEntry" style="padding-right: 0px;">
                        <asp:localize runat="server" meta:resourcekey="date_entry_tbx_label" />
                    </label>
                </div>
                <div class="span2">
                    <label class="input-prepend">
                        <span class="add-on"><i class="icon-calendar"></i></span>
                        <input type="text" id="dateEntry" class="input-date" style="width:75px;z-index:1000;" data-bind="value: itemDate, disabled:  not(writePermissions)">
                    </label>   
                </div>
                <div class="span2 entry-div-label">
                    <label class="control-label col-class entry-label" style="padding-right: 0px;">
                        <asp:localize runat="server" meta:resourcekey="time_data_entry_combo_label" />
                    </label>           
                </div>
                <div class="span2">
                    <div class="input-group bootstrap-timepicker timepicker">
                         <label class="input-prepend"> 
                             <span class="add-on"><i class="icon-time"></i></span>
                            <input id="timepicker1" type="text" class="form-control input-small" data-bind="value: itemTime , disabled:  not(writePermissions)">
                         </label>                        
                    </div>
                </div>
            </div>
            <div class="row entry-row"> 
                <div class="span2 entry-div-label">
                    <label class="control-label col-class entry-label" style="padding-right: 0px;">
                        <asp:localize runat="server" meta:resourcekey="shift_data_entry_combo_label" />
                    </label>
                </div>
                <div class="span2"> 
                    <input type="text" style="width:55px;" data-bind="value: itemShift," readonly/>
                </div>

                <div class="span2 entry-div-label">
                    <label class="control-label col-class entry-label" style="padding-right: 0px;">
                        <asp:localize runat="server" meta:resourcekey="crew_data_entry_combo_label" />
                    </label>           
                </div>
                <div class="span2">
                    <input type="text" style="width:55px;" data-bind="value: itemCrew," readonly />
                </div>
            </div>
            <div class="row entry-row">
                <div class="span2 entry-div-label">
                    <label class="control-label col-class entry-label" style="padding-right: 0px;">
                        <asp:localize runat="server" meta:resourcekey="logEntryType_data_entry_label" />
                    </label>
                </div>
                <div class="span2">
                    <select style="width:110px;" data-bind="value: itemLogEntryType, disabled: true, options: logEntryTypes"/>
                </div>
                <div class="span2 entry-div-label">
                    <label class="control-label col-class entry-label" style="padding-right: 0px;">
                        <asp:localize runat="server" meta:resourcekey="equipment_data_entry_combo_label" />
                    </label>           
                </div>
                <div class="span2">
                    <input autocomplete="off" type="text" class="equipment-input" id="equipmentEntry" style="cursor: pointer;" data-bind="value: equipmentDataEntryName, disabled:  not(writePermissions)" placeholder="<asp:Localize runat=server meta:resourcekey=item_equipment_holder />" readonly />
                </div>
            </div> 
            <div class="row entry-row">
                <div class="span2 entry-div-label">
                    <label class="control-label col-class entry-label" style="padding-right: 0px;">
                        <asp:localize runat="server" meta:resourcekey="authors_data_entry_label" />
                    </label>
                </div>
                <div class="span2">
                    <input type="text" id="input-author" class="input-large clear-search" style="margin-top:-4px; width:110px;" data-bind="value: trim(itemAuthor), disabled:  not(writePermissions)" placeholder="<asp:Localize runat=server meta:resourcekey=authors_data_entry_place_holder />"/>
                </div>
                <div class="span2 entry-div-label">
                    <label class="control-label col-class entry-label" style="padding-right: 0px;">
                        <asp:localize runat="server" meta:resourcekey="title_data_entry_label" />
                    </label> 
                </div>
                 <div class="span2" >
                    <input type="text" id="input-title" class="input-large clear-search" style="margin-top:-4px; width:280px;" data-bind="value: trim(itemTitle)" placeholder="<asp:Localize runat=server meta:resourcekey=title_data_entry_place_holder />" />
                </div>
            </div>
        </div>
        <div id="inner_remaining">
            <label id="textarea-title">
                <asp:localize runat="server" meta:resourcekey="description_data_entry_label" />
            </label>
            <textarea id="entry-textarea" data-bind="value: trim(itemDescription), disabled: not(writePermissions)"></textarea>
        </div>
        <div id="inner_fixed_bottom">
            <div class="row">
                <div class="span8">
                    <button id="saveItemBtn" class="btn btn-primary" data-bind="disabled:  not(writePermissions)">
                        <asp:Localize runat="server" meta:resourcekey="save_item_btn_label" />
                    </button>
                </div>
                <div class ="span4">
                    <button id="deleteItemBtn" class="btn btn-secondary" data-bind="disabled:  not(writePermissions)">
                        <asp:Localize runat="server" meta:resourcekey="delete_item_btn_label" />
                    </button>
                </div>
            </div>
          </div>
    </div>
</div>

<script id="equipment_declare_modal" type="text/x-handlebars-template">
     <link href="<%= ResolveUrl("~/assets/libs/js/multiselect/virtual-select.min.css") %>" rel="stylesheet" />
    <div class="modal-header" style="min-width:700px !important;">    
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times; </button>
        <h3><asp:Localize runat=server meta:resourcekey=equipment_declare_modal_title /></h3>
    </div>
    <div style="padding-bottom:0;padding-top:0; min-width:700px;" class="modal-body">
        <div style="max-height:500px;padding-bottom:0;" class="modal-body">
            <div class="row-fluid">
                <form class="form-horizontal" style="margin-bottom:0;">
                        <div style="height:330px;overflow:auto;" class="equipment-codes-tree cursor-pointer"></div>
                </form>
           </div>
        </div>
    </div>
    <div class="modal-footer" style="min-width:700px;">
        <button id="acceptBtn" class="btn btn-primary" > 
            <asp:Localize runat='server' meta:resourcekey='accept_btn_label' />
        </button>
        <button id="cancelBtn" class="btn" data-dismiss="modal">
            <asp:Localize runat='server' meta:resourcekey='cancel_btn_label' />
        </button>
    </div>
</script>

<script id="add_broken_electrode_modal" type="text/x-handlebars-template">
   
    <div class="modal-header" style="min-width:350px !important;">    
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times; </button>
        <h3><asp:Localize runat=server meta:resourcekey=add_broken_electrode_modal_title /></h3>
    </div>
    <div style="padding-bottom:0;padding-top:0; min-width:350px;" class="modal-body">
            <div style="max-height:500px;padding-bottom:0;" class="modal-body">
                <div class="row-fluid">
                     <div class="span5" style="margin-left:70px;">
                          <label class="control-label col-class entry-label" for="dateEntryElectrode" style="padding-right: 0px;">
                             <asp:localize runat="server" meta:resourcekey="date_entry_tbx_label" />
                         </label>
                         <label class="input-prepend">
                             <span class="add-on"><i class="icon-calendar"></i></span>
                             <input type="text" id="dateEntryElectrode" class="input-date" style="width:75px;z-index:2000;" data-bind="value: itemDate">
                         </label>   
                             
                    </div>
                    <div class="span5">
                         <label class="control-label col-class entry-label" style="padding-right: 0px;">
                        <asp:localize runat="server" meta:resourcekey="time_data_entry_combo_label" />
                    </label>  
                        <div class="input-group bootstrap-timepicker timepicker">
                             <label class="input-prepend"> 
                                 <span class="add-on"><i class="icon-time"></i></span>
                                <input id="timepickerElectrode" type="text" class="form-control input-small" data-bind="value: itemTime">
                             </label>                        
                        </div>
                    </div>
                </div>
            <div class="row-fluid shiftCrewContainer">
                    <div class="span4 electrode-entry-div-label">
                    <label class="control-label col-class entry-label" style="padding-right: 0px;">
                        <asp:localize runat="server" meta:resourcekey="shift_data_entry_combo_label" />
                         <input type="text" style="width:55px;" data-bind="value: itemShift," readonly/>
                    </label>
                    </div>
                  

                    <div class="span4 electrode-entry-div-label crewContainer">
                        <label class="control-label col-class entry-label" style="padding-right: 0px;">
                            <asp:localize runat="server" meta:resourcekey="crew_data_entry_combo_label" />
                            <input type="text" style="width:55px;" data-bind="value: itemCrew," readonly />
                        </label>       
                        
                    </div>
                        
            </div>
            <div class="row-fluid heatContainer">
                <div style="margin-top:5px; padding-top:5px;" class="control-label col-class entry-label">
                    Heat
                </div>
                <label class="control-label" style="width:200px;">
                <div id="heat-picker-multi-select"></div>
                </label>
           </div>
            
            <div class="row-fluid electrodeCheckContainer">
                <div style="margin-top:5px; padding-top:5px;" class="span4 control-group form-inline">
                <label class="control-label col-class entry-label" style="padding-right: 0px;">
                Electrode A
                </label>
                     <input type="checkbox" id="electrode1Check" class="electrode-checkbox" />
                </div>
                <div style="margin-top:5px; padding-top:5px;" class="span4 control-group form-inline">
                <label class="control-label col-class entry-label" style="padding-right: 0px;">
                Electrode B
                </label>
                     <input type="checkbox"  id="electrode2Check" class="electrode-checkbox" />
                </div>
                 <div style="margin-top:5px; padding-top:5px;" class="span4 control-group form-inline">
                <label class="control-label col-class entry-label" style="padding-right: 0px;">
                Electrode C
                </label>
                     <input type="checkbox"  id="electrode3Check" class="electrode-checkbox" />
                </div>
            </div>
            <div class="row-fluid">
                <label class="control-label col-class entry-label" style="padding-right: 0px;">
                <asp:localize runat="server" meta:resourcekey="electrode_description_entry_combo_label" />
                </label>      
                <div style="margin-top:5px; padding-top:5px;" class="span4 control-group form-inline">
                        <textarea class="electrode-description" data-bind="value: itemDescription"></textarea>
                </div>
            </div>
                
        </div>
    </div>
    <div class="modal-footer" style="min-width:350px;">
        <button id="addBrkElectrodeBtn" class="btn btn-primary" > 
            <asp:Localize runat='server' meta:resourcekey='accept_btn_label' />
        </button>
        <button id="cancelBrkElectrodeBtn" class="btn" data-dismiss="modal">
            <asp:Localize runat='server' meta:resourcekey='cancel_btn_label' />
        </button>
    </div>
</script>