﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
//@Override this is suggested by Microsoft, overriding the initialize culture function (that is
//automatically called by the aspx.
//Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
//(English).
protected override void InitializeCulture()
{
    HttpCookie lang = Request.Cookies["siteLanguage"]; 
    
    String selectedLanguage = (lang != null) ? lang.Value : "en";
    UICulture = selectedLanguage ;
    Culture = selectedLanguage ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(selectedLanguage);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(selectedLanguage);
    base.InitializeCulture();
}
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
    
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>
<script id="main_template" type="text/x-handlebars-template">
<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/extensions/valid-min-max-cell/backgrid-valid-min-max-cell.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/app/custom-screens/scrapyard/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + ".css")%>" rel="stylesheet" />



<style>

    .clickeable-row{
        cursor:pointer; 
    }

    .backgrid th{
        font-size:12px !important;
    }

    .backgrid tr{
        font-size:12px !important;
    }

    .backgrid tr td{
        overflow:visible !important; 
    }

    .backgrid tr td button{
        font-size:12px !important;
    }

</style>

<div class="container-fluid">
    <div class="row-fluid"  style="margin-bottom:20px;">
        <div class="row-fluid">
            <div style="margin-top:7%;" class="row-fluid loading-poster text-center">
                <div style="width:40%; margin: 0 auto;" class="progress progress-striped active">
                    <div class="bar" style="width: 100%;"></div>
                </div>
            </div>
            <div class="row-fluid">
                <div class="items-grid-container hide ">
                </div>
            </div>
        </div>
    </div>
    <div class="row-fluid" >
        <div class="row-fluid">
            <div class="offset2 span10 item-grid-container infinite-container"></div>
        </div>
    </div>
</div>

</script>

<script type="text/x-handlebars-template" id="subnavbar_controls">
    <div class="span6">
        <div>
            <div style="float:left;width:200px;top:4px;position:relative;" >
                <div style="width:50px;float:left;text-align:right;">
                    <span style="top:5px;position:relative;">
                        <asp:Localize runat="server" meta:resourcekey="from_label" />
                    </span>
                </div>
                <div style="width:150px;float:left;margin-left:-10px;" class="from-date-control-container">
                </div>
            </div>
            <div style="float:left;width:200px;top:4px;position:relative;" >
                <div style="width:50px;float:left;text-align:right;">
                    <span style="top:5px;position:relative;"><asp:Localize runat="server" meta:resourcekey="to_label" /></span>
                </div>
                <div style="width:150px;float:left;margin-left:-10px;" class="to-date-control-container">
                </div>
            </div>
        </div>
    </div>
    <div class="span6">
        <div class="subnavbar-right-toolbar">
            <div style="display: inline-block; height: 40px;" class="pull-right">
                <div style="float:left;position:relative;margin-left:8px;top:5px;" >
                    <button style="margin-top:0;" class="btn btn-refresh" type="button">
                        <span class="fa fa-refresh"></span>
                        <asp:Localize runat="server" meta:resourcekey="refresh_label" />
                    </button>
                </div>

                <div style="float:left;position:relative; top:5px;margin-left:8px;">
                    <button style="margin-top:0;" class="btn btn-export-to-excel" type="button">
                        <span class="excel-export-state fa fa-file-excel-o"></span>
                        <img class="loading-state hide" style="width:20px;height:20px;" src="<%= ResolveUrl("~/assets/img/spinner20.gif") %>" />
                    </button>
                </div>                
            </div>
            <%--<div style="display: inline-block; height: 40px;" class="pull-right">
                <div style="position:relative; top:-3px;margin-left:8px;" class="toolbar-filter">
                    <button style="margin-top:0;" class="btn btn-export-to-excel" type="button">
                        <span class="excel-export-state fa fa-file-excel-o"></span>
                        <img class="loading-state hide" style="width:20px;height:20px;" src="<%= ResolveUrl("~/assets/img/spinner20.gif") %>" />
                    </button>
                </div>
            </div>--%>
        </div>
    </div>
</script>