-------------
-- ROLES
-------------
	USE [IHBoxSystem]
	GO
	CREATE ROLE silos_configuration_read AUTHORIZATION dbo 
	GO  

	USE [IHBoxSystem]
	GO
	EXEC sp_addrolemember 'silos_configuration_read', 'admin'
	GO

	USE [IHBoxSystem]
	GO
	EXEC sp_addrolemember 'silos_configuration_read', 'SDI/australtek'
	GO


	CREATE ROLE silos_configuration_readWrite AUTHORIZATION dbo 
	GO  

	USE [IHBoxSystem]
	GO
	EXEC sp_addrolemember 'silos_configuration_readWrite', 'admin'
	GO

	USE [IHBoxSystem]
	GO
	EXEC sp_addrolemember 'silos_configuration_readWrite', 'SDI/australtek'
	GO


-------------------
-- Menu and Route
-------------------
	declare @parent int, @result_routeId INT
	select @parent=id from [FrontEnd].[Menu] where [Name] = 'MES Configuration' and Parent is null

	INSERT INTO [FrontEnd].[Routes]
			   ([Route]
			   ,[ModuleName]
			   ,[ModulePath]
			   ,[RequiredRole]
		   )
		 VALUES 
			   (
			   '!/silos-configuration(/)'
			   , 'silos-configuration'
			   , 'custom-screens/silos-configuration/'
			   , 'silos_configuration_readWrite'           
			   )
			   SET @result_routeId = @@IDENTITY
	INSERT INTO [FrontEnd].[Menu]
			   ([Parent]
			   ,[Name]
			   ,[RouteID]
			   ,[SortOrder]
			   ,[Enabled]
			   ,[Visible]
			   ,[RequiredRole]
			   ,[Group]
			  )
		 VALUES
			   (
			   @parent
			   ,'Silos Configuration'
			   ,@result_routeId 
			   ,1
			   ,1
			   ,1
			   ,'silos_configuration_readWrite'
			   ,NULL
			 )
	GO


-------------------
-- SP Permissions
-------------------
EXECUTE sys.sp_addextendedproperty 
@level0type = N'USER' -- The object type
,@level0name = [silos_configuration_readWrite] -- The role
,@name = N'securedsp-MES.GetSilosConfiguration' -- the procedure
,@value = N'' 
GO

EXECUTE sys.sp_addextendedproperty 
@level0type = N'USER' -- The object type
,@level0name = [silos_configuration_read] -- The role
,@name = N'securedsp-MES.GetSilosConfiguration' -- the procedure
,@value = N'' 
GO
EXECUTE sys.sp_addextendedproperty 
@level0type = N'USER' -- The object type
,@level0name = [silos_configuration_readWrite] -- The role
,@name = N'securedsp-MES.UpdateSilosConfiguration' -- the procedure
,@value = N'SendCurrentUser=TRUE' 
GO

-------------------
--	Profiles
-------------------
	USE [IHBoxSystem]
	GO

	DECLARE @ModuleId INT

	INSERT INTO [SECURITY].[Modules]([Code],[Name])
	VALUES('silos_configuration','Silos Configuration')

	SET @ModuleId = @@IDENTITY

	INSERT INTO [SECURITY].[ModuleActions]([ModuleId],[Code],[Name],[Role])
	VALUES(@ModuleId,'readWrite','Read/Write','silos_configuration_readWrite')


	INSERT INTO [SECURITY].ModuleActions(ModuleId,Code,[Name],[Role])
	VALUES (@ModuleId,'read','Read','silos_configuration_read')



-------------------------------------------------------------------
-- Steps to follow to add a new screen in MES Configuration Section
-------------------------------------------------------------------

update FrontEnd.Menu
set [Code]='silos-configuration',
IHBoxModule = 'MES',
[RouteId]= 9
where [Name] = 'Silos Configuration'

update FrontEnd.[Routes]
set [Route] = 'silos-configuration',
[Group] = 'configuration-dashboard'
where [ModuleName] = 'silos-configuration'


 insert into [FrontEnd].MenuProperties(MenuId,[Name],[Value])
 values(
 (select top 1 Id from FrontEnd.Menu where [Name] = 'Silos Configuration'),('data-screenid'),('silos-configuration')
)



 insert into [FrontEnd].[MenuLinkParameters]([MenuLinkID],[Name],[Value])
 values(
 (select top 1 Id from FrontEnd.Menu where [Name] = 'Silos Configuration'),('section'),('silos-configuration')
)

