﻿define([
  'app',
  'modules/catalog/catalog',
],
function (app, Catalog) {

    var Main = {
        Models: {},
        Collections: {},
    };


    var chemistryElements = {};

    _.each(app.alloysChemistryElements, function (obj) {
        chemistryElements[obj] = null;
    });


    (function () {
        var superRef, superProto, classRef;

        superRef = Catalog.Models.Catalog;
        superProto = superRef.prototype;

        Main.Models.Alloy = classRef = superRef.extend({
            defaults: _.extend(
                {},
                superProto.defaults,
                chemistryElements,
                {
                    formId: null,
                    unitWeight: null,
                    recoveryFactor: null,
                    chillFactor: null,
                    oxygenFactor: null,
                    energyEquivalent: null,
                    accountingId: null,
                }
            ),
            procedures: {
                get: app.DatabaseNames.MES + '.CAT.GetAlloys',
            },

            parse: function (obj) {
                var ret = {};

                _.each(app.alloysChemistryElements, function (el) {
                    ret[el] = obj[el];
                });

                return _.extend(superProto.parse.apply(this, arguments),
                    ret,
                    {
                        formId: obj.FormId,
                        unitWeight: obj.UnitWeight,
                        recoveryFactor: obj.RecoveryFactor,
                        chillFactor: obj.ChillFactor,
                        oxygenFactor: obj.OxygenFactor,
                        energyEquivalent: obj.EnergyEquivalent,
                        accountingId: obj.AccountingId,
                    }
                );
            },
        });
    })();

    (function () {
        var superRef, superProto, classRef;

        superRef = Catalog.Collections.Catalogs;
        superProto = superRef.prototype;

        Main.Collections.Alloys = classRef = superRef.extend({
            model: Main.Models.Alloy,
        });
        _.extend(classRef, {
            fetch: function (options) {
                var opt = _.extend(
                        { error: function () { }, success: function () { }, },
                        options
                    );

                classRef.prototype.getData.apply(classRef.prototype, [_.extend(
                    {},
                    opt,
                    {
                        success: function (resp) {
                            if (resp.Table) {
                                opt.success(_.map(resp.Table, classRef.prototype.model.prototype.parse));
                            }
                            else {
                                var msg = (resp.Message) ? resp.Message : 'Can not fetch alloys.';

                                console.error(new Error(msg).stack);
                                opt.error(msg);
                            }
                        },
                    }
                )]);
            },
        });
    })();

    // Required, return the module for AMD compliance.
    return Main;

});