﻿define([
  'app',
    'modules/base/base',
    'moment',
],
function (app, Base, moment) {

    var Main = {
        Models: {},
        Collections: {},
    };

    (function () {
        var superRef, superProto, classRef;

        superRef = Base.Models.Base;
        superProto = superRef.prototype;

        Main.Models.EafProcessPhase = classRef = superRef.extend({
            defaults: _.extend(
                {},
                superProto.defaults,
                {
                    id: null,

                    processId: null,

                    code: null,
                    order: null,

                    duration: null,
                    processDuration: null,
                    carbon: null,
                    energy: null,
                    oxygen: null,
                    o2ss: null,
                    naturalGas: null,
                    timestamp: null,

                    formattedDuration: null,
                }
            ),
            procedures: {
                get: app.DatabaseNames.MES + '.EAF.GetPhases',
            },

            parse: function (obj) {
                return {
                    id: obj.Id,

                    processId: obj.ProcessId,

                    code: obj.Code,
                    order: obj.Order,

                    duration: obj.Duration,
                    carbon: obj.Carbon,
                    energy: obj.Energy,
                    oxygen: obj.Oxygen,
                    o2ss: obj.O2SS,
                    naturalGas: obj.NaturalGas,
                    processDuration: obj.ProcessDuration,
                    timestamp: obj.TimestampString,
                    formattedDuration: moment.duration(obj.Duration, 'seconds').get('minutes') + ':' + moment.duration(obj.Duration, 'seconds').get('seconds'),
                };
            },
        });
    })();

    (function () {
        var superRef, superProto, classRef;

        superRef = Base.Collections.Base;
        superProto = superRef.prototype;

        Main.Collections.EafProcessPhases = classRef = superRef.extend({
            model: Main.Models.EafProcessPhase,
            comparator: 'order',
        });
    })();

    // Required, return the module for AMD compliance.
    return Main;

});