﻿define([
  'app',
  'modules/base',
],
function (app, Base) {

    var Main = {
        Models: {},
        Collections: {},
    };

    (function () {
        var superRef, superProto, classRef;

        superRef = Base.Models.Base;
        superProto = superRef.prototype;

        Main.Models.EquipmentHistory = classRef = superRef.extend({
            defaults: _.extend(
                {},
                superProto.defaults,
                {
                    date: null,
                    equipment: null,
                    prevStatus: null,
                    curStatus: null,
                    comments: null,
                    user: null,
                    start: null,
                    end: null,
                    equipmentTypeName: null,
                }
            ),
            procedures: {
                get: app.DatabaseNames.ELT + '.WebApp.GetEquipmentsHistory',
            },
            parse: function (obj) {
                return {
                    date: obj.TimestampString,
                    event: (obj.Event) ? app.translate([app], obj.Event + '_label') : null,
                    equipment: obj.EquipmentName,
                    prevStatus: (obj.PreviousStatusName) ? app.translate([app], obj.PreviousStatusName + '_label') : null,
                    curStatus: (obj.CurrentStatusName) ? app.translate([app], obj.CurrentStatusName + '_label') : null,
                    comments: obj.Comments,
                    user: obj.UserName,
                    equipmentTypeName: obj.EquipmentTypeName,
                };
            }
        });
    })();


    (function () {
        var superRef, superProto, classRef;

        superRef = Base.Collections.Base;
        superProto = superRef.prototype;

        Main.Collections.EquipmentsHistory = classRef = superRef.extend({
            model: Main.Models.EquipmentHistory,
        });
    })();

    // Required, return the module for AMD compliance.
    return Main;

});