﻿define([
    'app',
    'modules/base/base',
],
    function (app, Base) {

        var Main = {
            Models: {},
            Collections: {},
        };

        (function () {
            var superRef, superProto, classRef;

            superRef = Base.Models.Base;
            superProto = superRef.prototype;

            Main.Models.EquipmentLog = classRef = superRef.extend({
                defaults: _.extend(
                    {},
                    superProto.defaults,
                    {
                        id: null,
                        timestamp: null,
                        shift: null,
                        crew: null,
                        user: null,
                        equipment: null,
                        comment: null,
                        status: null,


                    }
                ),
                procedures: {
                    create: app.DatabaseNames.MES + '.EQUIP.CreateEquipmentLog',
                    get: app.DatabaseNames.MES + '.EQUIP.GetEquipmentLogs',
                    update: app.DatabaseNames.MES + '.EQUIP.UpdateEquipmentLog',
                    remove: app.DatabaseNames.MES + '.EQUIP.RemoveEquipmentLog',
                },

                parse: function (obj) {
                    var ret = {};

                    return _.extend(
                        ret,
                        {
                            id: obj.Id,

                            timestamp: obj.Timestamp,
                            shift: obj.Shift,
                            crew: obj.Crew,
                            user: obj.User,
                            equipment: obj.Equipment,
                            comment: obj.Comment,
                            status: obj.Status,

                        }
                    );
                },
            });
        })();

        (function () {
            var superRef, superProto, classRef;

            superRef = Base.Collections.Base;
            superProto = superRef.prototype;

            Main.Collections.EquipmentLogs = classRef = superRef.extend({
                model: Main.Models.EquipmentLog,
            });
        })();

        // Required, return the module for AMD compliance.
        return Main;

    });