﻿define([
  // Application.
  "app",

  //templates-loader
  "js/templates-loader"

],

function (app, T) {

    var NotFound = { Model: {}, Views: {} }

    NotFound.Model = Backbone.Model.extend({
        defaults: {}
    });

    NotFound.Views.Main = Backbone.View.extend({
        template: "notFound/notFound"
        , id: "not-found"
        , title: "Not Found :("
        , isCacheable: false
        , initialize: function () {
        },        
        render: function (container) {
            var that = this;
            var thatContainer = container;
            T.render.call(this, this.template, function (tmp) {
                that.$el.html(tmp());
                thatContainer.append(that.$el);
            });
        }
        , close: function () {
            this.remove();
            this.unbind();
        }
        , show: function () {
            this.$el.show();
        }
        , hide: function () {
            this.$el.hide();
        }
    });

    // Required, return the module for AMD compliance.
    return NotFound;

});
