﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" %>

<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
//@Override this is suggested by Microsoft, overriding the initialize culture function (that is
//automatically called by the aspx.
//Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
//(English).
protected override void InitializeCulture()
{
    HttpCookie lang = Request.Cookies["siteLanguage"]; 
    
    String selectedLanguage = (lang != null) ? lang.Value : "en";
    UICulture = selectedLanguage ;
    Culture = selectedLanguage ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(selectedLanguage);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(selectedLanguage);
    base.InitializeCulture();
}
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
    
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<link href="<%= ResolveUrl("~/assets/css/jquery-ui/jquery-ui-1.10.3.custom.css") %>" rel="stylesheet" />

<style>
    .date-time-control .input-prepend .add-on {
        border-radius: 4px 0 0 4px;
    }
</style>

<div class="container-fluid date-time-control" style="padding-left:0px;">
    <div class="row-fluid">
        <div class="jqueryUIcontrols span12">
            <div class="control-group form-inline">
                <div class="input-prepend" style="margin-bottom:0px;">
                    <span id="datetime_calendar-icon-clickeable" style="cursor:pointer;" class="add-on"><i class="icon-calendar"></i></span>
                    <input id="datetime_datePicker" class="input-small" type="text">
                </div>
                <div class="input-prepend bootstrap-timepicker" style="margin-bottom:0px;margin-left:5px;">
                    <span id="datetime_time-icon-clickeable" style="cursor:pointer;" class="add-on"><i class="icon-time"></i></span>
                    <input id="datetime_timePicker" class="input-small" type="text">
                </div>
            </div>
        </div>
    </div>
</div>